# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
+    public abstract class JsonConverter {
+        public abstract bool CanConvert(Type typeToConvert);
+    }
+    public abstract class JsonConverter<T> : JsonConverter {
+        protected internal JsonConverter();
+        public override bool CanConvert(Type typeToConvert);
+        public abstract T Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options);
+        public abstract void Write(Utf8JsonWriter writer, T value, JsonSerializerOptions options);
+    }
+    public class JsonConverterAttribute : JsonAttribute {
+        protected JsonConverterAttribute();
+        public JsonConverterAttribute(Type converterType);
+        public Type ConverterType { get; }
+        public virtual JsonConverter CreateConverter(Type typeToConvert);
+    }
+    public abstract class JsonConverterFactory : JsonConverter {
+        protected internal JsonConverterFactory();
+        protected abstract JsonConverter CreateConverter(Type typeToConvert);
+    }
-    public abstract class JsonNamingPolicy {
 {
-        protected JsonNamingPolicy();

-        public static JsonNamingPolicy CamelCase { get; }

-        public abstract string ConvertName(string name);

-    }
-    public static class JsonSerializer {
 {
-        public static object Parse(ReadOnlySpan<byte> utf8Json, Type returnType, JsonSerializerOptions options = null);

-        public static object Parse(string json, Type returnType, JsonSerializerOptions options = null);

-        public static TValue Parse<TValue>(ReadOnlySpan<byte> utf8Json, JsonSerializerOptions options = null);

-        public static TValue Parse<TValue>(string json, JsonSerializerOptions options = null);

-        public static ValueTask<object> ReadAsync(Stream utf8Json, Type returnType, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));

-        public static ValueTask<TValue> ReadAsync<TValue>(Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));

-        public static object ReadValue(ref Utf8JsonReader reader, Type returnType, JsonSerializerOptions options = null);

-        public static TValue ReadValue<TValue>(ref Utf8JsonReader reader, JsonSerializerOptions options = null);

-        public static string ToString(object value, Type type, JsonSerializerOptions options = null);

-        public static string ToString<TValue>(TValue value, JsonSerializerOptions options = null);

-        public static byte[] ToUtf8Bytes(object value, Type type, JsonSerializerOptions options = null);

-        public static byte[] ToUtf8Bytes<TValue>(TValue value, JsonSerializerOptions options = null);

-        public static Task WriteAsync(object value, Type type, Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));

-        public static Task WriteAsync<TValue>(TValue value, Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));

-    }
-    public sealed class JsonSerializerOptions {
 {
-        public JsonSerializerOptions();

-        public bool AllowTrailingCommas { get; set; }

-        public int DefaultBufferSize { get; set; }

-        public JsonNamingPolicy DictionaryKeyPolicy { get; set; }

-        public bool IgnoreNullValues { get; set; }

-        public bool IgnoreReadOnlyProperties { get; set; }

-        public int MaxDepth { get; set; }

-        public bool PropertyNameCaseInsensitive { get; set; }

-        public JsonNamingPolicy PropertyNamingPolicy { get; set; }

-        public JsonCommentHandling ReadCommentHandling { get; set; }

-        public bool WriteIndented { get; set; }

-    }
+    public sealed class JsonStringEnumConverter : JsonConverterFactory {
+        public JsonStringEnumConverter();
+        public JsonStringEnumConverter(JsonNamingPolicy namingPolicy = null, bool allowIntegerValues = true);
+        public override bool CanConvert(Type typeToConvert);
+        protected override JsonConverter CreateConverter(Type typeToConvert);
+    }
 }
```

