# System.Text.Json

``` diff
 namespace System.Text.Json {
     public sealed class JsonDocument : IDisposable {
+        public void WriteTo(Utf8JsonWriter writer);
     }
     public readonly struct JsonElement {
-        public void WriteProperty(ReadOnlySpan<byte> utf8PropertyName, Utf8JsonWriter writer);

-        public void WriteProperty(ReadOnlySpan<char> propertyName, Utf8JsonWriter writer);

-        public void WriteProperty(string propertyName, Utf8JsonWriter writer);

-        public void WriteProperty(JsonEncodedText propertyName, Utf8JsonWriter writer);

+        public void WriteTo(Utf8JsonWriter writer);
-        public void WriteValue(Utf8JsonWriter writer);

     }
     public readonly struct JsonEncodedText : IEquatable<JsonEncodedText> {
-        public static JsonEncodedText Encode(ReadOnlySpan<byte> utf8Value);

+        public static JsonEncodedText Encode(ReadOnlySpan<byte> utf8Value, JavaScriptEncoder encoder = null);
-        public static JsonEncodedText Encode(ReadOnlySpan<char> value);

+        public static JsonEncodedText Encode(ReadOnlySpan<char> value, JavaScriptEncoder encoder = null);
-        public static JsonEncodedText Encode(string value);

+        public static JsonEncodedText Encode(string value, JavaScriptEncoder encoder = null);
     }
     public readonly struct JsonProperty {
+        public void WriteTo(Utf8JsonWriter writer);
     }
     public static class JsonSerializer {
-        public static string Serialize(object value, Type inputType, JsonSerializerOptions options = null);
+        public static string Serialize(object value, Type type, JsonSerializerOptions options = null);
-        public static void Serialize(Utf8JsonWriter writer, object value, Type inputType, JsonSerializerOptions options = null);
+        public static void Serialize(Utf8JsonWriter writer, object value, Type type, JsonSerializerOptions options = null);
-        public static Task SerializeAsync(Stream utf8Json, object value, Type inputType, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task SerializeAsync(Stream utf8Json, object value, Type type, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
-        public static byte[] SerializeToUtf8Bytes(object value, Type inputType, JsonSerializerOptions options = null);
+        public static byte[] SerializeToUtf8Bytes(object value, Type type, JsonSerializerOptions options = null);
     }
     public sealed class JsonSerializerOptions {
+        public JavaScriptEncoder Encoder { get; set; }
     }
     public struct JsonWriterOptions {
+        public JavaScriptEncoder Encoder { get; set; }
     }
 }
```

