# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public class AuthorizeView : AuthorizeViewCore {
-        public string Policy { get; private set; }
+        public string Policy { get; set; }
-        public object Resource { get; private set; }

-        public string Roles { get; private set; }
+        public string Roles { get; set; }
     }
     public abstract class AuthorizeViewCore : ComponentBase {
-        public AuthorizeViewCore();
+        protected AuthorizeViewCore();
-        public RenderFragment<AuthenticationState> Authorized { get; private set; }
+        public RenderFragment<AuthenticationState> Authorized { get; set; }
-        public RenderFragment Authorizing { get; private set; }
+        public RenderFragment Authorizing { get; set; }
-        public RenderFragment<AuthenticationState> ChildContent { get; private set; }
+        public RenderFragment<AuthenticationState> ChildContent { get; set; }
-        public RenderFragment<AuthenticationState> NotAuthorized { get; private set; }
+        public RenderFragment<AuthenticationState> NotAuthorized { get; set; }
+        public object Resource { get; set; }
     }
+    public static class BindConverter {
+        public static bool FormatValue(bool value, CultureInfo culture = null);
+        public static string FormatValue(DateTime value, CultureInfo culture = null);
+        public static string FormatValue(DateTime value, string format, CultureInfo culture = null);
+        public static string FormatValue(DateTimeOffset value, CultureInfo culture = null);
+        public static string FormatValue(DateTimeOffset value, string format, CultureInfo culture = null);
+        public static string FormatValue(Decimal value, CultureInfo culture = null);
+        public static string FormatValue(double value, CultureInfo culture = null);
+        public static string FormatValue(int value, CultureInfo culture = null);
+        public static string FormatValue(long value, CultureInfo culture = null);
+        public static Nullable<bool> FormatValue(Nullable<bool> value, CultureInfo culture = null);
+        public static string FormatValue(Nullable<DateTime> value, CultureInfo culture = null);
+        public static string FormatValue(Nullable<DateTime> value, string format, CultureInfo culture = null);
+        public static string FormatValue(Nullable<DateTimeOffset> value, CultureInfo culture = null);
+        public static string FormatValue(Nullable<DateTimeOffset> value, string format, CultureInfo culture = null);
+        public static string FormatValue(Nullable<Decimal> value, CultureInfo culture = null);
+        public static string FormatValue(Nullable<double> value, CultureInfo culture = null);
+        public static string FormatValue(Nullable<int> value, CultureInfo culture = null);
+        public static string FormatValue(Nullable<long> value, CultureInfo culture = null);
+        public static string FormatValue(Nullable<float> value, CultureInfo culture = null);
+        public static string FormatValue(float value, CultureInfo culture = null);
+        public static string FormatValue(string value, CultureInfo culture = null);
+        public static object FormatValue<T>(T value, CultureInfo culture = null);
+        public static bool TryConvertTo<T>(object obj, CultureInfo culture, out T value);
+        public static bool TryConvertToBool(object obj, CultureInfo culture, out bool value);
+        public static bool TryConvertToDateTime(object obj, CultureInfo culture, out DateTime value);
+        public static bool TryConvertToDateTime(object obj, CultureInfo culture, string format, out DateTime value);
+        public static bool TryConvertToDateTimeOffset(object obj, CultureInfo culture, out DateTimeOffset value);
+        public static bool TryConvertToDateTimeOffset(object obj, CultureInfo culture, string format, out DateTimeOffset value);
+        public static bool TryConvertToDecimal(object obj, CultureInfo culture, out Decimal value);
+        public static bool TryConvertToDouble(object obj, CultureInfo culture, out double value);
+        public static bool TryConvertToFloat(object obj, CultureInfo culture, out float value);
+        public static bool TryConvertToInt(object obj, CultureInfo culture, out int value);
+        public static bool TryConvertToLong(object obj, CultureInfo culture, out long value);
+        public static bool TryConvertToNullableBool(object obj, CultureInfo culture, out Nullable<bool> value);
+        public static bool TryConvertToNullableDateTime(object obj, CultureInfo culture, out Nullable<DateTime> value);
+        public static bool TryConvertToNullableDateTime(object obj, CultureInfo culture, string format, out Nullable<DateTime> value);
+        public static bool TryConvertToNullableDateTimeOffset(object obj, CultureInfo culture, out Nullable<DateTimeOffset> value);
+        public static bool TryConvertToNullableDateTimeOffset(object obj, CultureInfo culture, string format, out Nullable<DateTimeOffset> value);
+        public static bool TryConvertToNullableDecimal(object obj, CultureInfo culture, out Nullable<Decimal> value);
+        public static bool TryConvertToNullableDouble(object obj, CultureInfo culture, out Nullable<double> value);
+        public static bool TryConvertToNullableFloat(object obj, CultureInfo culture, out Nullable<float> value);
+        public static bool TryConvertToNullableInt(object obj, CultureInfo culture, out Nullable<int> value);
+        public static bool TryConvertToNullableLong(object obj, CultureInfo culture, out Nullable<long> value);
+        public static bool TryConvertToString(object obj, CultureInfo culture, out string value);
+    }
     public sealed class BindInputElementAttribute : Attribute {
-        public BindInputElementAttribute(string type, string suffix, string valueAttribute, string changeAttribute);

+        public BindInputElementAttribute(string type, string suffix, string valueAttribute, string changeAttribute, bool isInvariantCulture, string format);
+        public string Format { get; }
+        public bool IsInvariantCulture { get; }
     }
-    public static class BindMethods {
 {
-        public static EventCallback GetEventHandlerValue<T>(EventCallback value) where T : UIEventArgs;

-        public static EventCallback<T> GetEventHandlerValue<T>(EventCallback<T> value) where T : UIEventArgs;

-        public static MulticastDelegate GetEventHandlerValue<T>(Action value) where T : UIEventArgs;

-        public static MulticastDelegate GetEventHandlerValue<T>(Action<T> value) where T : UIEventArgs;

-        public static MulticastDelegate GetEventHandlerValue<T>(Func<Task> value) where T : UIEventArgs;

-        public static MulticastDelegate GetEventHandlerValue<T>(Func<T, Task> value) where T : UIEventArgs;

-        public static string GetEventHandlerValue<T>(string value) where T : UIEventArgs;

-        public static string GetValue(DateTime value, string format);

-        public static T GetValue<T>(T value);

-        public static Action<UIEventArgs> SetValueHandler(Action<bool> setter, bool existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<DateTime> setter, DateTime existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<DateTime> setter, DateTime existingValue, string format);

-        public static Action<UIEventArgs> SetValueHandler(Action<Decimal> setter, Decimal existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<double> setter, double existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<int> setter, int existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<long> setter, long existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<Nullable<bool>> setter, Nullable<bool> existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<Nullable<Decimal>> setter, Nullable<Decimal> existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<Nullable<double>> setter, Nullable<double> existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<Nullable<int>> setter, Nullable<int> existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<Nullable<long>> setter, Nullable<long> existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<Nullable<float>> setter, Nullable<float> existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<float> setter, float existingValue);

-        public static Action<UIEventArgs> SetValueHandler(Action<string> setter, string existingValue);

-        public static Action<UIEventArgs> SetValueHandler<T>(Action<T> setter, T existingValue);

-    }
     public class CascadingAuthenticationState : ComponentBase, IDisposable {
-        public RenderFragment ChildContent { get; private set; }
+        public RenderFragment ChildContent { get; set; }
-        protected override void OnInit();

+        protected override void OnInitialized();
     }
     public class CascadingValue<T> : IComponent {
-        public RenderFragment ChildContent { get; private set; }
+        public RenderFragment ChildContent { get; set; }
-        public bool IsFixed { get; private set; }
+        public bool IsFixed { get; set; }
-        public string Name { get; private set; }
+        public string Name { get; set; }
-        public T Value { get; private set; }
+        public T Value { get; set; }
+        public void Attach(RenderHandle renderHandle);
-        public void Configure(RenderHandle renderHandle);

-        public Task SetParametersAsync(ParameterCollection parameters);

+        public Task SetParametersAsync(ParameterView parameters);
     }
     public abstract class ComponentBase : IComponent, IHandleAfterRender, IHandleEvent {
-        protected Task Invoke(Action workItem);

+        protected Task InvokeAsync(Action workItem);
+        void Microsoft.AspNetCore.Components.IComponent.Attach(RenderHandle renderHandle);
-        void Microsoft.AspNetCore.Components.IComponent.Configure(RenderHandle renderHandle);

-        protected virtual void OnInit();

-        protected virtual Task OnInitAsync();

+        protected virtual void OnInitialized();
+        protected virtual Task OnInitializedAsync();
-        public virtual Task SetParametersAsync(ParameterCollection parameters);

+        public virtual Task SetParametersAsync(ParameterView parameters);
     }
+    public abstract class Dispatcher {
+        protected Dispatcher();
+        public abstract bool CheckAccess();
+        public static Dispatcher CreateDefault();
+        public abstract Task InvokeAsync(Action workItem);
+        public abstract Task InvokeAsync(Func<Task> workItem);
+        public abstract Task<TResult> InvokeAsync<TResult>(Func<Task<TResult>> workItem);
+        public abstract Task<TResult> InvokeAsync<TResult>(Func<TResult> workItem);
+        protected void OnUnhandledException(UnhandledExceptionEventArgs e);
+    }
-    public readonly struct ElementRef {
 {
-        public string __internalId { get; }

-    }
+    public readonly struct ElementReference
     public readonly struct EventCallback<T> {
+        public static readonly EventCallback<T> Empty;
     }
     public sealed class EventCallbackFactory {
-        public string Create<T>(object receiver, string callback);

     }
     public static class EventCallbackFactoryBinderExtensions {
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<bool> setter, bool existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<bool> setter, bool existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue, string format);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTime> setter, DateTime existingValue, string format, CultureInfo culture = null);
+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset> setter, DateTimeOffset existingValue, CultureInfo culture = null);
+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateTimeOffset> setter, DateTimeOffset existingValue, string format, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Decimal> setter, Decimal existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Decimal> setter, Decimal existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<double> setter, double existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<double> setter, double existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<int> setter, int existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<int> setter, int existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<long> setter, long existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<long> setter, long existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<bool>> setter, Nullable<bool> existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<bool>> setter, Nullable<bool> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTime>> setter, Nullable<DateTime> existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTime>> setter, Nullable<DateTime> existingValue, CultureInfo culture = null);
+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTime>> setter, Nullable<DateTime> existingValue, string format, CultureInfo culture = null);
+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTimeOffset>> setter, Nullable<DateTimeOffset> existingValue, CultureInfo culture = null);
+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<DateTimeOffset>> setter, Nullable<DateTimeOffset> existingValue, string format, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<Decimal>> setter, Nullable<Decimal> existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<Decimal>> setter, Nullable<Decimal> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<double>> setter, Nullable<double> existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<double>> setter, Nullable<double> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<int>> setter, Nullable<int> existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<int>> setter, Nullable<int> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<long>> setter, Nullable<long> existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<long>> setter, Nullable<long> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<float>> setter, Nullable<float> existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<Nullable<float>> setter, Nullable<float> existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<float> setter, float existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<float> setter, float existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<string> setter, string existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<string> setter, string existingValue, CultureInfo culture = null);
-        public static EventCallback<UIChangeEventArgs> CreateBinder<T>(this EventCallbackFactory factory, object receiver, Action<T> setter, T existingValue);

+        public static EventCallback<UIChangeEventArgs> CreateBinder<T>(this EventCallbackFactory factory, object receiver, Action<T> setter, T existingValue, CultureInfo culture = null);
     }
     public static class EventCallbackFactoryUIEventArgsExtensions {
-        public static EventCallback<UIClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIClipboardEventArgs> callback);

-        public static EventCallback<UIDragEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIDragEventArgs> callback);

-        public static EventCallback<UIErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIErrorEventArgs> callback);

-        public static EventCallback<UIFocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIFocusEventArgs> callback);

-        public static EventCallback<UIKeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIKeyboardEventArgs> callback);

-        public static EventCallback<UIMouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIMouseEventArgs> callback);

-        public static EventCallback<UIPointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIPointerEventArgs> callback);

-        public static EventCallback<UIProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIProgressEventArgs> callback);

-        public static EventCallback<UITouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UITouchEventArgs> callback);

-        public static EventCallback<UIWheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIWheelEventArgs> callback);

-        public static EventCallback<UIClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIClipboardEventArgs, Task> callback);

-        public static EventCallback<UIDragEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIDragEventArgs, Task> callback);

-        public static EventCallback<UIErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIErrorEventArgs, Task> callback);

-        public static EventCallback<UIFocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIFocusEventArgs, Task> callback);

-        public static EventCallback<UIKeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIKeyboardEventArgs, Task> callback);

-        public static EventCallback<UIMouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIMouseEventArgs, Task> callback);

-        public static EventCallback<UIPointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIPointerEventArgs, Task> callback);

-        public static EventCallback<UIProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIProgressEventArgs, Task> callback);

-        public static EventCallback<UITouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UITouchEventArgs, Task> callback);

-        public static EventCallback<UIWheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIWheelEventArgs, Task> callback);

     }
-    public struct EventCallbackWorkItem
+    public readonly struct EventCallbackWorkItem
-    public static class HttpClientJsonExtensions {
 {
-        public static Task<T> GetJsonAsync<T>(this HttpClient httpClient, string requestUri);

-        public static Task PostJsonAsync(this HttpClient httpClient, string requestUri, object content);

-        public static Task<T> PostJsonAsync<T>(this HttpClient httpClient, string requestUri, object content);

-        public static Task PutJsonAsync(this HttpClient httpClient, string requestUri, object content);

-        public static Task<T> PutJsonAsync<T>(this HttpClient httpClient, string requestUri, object content);

-        public static Task SendJsonAsync(this HttpClient httpClient, HttpMethod method, string requestUri, object content);

-        public static Task<T> SendJsonAsync<T>(this HttpClient httpClient, HttpMethod method, string requestUri, object content);

-    }
     public interface IComponent {
+        void Attach(RenderHandle renderHandle);
-        void Configure(RenderHandle renderHandle);

-        Task SetParametersAsync(ParameterCollection parameters);

+        Task SetParametersAsync(ParameterView parameters);
     }
+    public interface IHostEnvironmentAuthenticationStateProvider {
+        void SetAuthenticationState(Task<AuthenticationState> authenticationStateTask);
+    }
-    public class InjectAttribute : Attribute
+    public sealed class InjectAttribute : Attribute
+    public sealed class LayoutAttribute : Attribute {
+        public LayoutAttribute(Type layoutType);
+        public Type LayoutType { get; }
+    }
+    public abstract class LayoutComponentBase : ComponentBase {
+        protected LayoutComponentBase();
+        public RenderFragment Body { get; set; }
+    }
     public class PageDisplay : IComponent {
-        public RenderFragment AuthorizingContent { get; private set; }
+        public RenderFragment AuthorizingContent { get; set; }
-        public RenderFragment<AuthenticationState> NotAuthorizedContent { get; private set; }
+        public RenderFragment<AuthenticationState> NotAuthorizedContent { get; set; }
-        public Type Page { get; private set; }
+        public Type Page { get; set; }
-        public IDictionary<string, object> PageParameters { get; private set; }
+        public IDictionary<string, object> PageParameters { get; set; }
+        public void Attach(RenderHandle renderHandle);
-        public void Configure(RenderHandle renderHandle);

-        public Task SetParametersAsync(ParameterCollection parameters);

+        public Task SetParametersAsync(ParameterView parameters);
     }
-    public readonly struct Parameter {
 {
-        public bool Cascading { get; }

-        public string Name { get; }

-        public object Value { get; }

-    }
-    public readonly struct ParameterCollection {
 {
-        public static ParameterCollection Empty { get; }

-        public static ParameterCollection FromDictionary(IDictionary<string, object> parameters);

-        public ParameterEnumerator GetEnumerator();

-        public T GetValueOrDefault<T>(string parameterName);

-        public T GetValueOrDefault<T>(string parameterName, T defaultValue);

-        public IReadOnlyDictionary<string, object> ToDictionary();

-        public bool TryGetValue<T>(string parameterName, out T result);

-    }
-    public static class ParameterCollectionExtensions {
 {
-        public static void SetParameterProperties(this in ParameterCollection parameterCollection, object target);

-    }
-    public struct ParameterEnumerator {
 {
-        public Parameter Current { get; }

-        public bool MoveNext();

-    }
+    public readonly struct ParameterValue {
+        public bool Cascading { get; }
+        public string Name { get; }
+        public object Value { get; }
+    }
+    public readonly struct ParameterView {
+        public static ParameterView Empty { get; }
+        public static ParameterView FromDictionary(IDictionary<string, object> parameters);
+        public ParameterView.Enumerator GetEnumerator();
+        public T GetValueOrDefault<T>(string parameterName);
+        public T GetValueOrDefault<T>(string parameterName, T defaultValue);
+        public void SetParameterProperties(object target);
+        public IReadOnlyDictionary<string, object> ToDictionary();
+        public bool TryGetValue<T>(string parameterName, out T result);
+        public struct Enumerator {
+            public ParameterValue Current { get; }
+            public bool MoveNext();
+        }
+    }
     public readonly struct RenderHandle {
+        public Dispatcher Dispatcher { get; }
-        public Task Invoke(Action workItem);

-        public Task InvokeAsync(Func<Task> workItem);

     }
-    public class RouteAttribute : Attribute
+    public sealed class RouteAttribute : Attribute
-    public static class RuntimeHelpers {
 {
-        public static T TypeCheck<T>(T value);

-    }
     public class UIEventArgs {
-        public static readonly UIEventArgs Empty;

     }
-    public static class UIEventArgsRenderTreeBuilderExtensions {
 {
-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIChangeEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIClipboardEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIDragEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIErrorEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIFocusEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIKeyboardEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIMouseEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIPointerEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIProgressEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UITouchEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Action<UIWheelEventArgs> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIChangeEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIClipboardEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIDragEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIErrorEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIFocusEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIKeyboardEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIMouseEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIPointerEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIProgressEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UITouchEventArgs, Task> value);

-        public static void AddAttribute(this RenderTreeBuilder builder, int sequence, string name, Func<UIWheelEventArgs, Task> value);

-    }
+    public static class WebEventCallbackFactoryUIEventArgsExtensions {
+        public static EventCallback<UIClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIClipboardEventArgs> callback);
+        public static EventCallback<UIDragEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIDragEventArgs> callback);
+        public static EventCallback<UIErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIErrorEventArgs> callback);
+        public static EventCallback<UIFocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIFocusEventArgs> callback);
+        public static EventCallback<UIKeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIKeyboardEventArgs> callback);
+        public static EventCallback<UIMouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIMouseEventArgs> callback);
+        public static EventCallback<UIPointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIPointerEventArgs> callback);
+        public static EventCallback<UIProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIProgressEventArgs> callback);
+        public static EventCallback<UITouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UITouchEventArgs> callback);
+        public static EventCallback<UIWheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<UIWheelEventArgs> callback);
+        public static EventCallback<UIClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIClipboardEventArgs, Task> callback);
+        public static EventCallback<UIDragEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIDragEventArgs, Task> callback);
+        public static EventCallback<UIErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIErrorEventArgs, Task> callback);
+        public static EventCallback<UIFocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIFocusEventArgs, Task> callback);
+        public static EventCallback<UIKeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIKeyboardEventArgs, Task> callback);
+        public static EventCallback<UIMouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIMouseEventArgs, Task> callback);
+        public static EventCallback<UIPointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIPointerEventArgs, Task> callback);
+        public static EventCallback<UIProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIProgressEventArgs, Task> callback);
+        public static EventCallback<UITouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UITouchEventArgs, Task> callback);
+        public static EventCallback<UIWheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<UIWheelEventArgs, Task> callback);
+    }
 }
```

