# Microsoft.JSInterop

``` diff
 namespace Microsoft.JSInterop {
     public static class DotNetDispatcher {
-        public static void EndInvoke(long asyncHandle, bool succeeded, JSAsyncCallResult result);

+        public static void EndInvoke(string arguments);
     }
     public sealed class DotNetObjectRef<TValue> : IDisposable where TValue : class {
-        public DotNetObjectRef();

-        public long __dotNetObject { get; set; }

     }
     public interface IJSRuntime {
+        Task<TValue> InvokeAsync<TValue>(string identifier, IEnumerable<object> args, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class JSRuntimeBase : IJSRuntime {
+        protected Nullable<TimeSpan> DefaultAsyncTimeout { get; set; }
-        protected abstract void BeginInvokeJS(long asyncHandle, string identifier, string argsJson);
+        protected abstract void BeginInvokeJS(long taskId, string identifier, string argsJson);
+        protected internal abstract void EndInvokeDotNet(string callId, bool success, object resultOrError, string assemblyName, string methodIdentifier, long dotNetObjectId);
+        public Task<T> InvokeAsync<T>(string identifier, IEnumerable<object> args, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

