# Microsoft.AspNetCore.Components.Server

``` diff
 namespace Microsoft.AspNetCore.Components.Server {
     public sealed class CircuitOptions {
+        public int MaxBufferedUnacknowledgedRenderBatches { get; set; }
     }
-    public class ComponentPrerenderingContext {
 {
-        public ComponentPrerenderingContext();

-        public Type ComponentType { get; set; }

-        public HttpContext Context { get; set; }

-        public ParameterView Parameters { get; set; }

-    }
-    public sealed class ComponentPrerenderResult {
 {
-        public void WriteTo(TextWriter writer);

-    }
-    public interface IComponentPrerenderer {
 {
-        Task<ComponentPrerenderResult> PrerenderComponentAsync(ComponentPrerenderingContext context);

-    }
+    public abstract class RevalidatingServerAuthenticationStateProvider : ServerAuthenticationStateProvider, IDisposable {
+        public RevalidatingServerAuthenticationStateProvider(ILoggerFactory loggerFactory);
+        protected abstract TimeSpan RevalidationInterval { get; }
+        protected virtual void Dispose(bool disposing);
+        void System.IDisposable.Dispose();
+        protected abstract Task<bool> ValidateAuthenticationStateAsync(AuthenticationState authenticationState, CancellationToken cancellationToken);
+    }
+    public class ServerAuthenticationStateProvider : AuthenticationStateProvider, IHostEnvironmentAuthenticationStateProvider {
+        public ServerAuthenticationStateProvider();
+        public override Task<AuthenticationState> GetAuthenticationStateAsync();
+        public void SetAuthenticationState(Task<AuthenticationState> authenticationStateTask);
+    }
 }
```

