# .NET Core 3.1.15 - May 11, 2021

The .NET 3.1.15 and .NET SDK 3.1.115 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.115
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/master/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.15 is being deployed to Azure App Services and the deployment is expected to complete later in April 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.409](3.1.409-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.115](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

.NET Core 3.1.15 release carries both security and non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/pulls?q=milestone%3A3.1.15+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NET](https://github.com/dotnet/aspnetcore/pulls?q=milestone%3A3.1.15+is%3Aclosed+label%3Aservicing-approved)
* [Extensions](https://github.com/dotnet/extensions/pulls?q=milestone%3A3.1.15+is%3Aclosed+label%3Aservicing-approved)


### Microsoft Security Advisory CVE-2021-31204 | .NET Core Elevation of Privilege Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An elevation of privilage vulnerability exists in .NET 5.0 and .NET Core 3.1 when a user runs a single file application on Operating Systems based on Linux or macOS.

## macOS Notarization Change
  Running "dotnet build" will generate a dll instead of a dylib on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://docs.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, add the following to your project file:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6247](https://github.com/dotnet/core/issues/6247) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.15.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.15.nupkg
Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.15.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.15.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.15.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.15.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.15.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.15.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.15.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.15.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.15.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.15.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.15.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.15.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.15.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.15.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.15.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.15.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.15.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.15.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.15.nupkg
Microsoft.AspNetCore.Metadata | 3.1.15.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.15.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.15.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.15.nupkg
dotnet-sql-cache | 3.1.15.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.15.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.15.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.15.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.15.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.15.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.15.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.15.nupkg
Microsoft.AspNetCore.Components | 3.1.15.nupkg
Microsoft.AspNetCore.Authorization | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.15.nupkg
Microsoft.Extensions.Identity.Core | 3.1.15.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.15.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.15.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.15.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.15.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.15.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.15.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.15.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.15.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.15.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.15.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.15.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.15.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.15.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.15.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.15.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.15.nupkg
Microsoft.AspNetCore.Owin | 3.1.15.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.15.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.15.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.15.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.15.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.15.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.15.nupkg
Microsoft.dotnet-openapi | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.15.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.15.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.15.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.15.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.15.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.15.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.15.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.15.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.15.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.15.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.15.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.15.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.15.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.15.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.15.nupkg
Microsoft.AspNetCore.TestHost | 3.1.15.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.15.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.15.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.15.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.15.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.15.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.15.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.15.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.15.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.15.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.15.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.15.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.15.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.15.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.15.nupkg
Microsoft.NET.Sdk.Razor | 3.1.15.nupkg
dotnet-ef | 3.1.15.nupkg
Microsoft.Data.Sqlite | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.15.nupkg
Microsoft.EntityFrameworkCore | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.15.nupkg
Microsoft.Data.Sqlite.Core | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.15.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.15.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.15.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.15.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.15.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.15.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.15.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.15.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.15.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.15.nupkg
Microsoft.Extensions.Configuration | 3.1.15.nupkg
Microsoft.Extensions.WebEncoders | 3.1.15.nupkg
Microsoft.Extensions.Primitives | 3.1.15.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.15.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.15.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.15.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.15.nupkg
Microsoft.Extensions.Logging.Console | 3.1.15.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.15.nupkg
Microsoft.Extensions.Hosting | 3.1.15.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.15.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.15.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.15.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.15.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.15.nupkg
Microsoft.Extensions.Http.Polly | 3.1.15.nupkg
Microsoft.Extensions.Localization | 3.1.15.nupkg
Microsoft.Extensions.Logging | 3.1.15.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.15.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.15.nupkg
Microsoft.Extensions.Http | 3.1.15.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.15.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.15.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.15.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.15.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.15.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.15.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.15.nupkg
Microsoft.Extensions.ObjectPool | 3.1.15.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.15.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.15.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.15.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.15.nupkg
Microsoft.JSInterop | 3.1.15.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.15.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.15.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.15.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.15.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.15.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.15.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.15.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.15.nupkg
Microsoft.Extensions.Options | 3.1.15.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.15.nupkg



[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.15/3.1.15.md
[snap-install]: 3.1.15-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.15-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.15-sha.txt

[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-may-2021/


[//]: # ( Runtime 3.1.15)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e22adf9-3d0c-4d05-98c2-418af9f75b07/92ae7cb0014cdafd6e6bb1ba30344d0f/dotnet-runtime-3.1.15-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63d88492-c14a-48ac-bc16-0e8a20adcb81/56cdb7f10b6c4340a16565867b37056d/dotnet-runtime-3.1.15-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12202a39-ed36-47e1-b5a0-109eb1151748/626c0e183181e2595be8fb923c8b18ba/dotnet-runtime-3.1.15-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4bb6c66-f43c-4781-8ef2-4fa23e2d9d0d/23186bed817e4debd8f5ed264cb1c9dc/dotnet-runtime-3.1.15-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/692284f9-e1e7-4b31-9191-cd8043441024/ac45c17d4327b1f992b7fe3956a99129/dotnet-runtime-3.1.15-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7b0beb64-e40c-4eb2-83d1-86478e9e2f41/032098e50fe0b81d2f981c5acc4409cf/dotnet-runtime-3.1.15-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33e0367d-172f-46c6-9c52-139ede48154b/4abf68360d00e3301a51fa6a54a4af0e/dotnet-runtime-3.1.15-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/032e0c68-61b2-4b0f-a36b-7920f3005184/e2edb1fa69ec1128d4ef2e55a6949b0f/dotnet-runtime-3.1.15-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/175dbe99-a914-4654-90b3-a80a2d2f03c8/f1609ae26bce5fbff4ac08e0476d1a7e/dotnet-runtime-3.1.15-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9ced34cb-7ed9-44a1-9dd4-c8f83b56259d/0ab010ea8056e5c8e7c653efea456fc8/dotnet-runtime-3.1.15-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/35b3d0cb-0c1c-44c2-8134-bfae32e9aa2a/0754bccd12a07e746bce755f58a0e74d/dotnet-runtime-3.1.15-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/280a4546-1afc-4576-85c5-11605fef4bac/0f1556ac537ca7d183a2aa19f504b0f8/dotnet-runtime-3.1.15-win-x86.zip

[//]: # ( WindowsDesktop 3.1.15)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d30352fe-d4f3-4203-91b9-01a3b66a802e/bb416e6573fa278fec92113abefc58b3/windowsdesktop-runtime-3.1.15-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8b11972e-ded9-4d3c-9714-7c7ef047cca6/76dbe20bc03e69f5c0d005452ba88a9d/windowsdesktop-runtime-3.1.15-win-x86.exe

[//]: # ( ASP 3.1.15)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/000183b9-3d77-4e03-902e-7debe460497d/dcd6400fe1f28baba8624d3242f820a7/aspnetcore-runtime-3.1.15-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dccfa850-fe07-4444-8af1-5ec25cf177f2/e2625f76e9fc4748e956a4e7d449d34c/aspnetcore-runtime-3.1.15-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72ff135f-2b46-4625-8777-e2135d59c4b4/c21ac6916d562771a8a3f14d4ccdd9b8/aspnetcore-runtime-3.1.15-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27e4b0cc-5088-4a73-a436-cb5538ba2a0d/e04a0568631f3eb4c3311cf35b42c544/aspnetcore-runtime-3.1.15-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8aaf94dc-ce57-4d00-9d2d-70e8b760619e/2979ffe47a37c1aa5d931ee1953613f3/aspnetcore-runtime-3.1.15-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45be4b5b-1ce2-480c-953c-6c7f0b836f09/ffbfcbc419a50d9a846de69bed41a6ce/aspnetcore-runtime-3.1.15-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/45a8a347-4263-432c-a29c-9a91a005ae74/0f4fadfabe18ad290022393636367750/aspnetcore-runtime-3.1.15-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ae6e6b5b-5e7c-45f9-a668-cb1899f22e46/9c917acfab934ddd64340ba46490264e/aspnetcore-runtime-3.1.15-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/268da69e-87a0-47bd-a353-f66d0a1bfb69/867b54adc61b71e7b38ab2091836dae9/aspnetcore-runtime-3.1.15-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/223a50e4-a4e1-42dc-8f97-f38a8f7518c3/642dab7b5177097ee223156ce70a6c3c/aspnetcore-runtime-3.1.15-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4e362d0f-853b-4fb3-b733-75d6c13b8f01/daef6e0e8a0e6e34b18d93026501b08a/aspnetcore-runtime-3.1.15-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c8eabe25-bb2b-4089-992e-48198ff72ad8/a55a5313bfb65ac9bd2e5069dd4de5bc/dotnet-hosting-3.1.15-win.exe


[//]: # ( SDK 3.1.115 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31ccb908-2638-4fa1-8ed4-2e90ca89e42e/30dc805ef1b30c277b0a63a553439d41/dotnet-sdk-3.1.115-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ddeff0d-46d7-4688-ba7b-9b0b1eca68ff/2fcf0dde34749a46ec7dbd92eb255934/dotnet-sdk-3.1.115-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/84e29449-c33b-43eb-aabf-bac5a5667b55/ce703d9e97d8f12991b7a0eb33d60a3b/dotnet-sdk-3.1.115-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cc86b0c8-9e72-4410-b3b0-2c5a8f90d8a4/426913359d4c524560e42c4f2ee18fa1/dotnet-sdk-3.1.115-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b50674cd-17bc-4c24-930f-aff7c0964eda/9987be051dd0cc7b4f933eadc2b983f8/dotnet-sdk-3.1.115-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0846549a-52bb-459c-8a8f-63a74c123855/77d1d3f08b7eb693e1ee3020ba67f157/dotnet-sdk-3.1.115-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4045c370-0bc5-4541-8b86-e36907cda9ca/6ab1ad53ac7b6e0e5cb331e5aafa74fc/dotnet-sdk-3.1.115-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/2815e556-55fa-4113-b82c-4811b560ea4a/64c6c59359bcb6ab66f42f2153e42b9c/dotnet-sdk-3.1.115-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e2c406c9-d40d-442c-b6cd-bc60a84d159f/556f8d45b3f5fa932785e138468a6ee3/dotnet-sdk-3.1.115-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d3778483-d41a-4f7c-b128-f5caf68e7db9/919c2f392354362722c16e2e65dd5a31/dotnet-sdk-3.1.115-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bab13c6e-f587-45ab-b4d5-fe51dd78cdd2/56f6363eb0e37d14e0ef6e92bf55ba6e/dotnet-sdk-3.1.115-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0d5a45f2-f215-4ba6-8957-597fede1450f/43fd43f1777ffb31ed3c30ac1c73c41c/dotnet-sdk-3.1.115-win-x86.zip
