# .NET Core 3.1.16 - June 08, 2021

The .NET 3.1.16 and .NET SDK 3.1.116 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.116
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/master/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.16 is being deployed to Azure App Services and the deployment is expected to complete later in June 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.410](3.1.410-download.md) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.116](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

.NET Core 3.1.16 release carries both security and non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/pulls?q=milestone%3A3.1.16+is%3Aclosed+label%3Aservicing-approved)
* [Extensions](https://github.com/dotnet/extensions/pulls?q=milestone%3A3.1.16+is%3Aclosed+label%3Aservicing-approved)


### Microsoft Security Advisory CVE-2021-31957 |  ASP.NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when ASP.NET Core improperly handles client disconnect.

## macOS Notarization Change
  Running "dotnet build" will generate a dll instead of a dylib on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://docs.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, add the following to your project file:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6337](https://github.com/dotnet/core/issues/6337) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.16.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
Microsoft.NET.HostModel | 3.1.16.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.16.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.16.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.16.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.16.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.16.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.16.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.16.nupkg
Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.16.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.16.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.16.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.16.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.16.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.16.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.16.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.16.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.16.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.16.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.16.nupkg
Microsoft.NETCore.Platforms | 3.1.7.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.16.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.16.nupkg
Microsoft.AspNetCore.TestHost | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.16.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.16.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.16.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.16.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.16.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.16.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.16.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.16.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.16.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.16.nupkg
Microsoft.AspNetCore.Owin | 3.1.16.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.16.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.16.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.16.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.16.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.16.nupkg
dotnet-sql-cache | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.16.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.16.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.16.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.16.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.16.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.16.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.16.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.16.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.16.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.16.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.16.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.16.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.16.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.16.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.16.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.16.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.16.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.16.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.16.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.16.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.16.nupkg
Microsoft.AspNetCore.Metadata | 3.1.16.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.16.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.16.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.16.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.16.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.16.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.16.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.16.nupkg
Microsoft.Extensions.Identity.Core | 3.1.16.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.16.nupkg
Microsoft.dotnet-openapi | 3.1.16.nupkg
AspNetCoreRuntime | 3.1.x64 | 3.1.16.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.16.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.16.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.16.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.16.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.16.nupkg
Microsoft.AspNetCore.Authorization | 3.1.16.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.16.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.16.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.16.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.16.nupkg
AspNetCoreRuntime | 3.1.x86 | 3.1.16.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.16.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.16.nupkg
Microsoft.AspNetCore.Components | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates | 3.0 | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.16.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.16.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates | 3.0 | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.16.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.16.nupkg
Microsoft.NET.Sdk.Razor | 3.1.16.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.16.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.16.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.16.nupkg
Microsoft.Data.Sqlite.Core | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.16.nupkg
Microsoft.Data.Sqlite | 3.1.16.nupkg
Microsoft.EntityFrameworkCore | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.16.nupkg
dotnet-ef | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.16.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.16.nupkg
Microsoft.Extensions.Primitives | 3.1.16.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.16.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.16.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.16.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.16.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.16.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.16.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.16.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.16.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.16.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.16.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.16.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.16.nupkg
Microsoft.Extensions.Http | 3.1.16.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.16.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.16.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.16.nupkg
Microsoft.Extensions.Localization | 3.1.16.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.16.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.16.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.16.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.16.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.16.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.16.nupkg
Microsoft.Extensions.Options | 3.1.16.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.16.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.16.nupkg
Microsoft.JSInterop | 3.1.16.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.16.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.16.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.16.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.16.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.16.nupkg
Microsoft.Extensions.Configuration | 3.1.16.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.16.nupkg
Microsoft.Extensions.WebEncoders | 3.1.16.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.16.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.16.nupkg
Microsoft.Extensions.Logging.Console | 3.1.16.nupkg
Microsoft.Extensions.Hosting | 3.1.16.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.16.nupkg
Microsoft.Extensions.Http.Polly | 3.1.16.nupkg
Microsoft.Extensions.Logging | 3.1.16.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.16.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.16.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.16.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.16.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.16.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.16.nupkg
Microsoft.Extensions.ObjectPool | 3.1.16.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.16.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.16.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.16/3.1.16.md
[snap-install]: 3.1.16-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.16-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.16-sha.txt

[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-june-2021/


[//]: # ( Runtime 3.1.16)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/018340ba-35e8-46bd-93b7-e30ecc15212d/647fd64b6849c55cf8e380c23dd5c554/dotnet-runtime-3.1.16-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac1c2996-43cb-49cb-b874-7edeaddb5dc5/b95a6773de35f91afc2cf0dd4cc6674c/dotnet-runtime-3.1.16-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86f57cfe-8658-4a5d-8ee6-54fdf185dbda/9783a9a086750bed72b3dd0f10ac1627/dotnet-runtime-3.1.16-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b935b85d-65ae-48ac-b6e0-083d9d9f3fae/f171f8b01ec7de02789032a685695f76/dotnet-runtime-3.1.16-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45774232-d104-4ef6-a22d-9412288c0062/4b6f2462a7ccc8899950a8641631d65d/dotnet-runtime-3.1.16-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/49eb95b8-c9d2-4bdf-b003-a03ac194f68f/f8cd619e350762ae984468f1ad7e266c/dotnet-runtime-3.1.16-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd4042d9-6caa-4313-afd4-de702f48e6d2/bcd00084634942af90146d1cc6169a5e/dotnet-runtime-3.1.16-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/53e757d4-6d6c-4480-a634-d7437835a8a1/38a811491189a9297a4a0fc47f13f93d/dotnet-runtime-3.1.16-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c5ac98b1-ca0c-4fb9-8081-b57b7d1aff15/3bf549e382b0b5f18a5ab7e6017bd096/dotnet-runtime-3.1.16-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/02070fad-f3de-4561-a10a-b678c0dbe1f7/9f8a93d5d47753975adbedb55f919923/dotnet-runtime-3.1.16-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/765b6839-9ee9-45f8-9aef-4bbea1aed51a/9dd5a72099788f4cc2b25b1e626f3356/dotnet-runtime-3.1.16-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9a72e81c-35b0-47c1-986c-592e5382b3cb/108c26daf6cbeff22143abf078a1cc91/dotnet-runtime-3.1.16-win-x86.zip

[//]: # ( WindowsDesktop 3.1.16)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7cea63ad-1e76-41f0-a54a-eacb48fec749/87c339835cd7647c0fee3f14820cd909/windowsdesktop-runtime-3.1.16-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f703f604-a973-4ab9-abe4-b4b2ec786e66/af8cea0988953ef074157ea99d30879a/windowsdesktop-runtime-3.1.16-win-x86.exe

[//]: # ( ASP 3.1.16)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd734390-3b5f-402a-826f-e0eae538b8ba/5914dd937ede96cb9297e6e7a80f46f3/aspnetcore-runtime-3.1.16-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/64353333-3080-45f7-a3d5-33e391e4596c/e9d5d53cb318628485e8d1fbd26ec30d/aspnetcore-runtime-3.1.16-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8fc373ff-a7db-47a0-b561-baa7a7008dd8/e6892fd4901d7b378f38fa08c12f49ff/aspnetcore-runtime-3.1.16-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6d4d475-d514-4a4b-8162-54f712077a3e/ea8849187e7bfec582b422082771cad0/aspnetcore-runtime-3.1.16-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c20a5ac5-5174-46b8-a875-b916a416050d/b2ddd212a183260569178d880899bd94/aspnetcore-runtime-3.1.16-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/994daad6-604a-45a9-a1c2-2d2adc97e043/aa82c9619b1748e9aac92b6870cde911/aspnetcore-runtime-3.1.16-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/c424805e-7dcb-4591-bd6f-b356a6396bb4/20f6998a8c4535ebb18950a3d4ceb064/aspnetcore-runtime-3.1.16-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a59188f0-7ac7-4cb7-b808-ac9a69c2fd68/8f14e0256f4986c13e053235ee44c297/aspnetcore-runtime-3.1.16-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/44cb3ecd-d8bd-4c84-9101-15ec4d915211/7c1688a213eda967d336f5caa41c6faf/aspnetcore-runtime-3.1.16-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c938d1c7-c59c-49ef-b34c-c7d3581140cc/ce051a5495ab6999a711007716a5b935/aspnetcore-runtime-3.1.16-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e99aacb1-66ac-400e-90e2-1d2718222454/944e4a2fe0ade5e6b76b91e6d45d4b69/aspnetcore-runtime-3.1.16-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/8bc07709-5179-4e00-97c1-7ba838a17896/e509eaa80062bb3cfc94d64a7bf70afb/dotnet-hosting-3.1.16-win.exe


[//]: # ( SDK 3.1.116 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/351c3281-43d6-4f2f-8936-6ba4f0ae9e0e/159e36b534b01a6ee8dd13d2e53680a8/dotnet-sdk-3.1.116-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3279c2d9-9604-4c36-9c33-c7f23d16befa/a7593d4f3381a6679cda1864a8cfe0f4/dotnet-sdk-3.1.116-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4cd1d71f-7c8f-413e-a616-34535049e71c/e651c36d57260c09d00cf49c0a9a92d8/dotnet-sdk-3.1.116-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36c70585-9dc1-4f63-9200-559eedfac222/0d0db5131b5027e0cec04b337a56e318/dotnet-sdk-3.1.116-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a86a93c8-d5e5-4196-8f76-322c76491cda/3f5843ad414fe29a14bfe95be890a0f1/dotnet-sdk-3.1.116-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/53fd499d-69d8-4a0e-9587-6ac59dfaff73/b3d993a35a2edf36eaf8410f0719ac03/dotnet-sdk-3.1.116-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a069a2c4-25d5-4a6f-96da-b67f1351af19/94c2b9f47ab9a219d3243aff1ddaf6c9/dotnet-sdk-3.1.116-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ee283a8f-b50b-4080-a8ba-f0856f1a55d5/729775cef5196ff9278fc4a60ee7b94b/dotnet-sdk-3.1.116-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c7a579bb-af68-4c49-a56f-074ea55bb937/6e8380a14e4c1e08b6695fc8da726c9f/dotnet-sdk-3.1.116-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/78b856c6-62e8-437e-8391-e6194782c173/0ab87cd76ea510a6329d167a0001968d/dotnet-sdk-3.1.116-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6d3943f7-50cf-4be8-a6bb-ba747b6d706d/7e17338342fd9c4c6fb901796b347bc0/dotnet-sdk-3.1.116-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6bd51354-2d39-438c-9744-a3d65562018e/c3959e3b57ded1b8db7e8ab378ed5f27/dotnet-sdk-3.1.116-win-x86.zip
