# .NET Core 3.1.2 - February 18, 2020

[.NET Core 3.1.2](https://dotnet.microsoft.com/download/dotnet/3.1) is available for download and usage in your environment. This release includes .NET Core 3.1.2 and .NET Core SDK 3.1.102.

* [Blog Roundup][dotnet-blog]
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.1)
* [Changes in this release](#changes-in-312)
* [Known issues](../3.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)

The .NET Core SDK 3.1.102 includes .NET Core 3.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.1.102, the following command will show that you're running version `3.1.102` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4280](https://github.com/dotnet/core/issues/4280) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] \| [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.4 | [3.1.102](#downloads) |
| Windows | Visual Studio 2019 version 16.5 | [3.1.200](3.1.200-sdk.md) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)
* [dotnet/core/samples](https://hub.docker.com/_/microsoft-dotnet-core-samples)
* [dotnet/aspnetcore](https://hub.docker.com/_/microsoft-dotnet-core-aspnet)

### Azure App Services

* .NET Core 3.1.2 is being deployed to Azure App Services and the deployment is expected to complete later in February 2020.

## .NET Core Lifecycle News

[.NET Core 2.2 reached end of life](https://github.com/dotnet/announcements/issues/147/) on December 23, 2019. This means .NET Core 2.2 is no longer supported and updates will no longer be provided. We recommend moving to .NET Core 3.1, our long term support (LTS) release.

.NET Core 3.0 will reach end of life on March 3, 2020 which is 3 months after the release of .NET Core 3.1. You can view the [Microsoft Support for .NET Core](https://github.com/dotnet/core/blob/main/microsoft-support.md) for more information about life-cycle of each product.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 3.1.2

.NET Core 3.1.2 release carries only non-security fixes.

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A3.1.2+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A3.1.2+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A3.1.2+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)

### macOS Notarization Change
  Running "dotnet build" will generate dll instead of binary on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://review.docs.microsoft.com/dotnet/core/install/macos-notarization-issues?branch=pr-en-us-17092). If you want to opt into using the AppHost, please use following:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.2/3.1.2.md
[snap-install]: 3.1.2-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.2-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-february-2020/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1/


[//]: # ( Runtime 3.1.2)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30ed47bb-c25b-431c-9cfd-7b942b07314f/5c92af345a5475ca58b6878dd974e1dc/dotnet-runtime-3.1.2-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3ee4d51-5cbf-4591-baf0-f9af7f9a07e7/59fa68462184d031275c2fa09cdf375d/dotnet-runtime-3.1.2-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47b64547-75e5-43dc-9e2f-66e9d6b9d9ee/869b5417d9d7e4d141f9d2bdeb6b4e36/dotnet-runtime-3.1.2-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/21042b9d-8eca-497e-894b-97dde4a4e5d1/c486b0bec79041bc99619756017ad124/dotnet-runtime-3.1.2-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38269fba-9fdb-4723-a14c-067cc316827d/53e4161da346d70404375fb8804ee91a/dotnet-runtime-3.1.2-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/722d2a42-95c2-4555-ac7a-ec98313984e1/44979d85ec12073d69b3b64feec68ea6/dotnet-runtime-3.1.2-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f58e9293-6600-4de4-a9a8-53951e05ef4f/48d982fbd1d96d818474229a3da22672/dotnet-runtime-3.1.2-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/420238c8-c86c-4936-91cd-71afe82089a3/af53c9881a098c97c9be7815db0053a8/dotnet-runtime-3.1.2-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8efe160b-187d-4efe-bef1-bb1aaa0cadf6/5127ae7085f9f0c1dcc8e479ced919a5/dotnet-runtime-3.1.2-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/cfe420d5-084c-4590-b387-f89f3387d4c9/db4c577b995c54dee0530d8230e87145/dotnet-runtime-3.1.2-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/12c4e2f0-eda2-42ca-908e-fcdb68550a5f/ca19066eba7c09b8c781ae7a84a7ba8d/dotnet-runtime-3.1.2-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/dfedf8a5-c3cd-4b69-a5eb-8f9994e810f7/feeead4b3ae3b9e003917797c8356675/dotnet-runtime-3.1.2-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/541f44b0-cda8-4559-9cff-860fca619767/599bc8f47a85a5c2892d3540c7b7dd6f/dotnet-runtime-3.1.2-win-x86.zip

[//]: # ( WindowsDesktop 3.1.2)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3240250e-6fe0-4258-af69-85abef6c00de/e01ee0af6c65d894f4a02bdf6705ec7b/windowsdesktop-runtime-3.1.2-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b824906f-bd6e-4067-86a6-95c61620674d/cfcdab84a01cee94fdaa31271c3d4d47/windowsdesktop-runtime-3.1.2-win-x86.exe

[//]: # ( ASP 3.1.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ccacf09-e5eb-481b-a407-2398b08ac6ac/1cef921566cb9d1ca8c742c9c26a521c/aspnetcore-runtime-3.1.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ec985ae1-e15c-4858-b586-de5f78956573/f585f8ffc303bbca6a711ecd61417a40/aspnetcore-runtime-3.1.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/927b34aa-08c7-411a-b1a1-1a0dbe28cb51/446dbeccd8130a18f6a1885a51d1babe/aspnetcore-runtime-3.1.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d9ea89f5-935b-47e0-8734-118f8ea6d812/b84792a3ae72add68cd1dcfb9aebeaae/aspnetcore-runtime-3.1.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d72ee67-ac4d-42c6-97d9-a26a28201fc8/977ad14b99b6ed03dcefd6655789e43a/aspnetcore-runtime-3.1.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9593b373-38a1-454e-844f-da3b5d47b1f8/e6f69a1dda1af567079d949c63c5be85/aspnetcore-runtime-3.1.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/b46a8ae4-63d2-4d3e-a230-71bd898b1f6d/b4fba45bad2e853c3a3dc687a459667e/aspnetcore-runtime-3.1.2-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/326b33d1-6bbd-4149-ba35-c94784700674/c06386c2b09401fa94f9595617899d5d/aspnetcore-runtime-3.1.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6cc3f6a7-3a0f-441c-82a2-104fa93ef8b6/3c1395461545eb5321eb2816d4b3fecf/aspnetcore-runtime-3.1.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2c8e520e-d705-4b11-8854-518546133e27/13354ed8b42d8c2c52f75d7acffd0be4/aspnetcore-runtime-3.1.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/02ee0d2a-92ea-4be2-bbfe-fe98a35bf1b6/bf581b5aebbf1825997b668310672fc5/aspnetcore-runtime-3.1.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/dd119832-dc46-4ccf-bc12-69e7bfa61b18/990843c6e0cbd97f9df68c94f6de6bb6/dotnet-hosting-3.1.2-win.exe

[//]: # ( SDK 3.1.102 )

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/349f13f0-400e-476c-ba10-fe284b35b932/44a5863469051c5cf103129f1423ddb8/dotnet-sdk-3.1.102-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ea7ea69-6110-4c39-a07c-bd4df663e49b/5d60f17a167a5696e63904f7a586d072/dotnet-sdk-3.1.102-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f686a328-a7e2-403c-9107-2e8d8b54aaa9/a1ed4732a9388c5817f79564e3fbbc3a/dotnet-sdk-3.1.102-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57e63f03-ebdf-4c22-96ff-2b85dc70cf7f/988576869e82a80f4a97ca5a733a5295/dotnet-sdk-3.1.102-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3533d626-4784-4944-9d3a-e62b9b46d11a/770e2b9c1a40546a19e063c39996fe7d/dotnet-sdk-3.1.102-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1c966a74-8ec0-4d07-997f-a96ca2dd9dd5/bad90bb7bd183a40ecae341198ea0fe9/dotnet-sdk-3.1.102-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e1815af-cabc-4b19-bc5c-6abe68ee06c8/58e4de9cc06cb46174f150eb71f9de48/dotnet-sdk-3.1.102-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/36b067d5-6a4c-467c-8677-f2d00749a574/4f45950e15cd6b7b5bd010fcb64f140d/dotnet-sdk-3.1.102-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5aad9c2c-7bb6-45b1-97e7-98f12cb5b63b/6f6d7944c81b043bdb9a7241529a5504/dotnet-sdk-3.1.102-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/33b3cfa9-905d-4386-8854-ef05010efb25/d54f0d42b92d2e4079013ae5faac7745/dotnet-sdk-3.1.102-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0f19219f-3f53-4235-ba67-0bb74f3b1a23/0047614c923d2641344d8a3531efc5f5/dotnet-sdk-3.1.102-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/961d2276-c171-4e2b-b74c-e5fbc71f308c/2590499670296b16c02fb38441053d79/dotnet-sdk-3.1.102-win-x86.zip

[//]: # ( Symbols )
