# .NET 5.0.4 - March 09, 2021

The .NET 5.0.4 and .NET SDK 5.0.104 releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](5.0.4-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.104
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/master/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.4 release carries both security and non-security fixes.

### Security

# Microsoft Security Advisory CVE-2021-26701 | .NET Core Remote Code Execution Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1, and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A remote code execution vulnerability exists in .NET 5 and .NET Core due to how text encoding is performed.

### Other fixes

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

*  .NET SDK 5.0.104 includes bugfixes to the runtime and Windows SDK projections with C#/WinRT v1.1.2. These changes come through the Windows SDK reference packages when targeting the Windows SDK. Refer to the C#/WinRT v1.1.2 release notes for a list of bugfixes.

Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.4+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NET Core](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A5.0.4+is%3Aclosed+label%3Aservicing-approved)
* [EntityFramework Core](https://github.com/dotnet/efcore/issues?q=milestone%3A5.0.4+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.4+is%3Aclosed+label%3Aservicing-approved)
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A5.0.4+is%3Aclosed+label%3Aservicing-approved)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6035](https://github.com/dotnet/core/issues/6035) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.4.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.4-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-march-2021/




[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.4xx+is%3Aclosed

[linux-packages]: 5.0.4-install-instructions.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.4.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.4.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.4.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.4.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.4.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.4.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
runtime.linux-arm64.runtime.native.System.IO.Ports | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.android-x86 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.ios-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.android-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.android-arm | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.4.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
System.Drawing.Common | 5.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.4.nupkg
Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.4.nupkg
System.IO.Ports | 5.0.1.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.ios-arm | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.android-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.4.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.4.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.ios-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.ios-x86 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.4.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.4.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.tvos-x64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.4.nupkg
System.Text.Encodings.Web | 5.0.1.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.linux-x64.runtime.native.System.IO.Ports | 5.0.0.nupkg
runtime.native.System.IO.Ports | 5.0.1.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.osx-x64.runtime.native.System.IO.Ports | 5.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.4.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
runtime.linux-arm.runtime.native.System.IO.Ports | 5.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.4.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.4.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.tvos-arm64 | 5.0.4.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.4.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.4.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.4.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.4.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.4.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.4.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.4.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.4.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.4.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.4.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.4.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.4.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.4.nupkg
Microsoft.Extensions.Localization | 5.0.4.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.4.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.4.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.4.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.4.nupkg
Microsoft.Extensions.ObjectPool | 5.0.4.nupkg
Microsoft.Extensions.Identity.Core | 5.0.4.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.4.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.4.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.4.nupkg
Microsoft.AspNetCore.Owin | 5.0.4.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.4.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.4.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.4.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.4.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.4.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.4.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.4.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.4.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.4.nupkg
Microsoft.JSInterop | 5.0.4.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.4.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.4.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.4.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.4.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.4.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.4.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.4.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.4.nupkg
dotnet-sql-cache | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.4.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.4.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.4.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.4.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.4.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.4.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.4.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.4.nupkg
Microsoft.AspNetCore.Components | 5.0.4.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.4.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.4.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.4.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.4.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.4.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.4.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.4.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.4.nupkg
Microsoft.Extensions.WebEncoders | 5.0.4.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.4.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.4.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.4.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.4.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.4.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.4.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.4.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.4.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.4.nupkg
Microsoft.dotnet-openapi | 5.0.4.nupkg
Microsoft.AspNetCore.TestHost | 5.0.4.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.4.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.4.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.4.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.4.nupkg
Microsoft.AspNetCore.Authorization | 5.0.4.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.4.nupkg
Microsoft.AspNetCore.Metadata | 5.0.4.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.4.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.4.nupkg
Microsoft.Data.Sqlite.Core | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.4.nupkg
dotnet-ef | 5.0.4.nupkg
Microsoft.EntityFrameworkCore | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.4.nupkg
Microsoft.Data.Sqlite | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.4.nupkg
dotnet-ef | 5.0.4.nupkg
Microsoft.Data.Sqlite | 5.0.4.nupkg
Microsoft.Data.Sqlite.Core | 5.0.4.nupkg
Microsoft.EntityFrameworkCore | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.4.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.4.nupkg
Microsoft.TemplateSearch.Common | 5.0.200-preview.21109.7.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.200-preview.21109.7.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.200-preview.21109.7.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.200-preview.21109.7.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.200-preview.21109.7.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.200-preview.21109.7.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.200-preview.21109.7.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.200-preview.21109.7.nupkg
Microsoft.TemplateEngine.Utils | 5.0.200-preview.21109.7.nupkg
Microsoft.TemplateEngine.Core | 5.0.200-preview.21109.7.nupkg
Microsoft.TemplateEngine.Edge | 5.0.200-preview.21109.7.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.200-preview.21109.7.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.200-preview.21109.7.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.200-preview.21109.7.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.200-preview.21109.7.nupkg
Microsoft.TemplateEngine.IDE | 5.0.200-preview.21109.7.nupkg



[//]: # ( Runtime 5.0.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5a496e41-23da-4aaa-94a7-baa9ab619fc6/0d000727345f3f71858ee79367f6ec23/dotnet-runtime-5.0.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9612ffe7-7091-4f23-843a-ea44698423df/9dc85938df3f46529273fd23f9b63e6a/dotnet-runtime-5.0.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/639ea452-97d9-43b9-8de2-051c2c350e1c/361efcab2a07978b3b2e2821b9ee6e88/dotnet-runtime-5.0.4-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9582a57f-9ea0-403c-9143-2a109ee330a6/7abc43ce43e141050c76b2c90fa49a17/dotnet-runtime-5.0.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b0db10e-9d2e-407d-adfa-9f071b10127b/f8ee840d45eb2dabf7f29e375e9ab8a1/dotnet-runtime-5.0.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66db1966-cbe4-4c6c-9e73-80305c555aba/faabab630f9f56e28e9dc30691bda72c/dotnet-runtime-5.0.4-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c8320b32-f469-4c6b-9efe-39db01667197/c98a8dd2f5be1fca335e98c49e519fa6/dotnet-runtime-5.0.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0463015-ef67-4241-8126-f46be6f39a49/c30e98c2c15ba2166a6cb212a1539217/dotnet-runtime-5.0.4-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/99d47c44-6b8d-4e3b-8e0e-cb8a04060ef5/345f358d47811d3ff9bc56d7da2ed875/dotnet-runtime-5.0.4-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a9e4911b-9eb9-4988-90db-218c14044149/68fe9723d0839249c5f0d46081896622/dotnet-runtime-5.0.4-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c47aeae9-d214-42de-8295-d2624f46ca15/aa67a0ca37e434bf055e1150e1203241/dotnet-runtime-5.0.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/868f6278-98a7-4dc3-bd10-953df1fcacb7/e7985effaff7af1229d0d9714aa5fde6/dotnet-runtime-5.0.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6216588a-7d51-4787-a99a-0314a2fdf1a1/633bacf3c6f7876cd48bfd995edb9ab2/dotnet-runtime-5.0.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/772f0b7e-e5ea-4270-b2a5-cfc18d880759/97dca0fc531bd7146576dcfe1adbfe9d/dotnet-runtime-5.0.4-win-x86.zip

[//]: # ( WindowsDesktop 5.0.4)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9972cac4-3605-46f0-933f-7e62a19bf6c3/64c60574923619b1aa3a4eb711d8722c/windowsdesktop-runtime-5.0.4-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7a5d15ae-0487-428d-8262-2824279ccc00/6a10ce9e632bce818ce6698d9e9faf39/windowsdesktop-runtime-5.0.4-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0c5c56a4-8b34-4361-8af9-482c788b2bcf/d734b200547c8c367eb45ebbd69c4698/windowsdesktop-runtime-5.0.4-win-x86.exe

[//]: # ( ASP 5.0.4)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc029ada-7f37-45c0-9a0b-ed88c1d6ec1d/3364dac1192510a5968d7c8976a5d630/aspnetcore-runtime-5.0.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d464a46d-a904-4a0e-94f1-c2ccfc7a691f/dcdea88fb8b10c2358c19fde84f7103f/aspnetcore-runtime-5.0.4-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1cbaf10a-e64b-482f-8d40-2f3309126828/2a93e60126f3e251936388787793cb51/aspnetcore-runtime-5.0.4-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d0c827a-fe81-4e49-89f4-84d1b8170752/1f78e9059e0505f226a8ee5ea466675e/aspnetcore-runtime-5.0.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/df48d136-7c22-4e76-867a-75513225d285/f4cc8ec0ef5d0d03b77f3ab325f75f25/aspnetcore-runtime-5.0.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/131d9f6b-0f49-474e-a7c5-33754d4e9195/52fae63c358d8e8e6211a50a64fe3dfd/aspnetcore-runtime-5.0.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b569a2f6-4294-47fb-8e76-69e59e4d02b5/25fe0a0b374cdd858c4ea77e3f661af9/aspnetcore-runtime-5.0.4-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/892612b8-75df-4f7c-9fd9-7f36945dcb2c/bd7ba19a0e94eb755818b3706b23046b/aspnetcore-runtime-5.0.4-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/10ba6f78-b704-45fd-b770-e56aa9a03498/a4738342daec491cc55a2acc17987c4a/aspnetcore-runtime-5.0.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/093b97e5-e19b-432b-bf9f-f798b850b482/b37025dfc3b0f4fd8764abeb95630251/aspnetcore-runtime-5.0.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/89f9f142-416b-4967-986f-0efcdccb8152/226714a03e8b3bdda5d9a009e7ce1b87/aspnetcore-runtime-5.0.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1146a702-fb69-4fc5-8d21-ce9ce223e7eb/a87ad99ecc2abd9d4d82b83f4fdf7b84/aspnetcore-runtime-5.0.4-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/2281cc70-3851-4dec-b418-4f5be60d8f2e/0163e524e63c2bb07d9da642ca1468d5/dotnet-hosting-5.0.4-win.exe


[//]: # ( SDK 5.0.104 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2623e28a-df3b-44ec-9678-af3f1dbe1caa/097423ca07af1ac3e6e6a4af758ca340/dotnet-sdk-5.0.104-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/469fb27a-ffec-45ee-8a35-b0a65a5caec0/67e020db226d0dd11782099bb9ae4e7c/dotnet-sdk-5.0.104-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/abbe4347-f7c0-4c07-a495-f9a173154522/d2320cd2a77fab4865559bc3c22ad76b/dotnet-sdk-5.0.104-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0707d53-0310-4767-9db1-67ddc41f6fd8/38761ffd39860954aa7c8a54cbb025ca/dotnet-sdk-5.0.104-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4001b0b2-b2bc-469b-bf00-9077296c39a5/1589b6af52db5c257f228151265b9ffa/dotnet-sdk-5.0.104-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1dfb70ed-2f4a-40fb-a920-4a866440896c/0c4a206d58dc75417217883e8271a633/dotnet-sdk-5.0.104-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/83a9d5eb-879b-42a1-b4b0-5d42d32a6b63/fdc520a9c3d5cd745ebc5296341ef056/dotnet-sdk-5.0.104-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/af611f39-18b5-494e-96c7-3c11b5ffe89b/4cb319fcd73378422010adf58e4db0a2/dotnet-sdk-5.0.104-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3f1f2425-27c3-4c0b-9a29-bf39c36d9c41/f43db159d3fe108c15eb997fe138b577/dotnet-sdk-5.0.104-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/00ca8180-e0e4-44c3-8e2c-16376071bc01/9c1af16773083a389366780b166693a1/dotnet-sdk-5.0.104-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e0a0f0bb-a0ce-4ec4-aa15-5484283d4023/bfce94f5bc619058e526202a58152302/dotnet-sdk-5.0.104-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8491e6bb-d4f7-4da5-a8a3-cb9f4fd0e4fc/2ef911b134883214f7d138d4e396989a/dotnet-sdk-5.0.104-win-x86.zip

