# .NET 5.0.5 - April 06, 2021

The .NET 5.0.5 and .NET SDK 5.0.202 releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

.NET SDK 5.0.202 [resolves an issue where NuGet restore fails on Linux](https://devblogs.microsoft.com/nuget/net-5-nuget-restore-failures-on-linux-distributions-using-nss-or-ca-certificates/) due to expired NuGet certificates and unfortunate interactions with changes made to root certificates stores on Linux, carried by ca-certificates and nss packages.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](5.0.5-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.202
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/master/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.5 release carries only non-security fixes.


* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)
* Resolves [NuGet package restore broken on .NET 5+ with Removal of Trust of Verisign CA](https://github.com/dotnet/announcements/issues/180)
* .NET SDK 5.0.202 includes fixes to the runtime and Windows SDK projections with C#/WinRT v1.1.4. These fixes are for developers targeting a specific Windows SDK version in their project's TargetFramework. Refer to the C#/WinRT v1.1.4 [release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.1.4.210316.1) for a list of bugfixes.


Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.5+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NET Core](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A5.0.5+is%3Aclosed+label%3Aservicing-approved)
* [EntityFramework Core](https://github.com/dotnet/efcore/issues?q=milestone%3A5.0.5+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.5+is%3Aclosed+label%3Aservicing-approved)



## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6129](https://github.com/dotnet/core/issues/6129) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.5.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.5-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-april-2021/




[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.5xx+is%3Aclosed

[linux-packages]: 5.0.5-install-instructions.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.5.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.5.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
System.Reflection.MetadataLoadContext | 5.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.android-x86 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.5.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.5.nupkg
Microsoft.Extensions.Primitives | 5.0.1.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
System.Text.Json | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.ios-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
Microsoft.Extensions.Logging.EventSource | 5.0.1.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.android-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.5.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.5.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
Microsoft.NETCore.Platforms | 5.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.5.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.tvos-arm64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.5.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.ios-arm | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.android-arm | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.android-arm64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.ios-arm64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.5.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.5.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.5.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.5.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.tvos-x64 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.ios-x86 | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.5.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.5.nupkg
dotnet-sql-cache | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.5.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.5.nupkg
Microsoft.AspNetCore.Authorization | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.5.nupkg
Microsoft.dotnet-openapi | 5.0.5.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.5.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.5.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.5.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.5.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.5.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.5.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.5.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.5.nupkg
Microsoft.JSInterop | 5.0.5.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.5.nupkg
Microsoft.Extensions.WebEncoders | 5.0.5.nupkg
Microsoft.Extensions.ObjectPool | 5.0.5.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.5.nupkg
Microsoft.Extensions.Localization | 5.0.5.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.5.nupkg
Microsoft.Extensions.Identity.Core | 5.0.5.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.5.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.5.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.5.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.5.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.5.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.5.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.5.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.5.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.5.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.5.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.5.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.5.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.5.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.5.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.5.nupkg
Microsoft.AspNetCore.Owin | 5.0.5.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.5.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.5.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.5.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.5.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.5.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.5.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.5.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.5.nupkg
Microsoft.AspNetCore.TestHost | 5.0.5.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.5.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.5.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.5.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.5.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.5.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.5.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.5.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.5.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.5.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.5.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.5.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.5.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.5.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.5.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.5.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.5.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.5.nupkg
Microsoft.AspNetCore.Components | 5.0.5.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.5.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.5.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.5.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.5.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.5.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.5.nupkg
Microsoft.AspNetCore.Metadata | 5.0.5.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.5.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.5.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.5.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.5.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.5.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.5.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.5.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.5.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.5.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.5.nupkg
dotnet-ef | 5.0.5.nupkg
Microsoft.Data.Sqlite | 5.0.5.nupkg
Microsoft.EntityFrameworkCore | 5.0.5.nupkg
Microsoft.Data.Sqlite.Core | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.5.nupkg
dotnet-ef | 5.0.5.nupkg
Microsoft.Data.Sqlite | 5.0.5.nupkg
Microsoft.Data.Sqlite.Core | 5.0.5.nupkg
Microsoft.EntityFrameworkCore | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.5.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.5.nupkg
Microsoft.TemplateSearch.Common | 5.0.202.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.202.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.202.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.202.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.202.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.202.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.202.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.202.nupkg
Microsoft.TemplateEngine.Utils | 5.0.202.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.202.nupkg
Microsoft.TemplateEngine.Core | 5.0.202.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.202.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.202.nupkg
Microsoft.TemplateEngine.IDE | 5.0.202.nupkg
Microsoft.TemplateEngine.Edge | 5.0.202.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.202.nupkg


[//]: # ( Runtime 5.0.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09600837-0358-45ce-b530-a25a49490e61/db0ac3b43d1164a0fdd428f64316d188/dotnet-runtime-5.0.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7f6c5b75-07c9-47aa-bc31-9e1343f42929/ad787b9a12b164a7c967ba498151f6aa/dotnet-runtime-5.0.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13d674a3-76ae-45fb-a1b8-f221d64aa9dd/f8d0ece4e54d874cbb6ac55727360580/dotnet-runtime-5.0.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3dbefb2-c60a-4e70-ac19-64483875a1a8/3b6da0d8bea75e64f81d8b38e15f818f/dotnet-runtime-5.0.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2e06b2d-95d5-4b6a-bfb3-5c8ab04a9dff/2a47e7728fa1bd866ab0a9e707d2136c/dotnet-runtime-5.0.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f26a190-5979-4fc4-b67a-df4e5b263e39/39e43561651183bb731ee6f3290fdcff/dotnet-runtime-5.0.5-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0e2acfdc-5dad-48a8-935d-6095a0ae2217/3ffa41859dbb1ca40a7e1ff704651178/dotnet-runtime-5.0.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7334b2cf-01bc-4e63-bb97-e4a3d9190118/d302f372b965fe977b11c088e9407146/dotnet-runtime-5.0.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1201ea91-3344-4745-9143-ad4f7eb0a88d/f04108de4f95817aa1b832061a467be0/dotnet-runtime-5.0.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/cc646f4b-8259-4606-927c-a5d3b5011058/237ca5e21bd169243a5d3420b79abd87/dotnet-runtime-5.0.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e6e9c212-f8ca-4c4d-86be-ecc8d99ba2fe/89c828c00d5b59d4d4d120455433c22d/dotnet-runtime-5.0.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/133b38e9-a51a-4660-8893-fb5a77e012d0/fefd24a68b89d354248e945c6202cdcb/dotnet-runtime-5.0.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/da3570c4-7015-48d0-b340-14810865fb60/45f680c86b37f73bc73d2ed99f9a738c/dotnet-runtime-5.0.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/75b7021b-1750-4626-80cb-1349794733d2/3712b28ccab83b0f475e72d41e703c87/dotnet-runtime-5.0.5-win-x86.zip

[//]: # ( WindowsDesktop 5.0.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/adfb187c-29bf-4181-8c68-eef1ebaf7c4f/9d5010fa6e60749471a0e2ddb2776cf0/windowsdesktop-runtime-5.0.5-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c1ef0b3f-9663-4fc5-85eb-4a9cadacdb87/52b890f91e6bd4350d29d2482038df1c/windowsdesktop-runtime-5.0.5-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c089205d-4f58-4f8d-ad84-c92eaf2f3411/5cd3f9b3bd089c09df14dbbfb64124a4/windowsdesktop-runtime-5.0.5-win-x86.exe

[//]: # ( ASP 5.0.5)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/254a9fbb-e834-470c-af08-294c274a349f/ee755caf0b8a801cf30dcdc0c9e4273d/aspnetcore-runtime-5.0.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3acd1792-c80d-4336-8ffc-552776a1297c/08af3aa6f51d6e8670bb422b6bec5541/aspnetcore-runtime-5.0.5-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63745029-012e-4cbc-9b47-4518b8e1299a/b49fe03ed43978349dd1a192faac753c/aspnetcore-runtime-5.0.5-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/967a8939-1be2-4f9d-94e6-2fb989fa8dc6/9ed94ed16f6b166beb79af1c625199d1/aspnetcore-runtime-5.0.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16709432-660f-4cd3-8fd1-baaed55173b2/4a97f809fb29153e5dd475a795e6906b/aspnetcore-runtime-5.0.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/827b12a8-8dea-43da-92a2-2d24c4936236/d2d61b3ed4b5ba3f682de3e04fc4d243/aspnetcore-runtime-5.0.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6ae7abe-1184-4234-8e06-a5e6028a00d1/63eb26e254eb10ca29bed40aa0801d18/aspnetcore-runtime-5.0.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f71b677c-e6d9-4d0a-8dda-e7a25e297cd6/a5ea05c1ddaf446d0efd2ed393515edd/aspnetcore-runtime-5.0.5-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a91ad09c-d834-4d3f-91a3-0457ac7e1ef3/4788259e62731a07d640495e8cde76cd/aspnetcore-runtime-5.0.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5fa338e7-89ec-48b6-afa0-32676b7c81e1/8daa9c8fb70b08fca05c4b088a0489ea/aspnetcore-runtime-5.0.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bacec315-bfea-42cb-bb06-3fa9eeedb361/86216a39bdde879abf32cb742c7cfec4/aspnetcore-runtime-5.0.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a71e129c-c459-4742-b2e1-987ca6848a35/7c98f23623913bd0cde3ceb6a5c85d2c/aspnetcore-runtime-5.0.5-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c80056cc-e6e9-4c57-9973-3167ef6e3c28/6bc80fa159c10a1be63cf1e4d13fcbbc/dotnet-hosting-5.0.5-win.exe

[//]: # ( SDK 5.0.202 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fada9b0c-202a-4720-817b-b8b92dddad99/fa6ace43156b7f73e5f7fb3cdfb5c302/dotnet-sdk-5.0.202-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1f15b51-5e8c-4e6c-a803-241790159af3/b5cbcc59f67089d760e0ed4a714c47ed/dotnet-sdk-5.0.202-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bff808a5-6749-43c8-9c59-6b5307c388bd/63b0ded4cf1baf2955265dda7dd23dea/dotnet-sdk-5.0.202-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b55f4c6-4082-4128-8667-9b3e561e1c87/f543bc73c12ac8f9414cfb25c6019529/dotnet-sdk-5.0.202-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/21fdb75c-4eb5-476d-a8b8-1d096e4b7b14/c1f853410a58713cf5a56518ceeb87e8/dotnet-sdk-5.0.202-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f0f07ab-cd9a-4498-a9f7-67d90d582180/2a3db6698751e6cbb93ec244cb81cc5f/dotnet-sdk-5.0.202-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9c55b92b-395d-44ca-bf9c-ede066283f10/5a0e0d6101f10e227b49502e8e6a9000/dotnet-sdk-5.0.202-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/749775e4-7b6f-4367-bb7a-9cb63a818dae/c2614b34e234fa03dc65320a8a954570/dotnet-sdk-5.0.202-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7d92db4-5f1f-4478-9caf-6e45c6ac8b09/2363d553132aaed687265c563431673b/dotnet-sdk-5.0.202-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4e75938f-56ff-46f6-86ff-705b9db80f66/24d82414d7bdbcd35d6663a9a8a8a579/dotnet-sdk-5.0.202-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f19ddfd7-cf27-48b4-9d25-facd4e53ff5e/92c8e884f83e5007026656d7fd1d5602/dotnet-sdk-5.0.202-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2de622da-5342-48ec-b997-8b025d8ee478/5c11b643ea7534f749cd3f0e0302715a/dotnet-sdk-5.0.202-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9d866cb7-8678-461b-81a2-0804fa558c32/d63014e15863da828597b4e339e9c6fb/dotnet-sdk-5.0.202-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4e1426ee-1560-4df2-b307-692e28941ebf/aa8910349571ff68407e42ed63ee5f5d/dotnet-sdk-5.0.202-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4d96ac0d-0797-4fab-8ac0-9a6fc440336f/335046055592ca23ab1d6c28a60bdcad/dotnet-sdk-5.0.202-win-x86.zip

[//]: # ( Runtime 5.0.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09600837-0358-45ce-b530-a25a49490e61/db0ac3b43d1164a0fdd428f64316d188/dotnet-runtime-5.0.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7f6c5b75-07c9-47aa-bc31-9e1343f42929/ad787b9a12b164a7c967ba498151f6aa/dotnet-runtime-5.0.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13d674a3-76ae-45fb-a1b8-f221d64aa9dd/f8d0ece4e54d874cbb6ac55727360580/dotnet-runtime-5.0.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3dbefb2-c60a-4e70-ac19-64483875a1a8/3b6da0d8bea75e64f81d8b38e15f818f/dotnet-runtime-5.0.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2e06b2d-95d5-4b6a-bfb3-5c8ab04a9dff/2a47e7728fa1bd866ab0a9e707d2136c/dotnet-runtime-5.0.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f26a190-5979-4fc4-b67a-df4e5b263e39/39e43561651183bb731ee6f3290fdcff/dotnet-runtime-5.0.5-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0e2acfdc-5dad-48a8-935d-6095a0ae2217/3ffa41859dbb1ca40a7e1ff704651178/dotnet-runtime-5.0.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7334b2cf-01bc-4e63-bb97-e4a3d9190118/d302f372b965fe977b11c088e9407146/dotnet-runtime-5.0.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1201ea91-3344-4745-9143-ad4f7eb0a88d/f04108de4f95817aa1b832061a467be0/dotnet-runtime-5.0.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/cc646f4b-8259-4606-927c-a5d3b5011058/237ca5e21bd169243a5d3420b79abd87/dotnet-runtime-5.0.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e6e9c212-f8ca-4c4d-86be-ecc8d99ba2fe/89c828c00d5b59d4d4d120455433c22d/dotnet-runtime-5.0.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/133b38e9-a51a-4660-8893-fb5a77e012d0/fefd24a68b89d354248e945c6202cdcb/dotnet-runtime-5.0.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/da3570c4-7015-48d0-b340-14810865fb60/45f680c86b37f73bc73d2ed99f9a738c/dotnet-runtime-5.0.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/75b7021b-1750-4626-80cb-1349794733d2/3712b28ccab83b0f475e72d41e703c87/dotnet-runtime-5.0.5-win-x86.zip

[//]: # ( WindowsDesktop 5.0.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/adfb187c-29bf-4181-8c68-eef1ebaf7c4f/9d5010fa6e60749471a0e2ddb2776cf0/windowsdesktop-runtime-5.0.5-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c1ef0b3f-9663-4fc5-85eb-4a9cadacdb87/52b890f91e6bd4350d29d2482038df1c/windowsdesktop-runtime-5.0.5-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c089205d-4f58-4f8d-ad84-c92eaf2f3411/5cd3f9b3bd089c09df14dbbfb64124a4/windowsdesktop-runtime-5.0.5-win-x86.exe

[//]: # ( ASP 5.0.5)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/254a9fbb-e834-470c-af08-294c274a349f/ee755caf0b8a801cf30dcdc0c9e4273d/aspnetcore-runtime-5.0.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3acd1792-c80d-4336-8ffc-552776a1297c/08af3aa6f51d6e8670bb422b6bec5541/aspnetcore-runtime-5.0.5-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63745029-012e-4cbc-9b47-4518b8e1299a/b49fe03ed43978349dd1a192faac753c/aspnetcore-runtime-5.0.5-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/967a8939-1be2-4f9d-94e6-2fb989fa8dc6/9ed94ed16f6b166beb79af1c625199d1/aspnetcore-runtime-5.0.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16709432-660f-4cd3-8fd1-baaed55173b2/4a97f809fb29153e5dd475a795e6906b/aspnetcore-runtime-5.0.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/827b12a8-8dea-43da-92a2-2d24c4936236/d2d61b3ed4b5ba3f682de3e04fc4d243/aspnetcore-runtime-5.0.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6ae7abe-1184-4234-8e06-a5e6028a00d1/63eb26e254eb10ca29bed40aa0801d18/aspnetcore-runtime-5.0.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f71b677c-e6d9-4d0a-8dda-e7a25e297cd6/a5ea05c1ddaf446d0efd2ed393515edd/aspnetcore-runtime-5.0.5-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a91ad09c-d834-4d3f-91a3-0457ac7e1ef3/4788259e62731a07d640495e8cde76cd/aspnetcore-runtime-5.0.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5fa338e7-89ec-48b6-afa0-32676b7c81e1/8daa9c8fb70b08fca05c4b088a0489ea/aspnetcore-runtime-5.0.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bacec315-bfea-42cb-bb06-3fa9eeedb361/86216a39bdde879abf32cb742c7cfec4/aspnetcore-runtime-5.0.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a71e129c-c459-4742-b2e1-987ca6848a35/7c98f23623913bd0cde3ceb6a5c85d2c/aspnetcore-runtime-5.0.5-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c80056cc-e6e9-4c57-9973-3167ef6e3c28/6bc80fa159c10a1be63cf1e4d13fcbbc/dotnet-hosting-5.0.5-win.exe

[//]: # ( SDK 5.0.202 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fada9b0c-202a-4720-817b-b8b92dddad99/fa6ace43156b7f73e5f7fb3cdfb5c302/dotnet-sdk-5.0.202-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1f15b51-5e8c-4e6c-a803-241790159af3/b5cbcc59f67089d760e0ed4a714c47ed/dotnet-sdk-5.0.202-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bff808a5-6749-43c8-9c59-6b5307c388bd/63b0ded4cf1baf2955265dda7dd23dea/dotnet-sdk-5.0.202-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b55f4c6-4082-4128-8667-9b3e561e1c87/f543bc73c12ac8f9414cfb25c6019529/dotnet-sdk-5.0.202-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/21fdb75c-4eb5-476d-a8b8-1d096e4b7b14/c1f853410a58713cf5a56518ceeb87e8/dotnet-sdk-5.0.202-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f0f07ab-cd9a-4498-a9f7-67d90d582180/2a3db6698751e6cbb93ec244cb81cc5f/dotnet-sdk-5.0.202-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9c55b92b-395d-44ca-bf9c-ede066283f10/5a0e0d6101f10e227b49502e8e6a9000/dotnet-sdk-5.0.202-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/749775e4-7b6f-4367-bb7a-9cb63a818dae/c2614b34e234fa03dc65320a8a954570/dotnet-sdk-5.0.202-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7d92db4-5f1f-4478-9caf-6e45c6ac8b09/2363d553132aaed687265c563431673b/dotnet-sdk-5.0.202-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4e75938f-56ff-46f6-86ff-705b9db80f66/24d82414d7bdbcd35d6663a9a8a8a579/dotnet-sdk-5.0.202-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f19ddfd7-cf27-48b4-9d25-facd4e53ff5e/92c8e884f83e5007026656d7fd1d5602/dotnet-sdk-5.0.202-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2de622da-5342-48ec-b997-8b025d8ee478/5c11b643ea7534f749cd3f0e0302715a/dotnet-sdk-5.0.202-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9d866cb7-8678-461b-81a2-0804fa558c32/d63014e15863da828597b4e339e9c6fb/dotnet-sdk-5.0.202-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4e1426ee-1560-4df2-b307-692e28941ebf/aa8910349571ff68407e42ed63ee5f5d/dotnet-sdk-5.0.202-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4d96ac0d-0797-4fab-8ac0-9a6fc440336f/335046055592ca23ab1d6c28a60bdcad/dotnet-sdk-5.0.202-win-x86.zip

