# .NET 5.0.6 - May 11, 2021

The .NET 5.0.6 and .NET SDK 5.0.203 releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

.NET SDK 5.0.202 [resolves an issue where NuGet restore fails on Linux](https://devblogs.microsoft.com/nuget/net-5-nuget-restore-failures-on-linux-distributions-using-nss-or-ca-certificates/) due to expired NuGet certificates and unfortunate interactions with changes made to root certificates stores on Linux, carried by ca-certificates and nss packages.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](5.0.6-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.203
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/master/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.6 release carries both security and non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)
* Resolves [NuGet package restore broken on .NET 5+ with Removal of Trust of Verisign CA](https://github.com/dotnet/announcements/issues/180)

Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.6+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NET Core](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A5.0.6+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.6+is%3Aclosed+label%3Aservicing-approved)

### Microsoft Security Advisory CVE-2021-31204 | .NET Core Elevation of Privilege Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An elevation of privilage vulnerability exists in .NET 5.0 and .NET Core 3.1 when a user runs a single file application on Operating Systems based on Linux or macOS.




## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6247](https://github.com/dotnet/core/issues/6247) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.6.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.6-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.6-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-may-2021/




[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.6xx+is%3Aclosed

[linux-packages]: 5.0.6-install-instructions.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.6.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.6.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.6.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.6.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.6.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.6.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.6.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.6.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
Microsoft.NETCore.DotNetHost | 5.0.6.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.6.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.6.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.6.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.6.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.6.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.6.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.6.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.6.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.6.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.6.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.6.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.6.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.6.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.6.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.6.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.6.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.6.nupkg
Microsoft.JSInterop | 5.0.6.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.6.nupkg
Microsoft.Extensions.WebEncoders | 5.0.6.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.6.nupkg
Microsoft.Extensions.ObjectPool | 5.0.6.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.6.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.6.nupkg
Microsoft.Extensions.Localization | 5.0.6.nupkg
Microsoft.Extensions.Identity.Core | 5.0.6.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.6.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.6.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.6.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.6.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.6.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.6.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.6.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.6.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.6.nupkg
dotnet-sql-cache | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.6.nupkg
Microsoft.AspNetCore.Authorization | 5.0.6.nupkg
Microsoft.AspNetCore.Owin | 5.0.6.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.6.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.6.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.6.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.6.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.6.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.6.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.6.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.6.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.6.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.6.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.6.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.6.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.6.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.6.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.6.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.6.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.6.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.6.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.6.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.6.nupkg
Microsoft.dotnet-openapi | 5.0.6.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.6.nupkg
Microsoft.AspNetCore.TestHost | 5.0.6.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.6.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.6.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.6.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.6.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.6.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.6.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.6.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.6.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.6.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.6.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.6.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.6.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.6.nupkg
Microsoft.AspNetCore.Components | 5.0.6.nupkg
Microsoft.AspNetCore.Metadata | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.6.nupkg
dotnet-ef | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.6.nupkg
Microsoft.Data.Sqlite.Core | 5.0.6.nupkg
Microsoft.Data.Sqlite | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.6.nupkg
Microsoft.EntityFrameworkCore | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.6.nupkg
dotnet-ef | 5.0.6.nupkg
Microsoft.Data.Sqlite | 5.0.6.nupkg
Microsoft.Data.Sqlite.Core | 5.0.6.nupkg
Microsoft.EntityFrameworkCore | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.6.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.6.nupkg
Microsoft.TemplateSearch.Common | 5.0.203.nupkg
Microsoft.TemplateEngine.Utils | 5.0.203.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.203.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.203.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.203.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.203.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.203.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.203.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.203.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.203.nupkg
Microsoft.TemplateEngine.Core | 5.0.203.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.203.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.203.nupkg
Microsoft.TemplateEngine.Edge | 5.0.203.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.203.nupkg
Microsoft.TemplateEngine.IDE | 5.0.203.nupkg



[//]: # ( Runtime 5.0.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97301aed-7094-4bc6-9264-ff63b974a353/e5040909f601aa8c6ddaf14c06dbe8d1/dotnet-runtime-5.0.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ad82603-bebf-4d28-8bc8-cfc826ad7893/ca22f36c4752f579c13e0414ec804c15/dotnet-runtime-5.0.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c11fc596-1992-4f6d-b475-4fcbbaf1e8bc/4bfbbefd22fe6f7907e9421fb477073f/dotnet-runtime-5.0.6-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/64fefcd4-998f-48b0-b756-f01d5e0e3494/69d253cd368cf7fd4b56529cd8a41da0/dotnet-runtime-5.0.6-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cca0193f-0666-4b36-8897-e3ddb769b7bb/e38d307ebd1d7775758cb0e9f584c08b/dotnet-runtime-5.0.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/24b0e058-613e-415a-b624-09fb716cc129/91a51ddfd832aaa94cec5b117bf4db23/dotnet-runtime-5.0.6-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4e2e2c76-626f-4927-8753-55d47ab79e06/24417509d68777cab1ed5f927e86db82/dotnet-runtime-5.0.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23d7463b-e17a-49a1-af13-9248bf12b128/35a83a4312b6e9b36bc5fae0ffd565bc/dotnet-runtime-5.0.6-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f4942a69-e576-45bd-a722-9caf0cfc2456/4ca359a7bea10f495a94087210f67b21/dotnet-runtime-5.0.6-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2fa7b891-4da4-4cc5-af7d-48183027bebd/0bd7e549ab01f84059687f0e5fe392c6/dotnet-runtime-5.0.6-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c6c04d2c-d131-4de7-b97a-c29ceca9ee8e/5a654bdbc0a61c621d59be9601e041d6/dotnet-runtime-5.0.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9fcfcf4b-b997-41d6-b659-a1bf1a832045/a5ce096a05e34a7dec8c79f14a221ff0/dotnet-runtime-5.0.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/67839ecf-8e05-411a-977b-ac9780e18279/76f413425112f3dd1d77d48f69a76f59/dotnet-runtime-5.0.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1f221cce-9674-44a0-b4c4-19e1622ae7d1/be54adc56884a2b15c315ae934016a74/dotnet-runtime-5.0.6-win-x86.zip

[//]: # ( WindowsDesktop 5.0.6)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/63040d2c-e953-492f-ae93-7d93cc658e7b/1fce7e44a06c2d432fc0a492ca2b1a13/windowsdesktop-runtime-5.0.6-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6279dc90-f437-4481-82a5-73dd9f97da06/6519ef44735fd31115b9b1a81d6ff1e8/windowsdesktop-runtime-5.0.6-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/315854e8-6857-4d0d-b7e0-57761e3f7d12/b31193ac2c9f1674b66cf7a65c2521de/windowsdesktop-runtime-5.0.6-win-x86.exe

[//]: # ( ASP 5.0.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9d2abf34-b484-46ab-8e3b-504b0057827b/7266d743d6441c1f80510a50c17491dc/aspnetcore-runtime-5.0.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b735496-0974-4873-ab92-edc2caa05f99/7fecb279d8abbb8f78bff5474cb2a32c/aspnetcore-runtime-5.0.6-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/378492f7-ed41-45cf-9294-be3df0b37a9c/aad44c7fcb1464c90cdb4d1d6d3faeb3/aspnetcore-runtime-5.0.6-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd714b1f-dae3-4963-95f4-d1dfcaf44631/246eaf46908de9515955b8bfc0ddaab0/aspnetcore-runtime-5.0.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d47e72ac-4317-4292-88cb-d04460019af5/3e7c9762246345cb3431d1a654306d44/aspnetcore-runtime-5.0.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a7f1f6c-6777-42c4-9793-581bba4b632e/e03e6237a8f49f60014d459f0f758923/aspnetcore-runtime-5.0.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fdff418d-5cac-416e-b6d3-7ec2f1c68a34/8f1a06d97eab8244451e9f4a78aa4b4c/aspnetcore-runtime-5.0.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/03a3bfbb-9985-48bb-a20e-102cc228d473/57d56ab3de4a0497564f8d894d862edd/aspnetcore-runtime-5.0.6-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/275d6b51-e594-4edc-8f2f-606351e137ae/8a9e3886344599059dad377739151e37/aspnetcore-runtime-5.0.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ee27c1fe-bdca-4fb8-a303-125081a3e43d/14bb0ed982304f24a6429a5d63e9bff7/aspnetcore-runtime-5.0.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/61284da9-728b-485c-a9e0-dfd4455f773f/facdf8e9e1509ec4d6f40fce95ff68dd/aspnetcore-runtime-5.0.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fd72844c-693a-4a15-b369-70b71c58ee1a/fdf5a3e63b8793b90b6d8076abe0dd8a/aspnetcore-runtime-5.0.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/24847c36-9f3a-40c1-8e3f-4389d954086d/0e8ae4f4a8e604a6575702819334d703/dotnet-hosting-5.0.6-win.exe

[//]: # ( SDK 5.0.203 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/55547694-fe7e-43f3-bf58-33ef9bb7ee85/5d8b57df472b96e6f38988041751ba2e/dotnet-sdk-5.0.203-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af5f1e5b-d544-47af-b730-038e4258641b/bccb3982f5690134ab66748a5afc36c7/dotnet-sdk-5.0.203-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dad42ab7-32ff-409d-a1e1-0b4e4af5b0d7/351385253fd35a1f6088caf7e8a4fc99/dotnet-sdk-5.0.203-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c8d1814-32d6-4295-813e-9b00948f6278/7ed9d8f9eff80070cef9d92b46d15bcf/dotnet-sdk-5.0.203-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f3836d9-506e-4284-aa31-93ab52c5395c/8eb25aa85c3953bae3cd1935a893b938/dotnet-sdk-5.0.203-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ef13f9da-46dc-4de9-a05e-5a4c20574189/be95913ebf1fb6c66833ca40060d3f65/dotnet-sdk-5.0.203-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f34e658d-d1e2-44d4-a8c0-5eac9d888c4f/3fa21c114dbd8f088526d8f390c25374/dotnet-sdk-5.0.203-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0ec08464-4049-4184-b52d-ab8c90dc0199/5ebc7047c4461257c746dcf471097ea2/dotnet-sdk-5.0.203-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56da864b-1efd-46a6-b761-b285283696cb/1ad897dff863fdd3cdbaf8a447b09317/dotnet-sdk-5.0.203-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/576339d6-eca5-4622-a0d3-babf60d10782/f621cd6444004d3aeae49769889c952e/dotnet-sdk-5.0.203-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8bb8c9e7-06dd-4423-88d7-eb954c3a9641/0565eec4afe5c2994d2cfe7112223d15/dotnet-sdk-5.0.203-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4263dc3b-dc67-4f11-8d46-cc0ae86a232e/66782bbd04c53651f730b2e30a873f18/dotnet-sdk-5.0.203-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/46b35cfe-4b3f-4e69-8831-0937196699b1/221f862c003a0175722c131b0941e3c4/dotnet-sdk-5.0.203-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a87aa2bd-a294-40a9-945b-5e2cc91ea3a7/d073283372b3cb6b4bb4b11d57bd6a0c/dotnet-sdk-5.0.203-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0d39e3cc-3515-4681-b626-d0ccc4cc57cf/73435076c45fb2edd07f46aadc53f9eb/dotnet-sdk-5.0.203-win-x86.zip
