```
These APIs were previously available via nuget and are now available in-box.
```
# System.Formats.Asn1

``` diff
+namespace System.Formats.Asn1 {
+    public readonly struct Asn1Tag : IEquatable<Asn1Tag> {
+        public static readonly Asn1Tag Boolean;
+        public static readonly Asn1Tag ConstructedBitString;
+        public static readonly Asn1Tag ConstructedOctetString;
+        public static readonly Asn1Tag Enumerated;
+        public static readonly Asn1Tag GeneralizedTime;
+        public static readonly Asn1Tag Integer;
+        public static readonly Asn1Tag Null;
+        public static readonly Asn1Tag ObjectIdentifier;
+        public static readonly Asn1Tag PrimitiveBitString;
+        public static readonly Asn1Tag PrimitiveOctetString;
+        public static readonly Asn1Tag Sequence;
+        public static readonly Asn1Tag SetOf;
+        public static readonly Asn1Tag UtcTime;
+        public Asn1Tag(TagClass tagClass, int tagValue, bool isConstructed = false);
+        public Asn1Tag(UniversalTagNumber universalTagNumber, bool isConstructed = false);
+        public bool IsConstructed { get; }
+        public TagClass TagClass { get; }
+        public int TagValue { get; }
+        public Asn1Tag AsConstructed();
+        public Asn1Tag AsPrimitive();
+        public int CalculateEncodedSize();
+        public static Asn1Tag Decode(ReadOnlySpan<byte> source, out int bytesConsumed);
+        public int Encode(Span<byte> destination);
+        public bool Equals(Asn1Tag other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public bool HasSameClassAndValue(Asn1Tag other);
+        public static bool operator ==(Asn1Tag left, Asn1Tag right);
+        public static bool operator !=(Asn1Tag left, Asn1Tag right);
+        public override string ToString();
+        public static bool TryDecode(ReadOnlySpan<byte> source, out Asn1Tag tag, out int bytesConsumed);
+        public bool TryEncode(Span<byte> destination, out int bytesWritten);
+    }
+    public class AsnContentException : Exception {
+        public AsnContentException();
+        protected AsnContentException(SerializationInfo info, StreamingContext context);
+        public AsnContentException(string message);
+        public AsnContentException(string message, Exception inner);
+    }
+    public static class AsnDecoder {
+        public static byte[] ReadBitString(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int unusedBitCount, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool ReadBoolean(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static string ReadCharacterString(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, UniversalTagNumber encodingType, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static Asn1Tag ReadEncodedValue(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int contentOffset, out int contentLength, out int bytesConsumed);
+        public static ReadOnlySpan<byte> ReadEnumeratedBytes(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static Enum ReadEnumeratedValue(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, Type enumType, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static TEnum ReadEnumeratedValue<TEnum>(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?)) where TEnum : Enum;
+        public static DateTimeOffset ReadGeneralizedTime(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static BigInteger ReadInteger(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static ReadOnlySpan<byte> ReadIntegerBytes(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static BitArray ReadNamedBitList(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static Enum ReadNamedBitListValue(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, Type flagsEnumType, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static TFlagsEnum ReadNamedBitListValue<TFlagsEnum>(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?)) where TFlagsEnum : Enum;
+        public static void ReadNull(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static string ReadObjectIdentifier(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static byte[] ReadOctetString(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static void ReadSequence(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int contentOffset, out int contentLength, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static void ReadSetOf(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int contentOffset, out int contentLength, out int bytesConsumed, bool skipSortOrderValidation = false, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static DateTimeOffset ReadUtcTime(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int bytesConsumed, int twoDigitYearMax = 2049, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool TryReadBitString(ReadOnlySpan<byte> source, Span<byte> destination, AsnEncodingRules ruleSet, out int unusedBitCount, out int bytesConsumed, out int bytesWritten, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool TryReadCharacterString(ReadOnlySpan<byte> source, Span<char> destination, AsnEncodingRules ruleSet, UniversalTagNumber encodingType, out int bytesConsumed, out int charsWritten, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool TryReadCharacterStringBytes(ReadOnlySpan<byte> source, Span<byte> destination, AsnEncodingRules ruleSet, Asn1Tag expectedTag, out int bytesConsumed, out int bytesWritten);
+        public static bool TryReadEncodedValue(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out Asn1Tag tag, out int contentOffset, out int contentLength, out int bytesConsumed);
+        public static bool TryReadInt32(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int value, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool TryReadInt64(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out long value, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool TryReadOctetString(ReadOnlySpan<byte> source, Span<byte> destination, AsnEncodingRules ruleSet, out int bytesConsumed, out int bytesWritten, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool TryReadPrimitiveBitString(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out int unusedBitCount, out ReadOnlySpan<byte> value, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool TryReadPrimitiveCharacterStringBytes(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, Asn1Tag expectedTag, out ReadOnlySpan<byte> value, out int bytesConsumed);
+        public static bool TryReadPrimitiveOctetString(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out ReadOnlySpan<byte> value, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool TryReadUInt32(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out uint value, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public static bool TryReadUInt64(ReadOnlySpan<byte> source, AsnEncodingRules ruleSet, out ulong value, out int bytesConsumed, Asn1Tag? expectedTag = default(Asn1Tag?));
+    }
+    public enum AsnEncodingRules {
+        BER = 0,
+        CER = 1,
+        DER = 2,
+    }
+    public class AsnReader {
+        public AsnReader(ReadOnlyMemory<byte> data, AsnEncodingRules ruleSet, AsnReaderOptions options = default(AsnReaderOptions));
+        public bool HasData { get; }
+        public AsnEncodingRules RuleSet { get; }
+        public ReadOnlyMemory<byte> PeekContentBytes();
+        public ReadOnlyMemory<byte> PeekEncodedValue();
+        public Asn1Tag PeekTag();
+        public byte[] ReadBitString(out int unusedBitCount, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public bool ReadBoolean(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public string ReadCharacterString(UniversalTagNumber encodingType, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public ReadOnlyMemory<byte> ReadEncodedValue();
+        public ReadOnlyMemory<byte> ReadEnumeratedBytes(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public Enum ReadEnumeratedValue(Type enumType, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public TEnum ReadEnumeratedValue<TEnum>(Asn1Tag? expectedTag = default(Asn1Tag?)) where TEnum : Enum;
+        public DateTimeOffset ReadGeneralizedTime(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public BigInteger ReadInteger(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public ReadOnlyMemory<byte> ReadIntegerBytes(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public BitArray ReadNamedBitList(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public Enum ReadNamedBitListValue(Type flagsEnumType, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public TFlagsEnum ReadNamedBitListValue<TFlagsEnum>(Asn1Tag? expectedTag = default(Asn1Tag?)) where TFlagsEnum : Enum;
+        public void ReadNull(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public string ReadObjectIdentifier(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public byte[] ReadOctetString(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public AsnReader ReadSequence(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public AsnReader ReadSetOf(bool skipSortOrderValidation, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public AsnReader ReadSetOf(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public DateTimeOffset ReadUtcTime(int twoDigitYearMax, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public DateTimeOffset ReadUtcTime(Asn1Tag? expectedTag = default(Asn1Tag?));
+        public void ThrowIfNotEmpty();
+        public bool TryReadBitString(Span<byte> destination, out int unusedBitCount, out int bytesWritten, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public bool TryReadCharacterString(Span<char> destination, UniversalTagNumber encodingType, out int charsWritten, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public bool TryReadCharacterStringBytes(Span<byte> destination, Asn1Tag expectedTag, out int bytesWritten);
+        public bool TryReadInt32(out int value, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public bool TryReadInt64(out long value, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public bool TryReadOctetString(Span<byte> destination, out int bytesWritten, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public bool TryReadPrimitiveBitString(out int unusedBitCount, out ReadOnlyMemory<byte> value, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public bool TryReadPrimitiveCharacterStringBytes(Asn1Tag expectedTag, out ReadOnlyMemory<byte> contents);
+        public bool TryReadPrimitiveOctetString(out ReadOnlyMemory<byte> contents, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public bool TryReadUInt32(out uint value, Asn1Tag? expectedTag = default(Asn1Tag?));
+        public bool TryReadUInt64(out ulong value, Asn1Tag? expectedTag = default(Asn1Tag?));
+    }
+    public struct AsnReaderOptions {
+        public bool SkipSetSortOrderVerification { get; set; }
+        public int UtcTimeTwoDigitYearMax { get; set; }
+    }
+    public sealed class AsnWriter {
+        public AsnWriter(AsnEncodingRules ruleSet);
+        public AsnEncodingRules RuleSet { get; }
+        public void CopyTo(AsnWriter destination);
+        public byte[] Encode();
+        public int Encode(Span<byte> destination);
+        public bool EncodedValueEquals(AsnWriter other);
+        public bool EncodedValueEquals(ReadOnlySpan<byte> other);
+        public int GetEncodedLength();
+        public void PopOctetString(Asn1Tag? tag = default(Asn1Tag?));
+        public void PopSequence(Asn1Tag? tag = default(Asn1Tag?));
+        public void PopSetOf(Asn1Tag? tag = default(Asn1Tag?));
+        public AsnWriter.Scope PushOctetString(Asn1Tag? tag = default(Asn1Tag?));
+        public AsnWriter.Scope PushSequence(Asn1Tag? tag = default(Asn1Tag?));
+        public AsnWriter.Scope PushSetOf(Asn1Tag? tag = default(Asn1Tag?));
+        public void Reset();
+        public bool TryEncode(Span<byte> destination, out int bytesWritten);
+        public void WriteBitString(ReadOnlySpan<byte> value, int unusedBitCount = 0, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteBoolean(bool value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteCharacterString(UniversalTagNumber encodingType, ReadOnlySpan<char> str, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteCharacterString(UniversalTagNumber encodingType, string value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteEncodedValue(ReadOnlySpan<byte> value);
+        public void WriteEnumeratedValue(Enum value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteEnumeratedValue<TEnum>(TEnum value, Asn1Tag? tag = default(Asn1Tag?)) where TEnum : Enum;
+        public void WriteGeneralizedTime(DateTimeOffset value, bool omitFractionalSeconds = false, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteInteger(long value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteInteger(BigInteger value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteInteger(ReadOnlySpan<byte> value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteInteger(ulong value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteIntegerUnsigned(ReadOnlySpan<byte> value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteNamedBitList(BitArray value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteNamedBitList(Enum value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteNamedBitList<TEnum>(TEnum value, Asn1Tag? tag = default(Asn1Tag?)) where TEnum : Enum;
+        public void WriteNull(Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteObjectIdentifier(ReadOnlySpan<char> oidValue, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteObjectIdentifier(string oidValue, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteOctetString(ReadOnlySpan<byte> value, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteUtcTime(DateTimeOffset value, int twoDigitYearMax, Asn1Tag? tag = default(Asn1Tag?));
+        public void WriteUtcTime(DateTimeOffset value, Asn1Tag? tag = default(Asn1Tag?));
+        public readonly struct Scope : IDisposable {
+            public void Dispose();
+        }
+    }
+    public enum TagClass {
+        Application = 64,
+        ContextSpecific = 128,
+        Private = 192,
+        Universal = 0,
+    }
+    public enum UniversalTagNumber {
+        BitString = 3,
+        BMPString = 30,
+        Boolean = 1,
+        Date = 31,
+        DateTime = 33,
+        Duration = 34,
+        Embedded = 11,
+        EndOfContents = 0,
+        Enumerated = 10,
+        External = 8,
+        GeneralizedTime = 24,
+        GeneralString = 27,
+        GraphicString = 25,
+        IA5String = 22,
+        InstanceOf = 8,
+        Integer = 2,
+        ISO646String = 26,
+        Null = 5,
+        NumericString = 18,
+        ObjectDescriptor = 7,
+        ObjectIdentifier = 6,
+        ObjectIdentifierIRI = 35,
+        OctetString = 4,
+        PrintableString = 19,
+        Real = 9,
+        RelativeObjectIdentifier = 13,
+        RelativeObjectIdentifierIRI = 36,
+        Sequence = 16,
+        SequenceOf = 16,
+        Set = 17,
+        SetOf = 17,
+        T61String = 20,
+        TeletexString = 20,
+        Time = 14,
+        TimeOfDay = 32,
+        UniversalString = 28,
+        UnrestrictedCharacterString = 29,
+        UtcTime = 23,
+        UTF8String = 12,
+        VideotexString = 21,
+        VisibleString = 26,
+    }
+}
```

