# System.Net.Http

``` diff
 namespace System.Net.Http {
     public class ByteArrayContent : HttpContent {
+        protected override Stream CreateContentReadStream(CancellationToken cancellationToken);
+        protected override void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public abstract class DelegatingHandler : HttpMessageHandler {
+        protected internal override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class FormUrlEncodedContent : ByteArrayContent {
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
+    public delegate Encoding HeaderEncodingSelector<TContext>(string headerName, TContext context);
     public class HttpClient : HttpMessageInvoker {
+        public HttpVersionPolicy DefaultVersionPolicy { get; set; }
+        public Task<byte[]> GetByteArrayAsync(string requestUri, CancellationToken cancellationToken);
+        public Task<byte[]> GetByteArrayAsync(Uri requestUri, CancellationToken cancellationToken);
+        public Task<Stream> GetStreamAsync(string requestUri, CancellationToken cancellationToken);
+        public Task<Stream> GetStreamAsync(Uri requestUri, CancellationToken cancellationToken);
+        public Task<string> GetStringAsync(string requestUri, CancellationToken cancellationToken);
+        public Task<string> GetStringAsync(Uri requestUri, CancellationToken cancellationToken);
+        public HttpResponseMessage Send(HttpRequestMessage request);
+        public HttpResponseMessage Send(HttpRequestMessage request, HttpCompletionOption completionOption);
+        public HttpResponseMessage Send(HttpRequestMessage request, HttpCompletionOption completionOption, CancellationToken cancellationToken);
+        public override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class HttpClientHandler : HttpMessageHandler {
+        protected internal override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public abstract class HttpContent : IDisposable {
+        public void CopyTo(Stream stream, TransportContext context, CancellationToken cancellationToken);
+        public Task CopyToAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
+        public Task CopyToAsync(Stream stream, CancellationToken cancellationToken);
+        protected virtual Stream CreateContentReadStream(CancellationToken cancellationToken);
+        protected virtual Task<Stream> CreateContentReadStreamAsync(CancellationToken cancellationToken);
+        public Task<byte[]> ReadAsByteArrayAsync(CancellationToken cancellationToken);
+        public Stream ReadAsStream();
+        public Stream ReadAsStream(CancellationToken cancellationToken);
+        public Task<Stream> ReadAsStreamAsync(CancellationToken cancellationToken);
+        public Task<string> ReadAsStringAsync(CancellationToken cancellationToken);
+        protected virtual void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
+        protected virtual Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
+    public enum HttpKeepAlivePingPolicy {
+        Always = 1,
+        WithActiveRequests = 0,
+    }
     public abstract class HttpMessageHandler : IDisposable {
+        protected internal virtual HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class HttpMessageInvoker : IDisposable {
+        public virtual HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class HttpRequestException : Exception {
+        public HttpRequestException(string message, Exception inner, HttpStatusCode? statusCode);
+        public HttpStatusCode? StatusCode { get; }
     }
     public class HttpRequestMessage : IDisposable {
+        public HttpRequestOptions Options { get; }
+        public HttpVersionPolicy VersionPolicy { get; set; }
     }
+    public sealed class HttpRequestOptions : ICollection<KeyValuePair<string, object>>, IDictionary<string, object>, IEnumerable, IEnumerable<KeyValuePair<string, object>> {
+        public HttpRequestOptions();
+        int System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Count { get; }
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.IsReadOnly { get; }
+        object System.Collections.Generic.IDictionary<System.String,System.Object>.this[string key] { get; set; }
+        ICollection<string> System.Collections.Generic.IDictionary<System.String,System.Object>.Keys { get; }
+        ICollection<object> System.Collections.Generic.IDictionary<System.String,System.Object>.Values { get; }
+        public void Set<TValue>(HttpRequestOptionsKey<TValue> key, TValue value);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Add(KeyValuePair<string, object> item);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Clear();
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Contains(KeyValuePair<string, object> item);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.CopyTo(KeyValuePair<string, object>[] array, int arrayIndex);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Remove(KeyValuePair<string, object> item);
+        void System.Collections.Generic.IDictionary<System.String,System.Object>.Add(string key, object value);
+        bool System.Collections.Generic.IDictionary<System.String,System.Object>.ContainsKey(string key);
+        bool System.Collections.Generic.IDictionary<System.String,System.Object>.Remove(string key);
+        bool System.Collections.Generic.IDictionary<System.String,System.Object>.TryGetValue(string key, out object value);
+        IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public bool TryGetValue<TValue>(HttpRequestOptionsKey<TValue> key, out TValue value);
+    }
+    public readonly struct HttpRequestOptionsKey<TValue> {
+        public HttpRequestOptionsKey(string key);
+        public string Key { get; }
+    }
+    public enum HttpVersionPolicy {
+        RequestVersionExact = 2,
+        RequestVersionOrHigher = 1,
+        RequestVersionOrLower = 0,
+    }
     public abstract class MessageProcessingHandler : DelegatingHandler {
+        protected internal sealed override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class MultipartContent : HttpContent, IEnumerable, IEnumerable<HttpContent> {
+        public HeaderEncodingSelector<HttpContent> HeaderEncodingSelector { get; set; }
+        protected override Stream CreateContentReadStream(CancellationToken cancellationToken);
+        protected override Task<Stream> CreateContentReadStreamAsync(CancellationToken cancellationToken);
+        protected override void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public class MultipartFormDataContent : MultipartContent {
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public sealed class ReadOnlyMemoryContent : HttpContent {
+        protected override Stream CreateContentReadStream(CancellationToken cancellationToken);
+        protected override void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
+    public sealed class SocketsHttpConnectionContext {
+        public DnsEndPoint DnsEndPoint { get; }
+        public HttpRequestMessage InitialRequestMessage { get; }
+    }
     public sealed class SocketsHttpHandler : HttpMessageHandler {
+        public Func<SocketsHttpConnectionContext, CancellationToken, ValueTask<Stream>> ConnectCallback { get; set; }
+        public bool EnableMultipleHttp2Connections { get; set; }
+        public static bool IsSupported { get; }
+        public TimeSpan KeepAlivePingDelay { get; set; }
+        public HttpKeepAlivePingPolicy KeepAlivePingPolicy { get; set; }
+        public TimeSpan KeepAlivePingTimeout { get; set; }
+        public Func<SocketsHttpPlaintextStreamFilterContext, CancellationToken, ValueTask<Stream>> PlaintextStreamFilter { get; set; }
+        public HeaderEncodingSelector<HttpRequestMessage> RequestHeaderEncodingSelector { get; set; }
+        public HeaderEncodingSelector<HttpRequestMessage> ResponseHeaderEncodingSelector { get; set; }
+        protected internal override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
+    public sealed class SocketsHttpPlaintextStreamFilterContext {
+        public HttpRequestMessage InitialRequestMessage { get; }
+        public Version NegotiatedHttpVersion { get; }
+        public Stream PlaintextStream { get; }
+    }
     public class StreamContent : HttpContent {
+        protected override Stream CreateContentReadStream(CancellationToken cancellationToken);
+        protected override void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public class StringContent : ByteArrayContent {
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
 }
```

