# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
+    public sealed class JsonConstructorAttribute : JsonAttribute {
+        public JsonConstructorAttribute();
+    }
     public abstract class JsonConverter<T> : JsonConverter {
+        public virtual bool HandleNull { get; }
     }
     public sealed class JsonIgnoreAttribute : JsonAttribute {
+        public JsonIgnoreCondition Condition { get; set; }
     }
+    public enum JsonIgnoreCondition {
+        Always = 1,
+        Never = 0,
+        WhenWritingDefault = 2,
+        WhenWritingNull = 3,
+    }
+    public sealed class JsonIncludeAttribute : JsonAttribute {
+        public JsonIncludeAttribute();
+    }
+    public enum JsonNumberHandling {
+        AllowNamedFloatingPointLiterals = 4,
+        AllowReadingFromString = 1,
+        Strict = 0,
+        WriteAsString = 2,
+    }
+    public sealed class JsonNumberHandlingAttribute : JsonAttribute {
+        public JsonNumberHandlingAttribute(JsonNumberHandling handling);
+        public JsonNumberHandling Handling { get; }
+    }
+    public abstract class ReferenceHandler {
+        protected ReferenceHandler();
+        public static ReferenceHandler Preserve { get; }
+        public abstract ReferenceResolver CreateResolver();
+    }
+    public sealed class ReferenceHandler<T> : ReferenceHandler where T : ReferenceResolver, new() {
+        public ReferenceHandler();
+        public override ReferenceResolver CreateResolver();
+    }
+    public abstract class ReferenceResolver {
+        protected ReferenceResolver();
+        public abstract void AddReference(string referenceId, object value);
+        public abstract string GetReference(object value, out bool alreadyExists);
+        public abstract object ResolveReference(string referenceId);
+    }
 }
```

