# System.Text

``` diff
 namespace System.Text {
     public sealed class CodePagesEncodingProvider : EncodingProvider {
+        public override IEnumerable<EncodingInfo> GetEncodings();
     }
     public abstract class Encoding : ICloneable {
+        public static Encoding Latin1 { get; }
+        public static Stream CreateTranscodingStream(Stream innerStream, Encoding innerStreamEncoding, Encoding outerStreamEncoding, bool leaveOpen = false);
     }
+    public static class EncodingExtensions {
+        public static void Convert(this Decoder decoder, in ReadOnlySequence<byte> bytes, IBufferWriter<char> writer, bool flush, out long charsUsed, out bool completed);
+        public static void Convert(this Decoder decoder, ReadOnlySpan<byte> bytes, IBufferWriter<char> writer, bool flush, out long charsUsed, out bool completed);
+        public static void Convert(this Encoder encoder, in ReadOnlySequence<char> chars, IBufferWriter<byte> writer, bool flush, out long bytesUsed, out bool completed);
+        public static void Convert(this Encoder encoder, ReadOnlySpan<char> chars, IBufferWriter<byte> writer, bool flush, out long bytesUsed, out bool completed);
+        public static byte[] GetBytes(this Encoding encoding, in ReadOnlySequence<char> chars);
+        public static long GetBytes(this Encoding encoding, in ReadOnlySequence<char> chars, IBufferWriter<byte> writer);
+        public static int GetBytes(this Encoding encoding, in ReadOnlySequence<char> chars, Span<byte> bytes);
+        public static long GetBytes(this Encoding encoding, ReadOnlySpan<char> chars, IBufferWriter<byte> writer);
+        public static long GetChars(this Encoding encoding, in ReadOnlySequence<byte> bytes, IBufferWriter<char> writer);
+        public static int GetChars(this Encoding encoding, in ReadOnlySequence<byte> bytes, Span<char> chars);
+        public static long GetChars(this Encoding encoding, ReadOnlySpan<byte> bytes, IBufferWriter<char> writer);
+        public static string GetString(this Encoding encoding, in ReadOnlySequence<byte> bytes);
+    }
     public sealed class EncodingInfo {
+        public EncodingInfo(EncodingProvider provider, int codePage, string name, string displayName);
     }
     public abstract class EncodingProvider {
+        public virtual IEnumerable<EncodingInfo> GetEncodings();
     }
-    public readonly struct Rune : IComparable<Rune>, IEquatable<Rune> {
+    public readonly struct Rune : IComparable, IComparable<Rune>, IEquatable<Rune> {
+        int System.IComparable.CompareTo(object obj);
     }
 }
```

