# Microsoft.AspNetCore.Server.Kestrel.Core

``` diff
 namespace Microsoft.AspNetCore.Server.Kestrel.Core {
-    public sealed class BadHttpRequestException : IOException {
+    public sealed class BadHttpRequestException : BadHttpRequestException {
-        public int StatusCode { get; }
+        public new int StatusCode { get; }
     }
     public class Http2Limits {
+        public TimeSpan KeepAlivePingDelay { get; set; }
+        public TimeSpan KeepAlivePingTimeout { get; set; }
     }
+    public class Http3Limits {
+        public Http3Limits();
+        public int HeaderTableSize { get; set; }
+        public int MaxRequestHeaderFieldSize { get; set; }
+    }
     public enum HttpProtocols {
+        Http1AndHttp2AndHttp3 = 7,
+        Http3 = 4,
     }
     public class KestrelServerLimits {
+        public Http3Limits Http3 { get; }
     }
     public class KestrelServerOptions {
+        public bool AllowResponseHeaderCompression { get; set; }
+        public bool EnableAltSvc { get; set; }
+        public Func<string, Encoding> RequestHeaderEncodingSelector { get; set; }
+        public KestrelConfigurationLoader Configure(IConfiguration config, bool reloadOnChange);
+        public void Listen(EndPoint endPoint);
+        public void Listen(EndPoint endPoint, Action<ListenOptions> configure);
     }
     public class ListenOptions : IConnectionBuilder {
+        public EndPoint EndPoint { get; internal set; }
     }
 }
```

