# Microsoft.AspNetCore.SignalR

``` diff
 namespace Microsoft.AspNetCore.SignalR {
     public static class HubClientsExtensions {
+        public static T AllExcept<T>(this IHubClients<T> hubClients, IEnumerable<string> excludedConnectionIds);
+        public static T Clients<T>(this IHubClients<T> hubClients, IEnumerable<string> connectionIds);
+        public static T GroupExcept<T>(this IHubClients<T> hubClients, string groupName, IEnumerable<string> excludedConnectionIds);
+        public static T Groups<T>(this IHubClients<T> hubClients, IEnumerable<string> groupNames);
+        public static T Users<T>(this IHubClients<T> hubClients, IEnumerable<string> userIds);
     }
     public class HubConnectionContextOptions {
+        public int MaximumParallelInvocations { get; set; }
     }
     public class HubInvocationContext {
+        public HubInvocationContext(HubCallerContext context, IServiceProvider serviceProvider, Hub hub, MethodInfo hubMethod, IReadOnlyList<object> hubMethodArguments);
+        public Hub Hub { get; }
+        public MethodInfo HubMethod { get; }
+        public IServiceProvider ServiceProvider { get; }
     }
+    public sealed class HubLifetimeContext {
+        public HubLifetimeContext(HubCallerContext context, IServiceProvider serviceProvider, Hub hub);
+        public HubCallerContext Context { get; }
+        public Hub Hub { get; }
+        public IServiceProvider ServiceProvider { get; }
+    }
     public class HubOptions {
+        public int MaximumParallelInvocationsPerClient { get; set; }
     }
+    public static class HubOptionsExtensions {
+        public static void AddFilter(this HubOptions options, IHubFilter hubFilter);
+        public static void AddFilter(this HubOptions options, Type filterType);
+        public static void AddFilter<TFilter>(this HubOptions options) where TFilter : IHubFilter;
+    }
-    public class HubRouteBuilder {
 {
-        public HubRouteBuilder(ConnectionsRouteBuilder routes);

-        public void MapHub<THub>(PathString path) where THub : Hub;

-        public void MapHub<THub>(PathString path, Action<HttpConnectionDispatcherOptions> configureOptions) where THub : Hub;

-    }
+    public interface IHubFilter {
+        ValueTask<object> InvokeMethodAsync(HubInvocationContext invocationContext, Func<HubInvocationContext, ValueTask<object>> next);
+        Task OnConnectedAsync(HubLifetimeContext context, Func<HubLifetimeContext, Task> next);
+        Task OnDisconnectedAsync(HubLifetimeContext context, Exception exception, Func<HubLifetimeContext, Exception, Task> next);
+    }
 }
```

