# Microsoft.AspNetCore.WebUtilities

``` diff
 namespace Microsoft.AspNetCore.WebUtilities {
     public class FileBufferingReadStream : Stream {
+        public override Task CopyToAsync(Stream destination, int bufferSize, CancellationToken cancellationToken);
+        public override int Read(Span<byte> buffer);
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public sealed class FileBufferingWriteStream : Stream {
+        public Task DrainBufferAsync(PipeWriter destination, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class HttpRequestStreamReader : TextReader {
+        public override int Read(Span<char> buffer);
+        public override ValueTask<int> ReadAsync(Memory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override string ReadLine();
+        public override Task<string> ReadLineAsync();
+        public override Task<string> ReadToEndAsync();
     }
     public class HttpResponseStreamWriter : TextWriter {
+        public override void Write(ReadOnlySpan<char> value);
+        public override Task WriteAsync(ReadOnlyMemory<char> value, CancellationToken cancellationToken = default(CancellationToken));
+        public override void WriteLine(ReadOnlySpan<char> value);
+        public override Task WriteLineAsync(ReadOnlyMemory<char> value, CancellationToken cancellationToken = default(CancellationToken));
     }
     public static class QueryHelpers {
+        public static string AddQueryString(string uri, IEnumerable<KeyValuePair<string, StringValues>> queryString);
+        public static string AddQueryString(string uri, IEnumerable<KeyValuePair<string, string>> queryString);
     }
 }
```

