# System.Net.Security

``` diff
 namespace System.Net.Security {
+    public sealed class CipherSuitesPolicy {
+        public CipherSuitesPolicy(IEnumerable<TlsCipherSuite> allowedCipherSuites);
+        public IEnumerable<TlsCipherSuite> AllowedCipherSuites { get; }
+    }
     public class NegotiateStream : AuthenticatedStream {
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
+    public delegate ValueTask<SslServerAuthenticationOptions> ServerOptionsSelectionCallback(SslStream stream, SslClientHelloInfo clientHelloInfo, object state, CancellationToken cancellationToken);
     public class SslClientAuthenticationOptions {
+        public CipherSuitesPolicy CipherSuitesPolicy { get; set; }
     }
+    public readonly struct SslClientHelloInfo {
+        public string ServerName { get; }
+        public SslProtocols SslProtocols { get; }
+    }
     public class SslServerAuthenticationOptions {
+        public CipherSuitesPolicy CipherSuitesPolicy { get; set; }
+        public SslStreamCertificateContext ServerCertificateContext { get; set; }
     }
     public class SslStream : AuthenticatedStream {
+        public virtual TlsCipherSuite NegotiatedCipherSuite { get; }
+        public string TargetHostName { get; }
+        public void AuthenticateAsClient(SslClientAuthenticationOptions sslClientAuthenticationOptions);
-        public Task AuthenticateAsClientAsync(SslClientAuthenticationOptions sslClientAuthenticationOptions, CancellationToken cancellationToken);
+        public Task AuthenticateAsClientAsync(SslClientAuthenticationOptions sslClientAuthenticationOptions, CancellationToken cancellationToken = default(CancellationToken));
+        public void AuthenticateAsServer(SslServerAuthenticationOptions sslServerAuthenticationOptions);
+        public Task AuthenticateAsServerAsync(ServerOptionsSelectionCallback optionsCallback, object state, CancellationToken cancellationToken = default(CancellationToken));
-        public Task AuthenticateAsServerAsync(SslServerAuthenticationOptions sslServerAuthenticationOptions, CancellationToken cancellationToken);
+        public Task AuthenticateAsServerAsync(SslServerAuthenticationOptions sslServerAuthenticationOptions, CancellationToken cancellationToken = default(CancellationToken));
+        ~SslStream();
     }
+    public sealed class SslStreamCertificateContext {
+        public static SslStreamCertificateContext Create(X509Certificate2 target, X509Certificate2Collection additionalCertificates, bool offline = false);
+    }
+    public enum TlsCipherSuite : ushort {
+        TLS_AES_128_CCM_8_SHA256 = (ushort)4869,
+        TLS_AES_128_CCM_SHA256 = (ushort)4868,
+        TLS_AES_128_GCM_SHA256 = (ushort)4865,
+        TLS_AES_256_GCM_SHA384 = (ushort)4866,
+        TLS_CHACHA20_POLY1305_SHA256 = (ushort)4867,
+        TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = (ushort)17,
+        TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = (ushort)19,
+        TLS_DHE_DSS_WITH_AES_128_CBC_SHA = (ushort)50,
+        TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 = (ushort)64,
+        TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 = (ushort)162,
+        TLS_DHE_DSS_WITH_AES_256_CBC_SHA = (ushort)56,
+        TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 = (ushort)106,
+        TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 = (ushort)163,
+        TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256 = (ushort)49218,
+        TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = (ushort)49238,
+        TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384 = (ushort)49219,
+        TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = (ushort)49239,
+        TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = (ushort)68,
+        TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)189,
+        TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49280,
+        TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = (ushort)135,
+        TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = (ushort)195,
+        TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49281,
+        TLS_DHE_DSS_WITH_DES_CBC_SHA = (ushort)18,
+        TLS_DHE_DSS_WITH_SEED_CBC_SHA = (ushort)153,
+        TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA = (ushort)143,
+        TLS_DHE_PSK_WITH_AES_128_CBC_SHA = (ushort)144,
+        TLS_DHE_PSK_WITH_AES_128_CBC_SHA256 = (ushort)178,
+        TLS_DHE_PSK_WITH_AES_128_CCM = (ushort)49318,
+        TLS_DHE_PSK_WITH_AES_128_GCM_SHA256 = (ushort)170,
+        TLS_DHE_PSK_WITH_AES_256_CBC_SHA = (ushort)145,
+        TLS_DHE_PSK_WITH_AES_256_CBC_SHA384 = (ushort)179,
+        TLS_DHE_PSK_WITH_AES_256_CCM = (ushort)49319,
+        TLS_DHE_PSK_WITH_AES_256_GCM_SHA384 = (ushort)171,
+        TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256 = (ushort)49254,
+        TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = (ushort)49260,
+        TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384 = (ushort)49255,
+        TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = (ushort)49261,
+        TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)49302,
+        TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49296,
+        TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = (ushort)49303,
+        TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49297,
+        TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = (ushort)52397,
+        TLS_DHE_PSK_WITH_NULL_SHA = (ushort)45,
+        TLS_DHE_PSK_WITH_NULL_SHA256 = (ushort)180,
+        TLS_DHE_PSK_WITH_NULL_SHA384 = (ushort)181,
+        TLS_DHE_PSK_WITH_RC4_128_SHA = (ushort)142,
+        TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = (ushort)20,
+        TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = (ushort)22,
+        TLS_DHE_RSA_WITH_AES_128_CBC_SHA = (ushort)51,
+        TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = (ushort)103,
+        TLS_DHE_RSA_WITH_AES_128_CCM = (ushort)49310,
+        TLS_DHE_RSA_WITH_AES_128_CCM_8 = (ushort)49314,
+        TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = (ushort)158,
+        TLS_DHE_RSA_WITH_AES_256_CBC_SHA = (ushort)57,
+        TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = (ushort)107,
+        TLS_DHE_RSA_WITH_AES_256_CCM = (ushort)49311,
+        TLS_DHE_RSA_WITH_AES_256_CCM_8 = (ushort)49315,
+        TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = (ushort)159,
+        TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256 = (ushort)49220,
+        TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = (ushort)49234,
+        TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384 = (ushort)49221,
+        TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = (ushort)49235,
+        TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = (ushort)69,
+        TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)190,
+        TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49276,
+        TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = (ushort)136,
+        TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = (ushort)196,
+        TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49277,
+        TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = (ushort)52394,
+        TLS_DHE_RSA_WITH_DES_CBC_SHA = (ushort)21,
+        TLS_DHE_RSA_WITH_SEED_CBC_SHA = (ushort)154,
+        TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA = (ushort)25,
+        TLS_DH_anon_EXPORT_WITH_RC4_40_MD5 = (ushort)23,
+        TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = (ushort)27,
+        TLS_DH_anon_WITH_AES_128_CBC_SHA = (ushort)52,
+        TLS_DH_anon_WITH_AES_128_CBC_SHA256 = (ushort)108,
+        TLS_DH_anon_WITH_AES_128_GCM_SHA256 = (ushort)166,
+        TLS_DH_anon_WITH_AES_256_CBC_SHA = (ushort)58,
+        TLS_DH_anon_WITH_AES_256_CBC_SHA256 = (ushort)109,
+        TLS_DH_anon_WITH_AES_256_GCM_SHA384 = (ushort)167,
+        TLS_DH_anon_WITH_ARIA_128_CBC_SHA256 = (ushort)49222,
+        TLS_DH_anon_WITH_ARIA_128_GCM_SHA256 = (ushort)49242,
+        TLS_DH_anon_WITH_ARIA_256_CBC_SHA384 = (ushort)49223,
+        TLS_DH_anon_WITH_ARIA_256_GCM_SHA384 = (ushort)49243,
+        TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA = (ushort)70,
+        TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)191,
+        TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49284,
+        TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA = (ushort)137,
+        TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256 = (ushort)197,
+        TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49285,
+        TLS_DH_anon_WITH_DES_CBC_SHA = (ushort)26,
+        TLS_DH_anon_WITH_RC4_128_MD5 = (ushort)24,
+        TLS_DH_anon_WITH_SEED_CBC_SHA = (ushort)155,
+        TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = (ushort)11,
+        TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = (ushort)13,
+        TLS_DH_DSS_WITH_AES_128_CBC_SHA = (ushort)48,
+        TLS_DH_DSS_WITH_AES_128_CBC_SHA256 = (ushort)62,
+        TLS_DH_DSS_WITH_AES_128_GCM_SHA256 = (ushort)164,
+        TLS_DH_DSS_WITH_AES_256_CBC_SHA = (ushort)54,
+        TLS_DH_DSS_WITH_AES_256_CBC_SHA256 = (ushort)104,
+        TLS_DH_DSS_WITH_AES_256_GCM_SHA384 = (ushort)165,
+        TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256 = (ushort)49214,
+        TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256 = (ushort)49240,
+        TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384 = (ushort)49215,
+        TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384 = (ushort)49241,
+        TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = (ushort)66,
+        TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)187,
+        TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49282,
+        TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = (ushort)133,
+        TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = (ushort)193,
+        TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49283,
+        TLS_DH_DSS_WITH_DES_CBC_SHA = (ushort)12,
+        TLS_DH_DSS_WITH_SEED_CBC_SHA = (ushort)151,
+        TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = (ushort)14,
+        TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = (ushort)16,
+        TLS_DH_RSA_WITH_AES_128_CBC_SHA = (ushort)49,
+        TLS_DH_RSA_WITH_AES_128_CBC_SHA256 = (ushort)63,
+        TLS_DH_RSA_WITH_AES_128_GCM_SHA256 = (ushort)160,
+        TLS_DH_RSA_WITH_AES_256_CBC_SHA = (ushort)55,
+        TLS_DH_RSA_WITH_AES_256_CBC_SHA256 = (ushort)105,
+        TLS_DH_RSA_WITH_AES_256_GCM_SHA384 = (ushort)161,
+        TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256 = (ushort)49216,
+        TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256 = (ushort)49236,
+        TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384 = (ushort)49217,
+        TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384 = (ushort)49237,
+        TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = (ushort)67,
+        TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)188,
+        TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49278,
+        TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = (ushort)134,
+        TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = (ushort)194,
+        TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49279,
+        TLS_DH_RSA_WITH_DES_CBC_SHA = (ushort)15,
+        TLS_DH_RSA_WITH_SEED_CBC_SHA = (ushort)152,
+        TLS_ECCPWD_WITH_AES_128_CCM_SHA256 = (ushort)49330,
+        TLS_ECCPWD_WITH_AES_128_GCM_SHA256 = (ushort)49328,
+        TLS_ECCPWD_WITH_AES_256_CCM_SHA384 = (ushort)49331,
+        TLS_ECCPWD_WITH_AES_256_GCM_SHA384 = (ushort)49329,
+        TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = (ushort)49160,
+        TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = (ushort)49161,
+        TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = (ushort)49187,
+        TLS_ECDHE_ECDSA_WITH_AES_128_CCM = (ushort)49324,
+        TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8 = (ushort)49326,
+        TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = (ushort)49195,
+        TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = (ushort)49162,
+        TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = (ushort)49188,
+        TLS_ECDHE_ECDSA_WITH_AES_256_CCM = (ushort)49325,
+        TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8 = (ushort)49327,
+        TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = (ushort)49196,
+        TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256 = (ushort)49224,
+        TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = (ushort)49244,
+        TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384 = (ushort)49225,
+        TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = (ushort)49245,
+        TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)49266,
+        TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49286,
+        TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = (ushort)49267,
+        TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49287,
+        TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = (ushort)52393,
+        TLS_ECDHE_ECDSA_WITH_NULL_SHA = (ushort)49158,
+        TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = (ushort)49159,
+        TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = (ushort)49204,
+        TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA = (ushort)49205,
+        TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = (ushort)49207,
+        TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256 = (ushort)53251,
+        TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256 = (ushort)53253,
+        TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256 = (ushort)53249,
+        TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA = (ushort)49206,
+        TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = (ushort)49208,
+        TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384 = (ushort)53250,
+        TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256 = (ushort)49264,
+        TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384 = (ushort)49265,
+        TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)49306,
+        TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = (ushort)49307,
+        TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = (ushort)52396,
+        TLS_ECDHE_PSK_WITH_NULL_SHA = (ushort)49209,
+        TLS_ECDHE_PSK_WITH_NULL_SHA256 = (ushort)49210,
+        TLS_ECDHE_PSK_WITH_NULL_SHA384 = (ushort)49211,
+        TLS_ECDHE_PSK_WITH_RC4_128_SHA = (ushort)49203,
+        TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = (ushort)49170,
+        TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = (ushort)49171,
+        TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = (ushort)49191,
+        TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = (ushort)49199,
+        TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = (ushort)49172,
+        TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = (ushort)49192,
+        TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = (ushort)49200,
+        TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256 = (ushort)49228,
+        TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = (ushort)49248,
+        TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384 = (ushort)49229,
+        TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = (ushort)49249,
+        TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)49270,
+        TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49290,
+        TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = (ushort)49271,
+        TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49291,
+        TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = (ushort)52392,
+        TLS_ECDHE_RSA_WITH_NULL_SHA = (ushort)49168,
+        TLS_ECDHE_RSA_WITH_RC4_128_SHA = (ushort)49169,
+        TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA = (ushort)49175,
+        TLS_ECDH_anon_WITH_AES_128_CBC_SHA = (ushort)49176,
+        TLS_ECDH_anon_WITH_AES_256_CBC_SHA = (ushort)49177,
+        TLS_ECDH_anon_WITH_NULL_SHA = (ushort)49173,
+        TLS_ECDH_anon_WITH_RC4_128_SHA = (ushort)49174,
+        TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = (ushort)49155,
+        TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = (ushort)49156,
+        TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = (ushort)49189,
+        TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = (ushort)49197,
+        TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = (ushort)49157,
+        TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = (ushort)49190,
+        TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = (ushort)49198,
+        TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256 = (ushort)49226,
+        TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = (ushort)49246,
+        TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384 = (ushort)49227,
+        TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = (ushort)49247,
+        TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)49268,
+        TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49288,
+        TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = (ushort)49269,
+        TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49289,
+        TLS_ECDH_ECDSA_WITH_NULL_SHA = (ushort)49153,
+        TLS_ECDH_ECDSA_WITH_RC4_128_SHA = (ushort)49154,
+        TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = (ushort)49165,
+        TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = (ushort)49166,
+        TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256 = (ushort)49193,
+        TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = (ushort)49201,
+        TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = (ushort)49167,
+        TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384 = (ushort)49194,
+        TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384 = (ushort)49202,
+        TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256 = (ushort)49230,
+        TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = (ushort)49250,
+        TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384 = (ushort)49231,
+        TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = (ushort)49251,
+        TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)49272,
+        TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49292,
+        TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = (ushort)49273,
+        TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49293,
+        TLS_ECDH_RSA_WITH_NULL_SHA = (ushort)49163,
+        TLS_ECDH_RSA_WITH_RC4_128_SHA = (ushort)49164,
+        TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5 = (ushort)41,
+        TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA = (ushort)38,
+        TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5 = (ushort)42,
+        TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA = (ushort)39,
+        TLS_KRB5_EXPORT_WITH_RC4_40_MD5 = (ushort)43,
+        TLS_KRB5_EXPORT_WITH_RC4_40_SHA = (ushort)40,
+        TLS_KRB5_WITH_3DES_EDE_CBC_MD5 = (ushort)35,
+        TLS_KRB5_WITH_3DES_EDE_CBC_SHA = (ushort)31,
+        TLS_KRB5_WITH_DES_CBC_MD5 = (ushort)34,
+        TLS_KRB5_WITH_DES_CBC_SHA = (ushort)30,
+        TLS_KRB5_WITH_IDEA_CBC_MD5 = (ushort)37,
+        TLS_KRB5_WITH_IDEA_CBC_SHA = (ushort)33,
+        TLS_KRB5_WITH_RC4_128_MD5 = (ushort)36,
+        TLS_KRB5_WITH_RC4_128_SHA = (ushort)32,
+        TLS_NULL_WITH_NULL_NULL = (ushort)0,
+        TLS_PSK_DHE_WITH_AES_128_CCM_8 = (ushort)49322,
+        TLS_PSK_DHE_WITH_AES_256_CCM_8 = (ushort)49323,
+        TLS_PSK_WITH_3DES_EDE_CBC_SHA = (ushort)139,
+        TLS_PSK_WITH_AES_128_CBC_SHA = (ushort)140,
+        TLS_PSK_WITH_AES_128_CBC_SHA256 = (ushort)174,
+        TLS_PSK_WITH_AES_128_CCM = (ushort)49316,
+        TLS_PSK_WITH_AES_128_CCM_8 = (ushort)49320,
+        TLS_PSK_WITH_AES_128_GCM_SHA256 = (ushort)168,
+        TLS_PSK_WITH_AES_256_CBC_SHA = (ushort)141,
+        TLS_PSK_WITH_AES_256_CBC_SHA384 = (ushort)175,
+        TLS_PSK_WITH_AES_256_CCM = (ushort)49317,
+        TLS_PSK_WITH_AES_256_CCM_8 = (ushort)49321,
+        TLS_PSK_WITH_AES_256_GCM_SHA384 = (ushort)169,
+        TLS_PSK_WITH_ARIA_128_CBC_SHA256 = (ushort)49252,
+        TLS_PSK_WITH_ARIA_128_GCM_SHA256 = (ushort)49258,
+        TLS_PSK_WITH_ARIA_256_CBC_SHA384 = (ushort)49253,
+        TLS_PSK_WITH_ARIA_256_GCM_SHA384 = (ushort)49259,
+        TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)49300,
+        TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49294,
+        TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384 = (ushort)49301,
+        TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49295,
+        TLS_PSK_WITH_CHACHA20_POLY1305_SHA256 = (ushort)52395,
+        TLS_PSK_WITH_NULL_SHA = (ushort)44,
+        TLS_PSK_WITH_NULL_SHA256 = (ushort)176,
+        TLS_PSK_WITH_NULL_SHA384 = (ushort)177,
+        TLS_PSK_WITH_RC4_128_SHA = (ushort)138,
+        TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = (ushort)8,
+        TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = (ushort)6,
+        TLS_RSA_EXPORT_WITH_RC4_40_MD5 = (ushort)3,
+        TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA = (ushort)147,
+        TLS_RSA_PSK_WITH_AES_128_CBC_SHA = (ushort)148,
+        TLS_RSA_PSK_WITH_AES_128_CBC_SHA256 = (ushort)182,
+        TLS_RSA_PSK_WITH_AES_128_GCM_SHA256 = (ushort)172,
+        TLS_RSA_PSK_WITH_AES_256_CBC_SHA = (ushort)149,
+        TLS_RSA_PSK_WITH_AES_256_CBC_SHA384 = (ushort)183,
+        TLS_RSA_PSK_WITH_AES_256_GCM_SHA384 = (ushort)173,
+        TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256 = (ushort)49256,
+        TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = (ushort)49262,
+        TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384 = (ushort)49257,
+        TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = (ushort)49263,
+        TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)49304,
+        TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49298,
+        TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = (ushort)49305,
+        TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49299,
+        TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256 = (ushort)52398,
+        TLS_RSA_PSK_WITH_NULL_SHA = (ushort)46,
+        TLS_RSA_PSK_WITH_NULL_SHA256 = (ushort)184,
+        TLS_RSA_PSK_WITH_NULL_SHA384 = (ushort)185,
+        TLS_RSA_PSK_WITH_RC4_128_SHA = (ushort)146,
+        TLS_RSA_WITH_3DES_EDE_CBC_SHA = (ushort)10,
+        TLS_RSA_WITH_AES_128_CBC_SHA = (ushort)47,
+        TLS_RSA_WITH_AES_128_CBC_SHA256 = (ushort)60,
+        TLS_RSA_WITH_AES_128_CCM = (ushort)49308,
+        TLS_RSA_WITH_AES_128_CCM_8 = (ushort)49312,
+        TLS_RSA_WITH_AES_128_GCM_SHA256 = (ushort)156,
+        TLS_RSA_WITH_AES_256_CBC_SHA = (ushort)53,
+        TLS_RSA_WITH_AES_256_CBC_SHA256 = (ushort)61,
+        TLS_RSA_WITH_AES_256_CCM = (ushort)49309,
+        TLS_RSA_WITH_AES_256_CCM_8 = (ushort)49313,
+        TLS_RSA_WITH_AES_256_GCM_SHA384 = (ushort)157,
+        TLS_RSA_WITH_ARIA_128_CBC_SHA256 = (ushort)49212,
+        TLS_RSA_WITH_ARIA_128_GCM_SHA256 = (ushort)49232,
+        TLS_RSA_WITH_ARIA_256_CBC_SHA384 = (ushort)49213,
+        TLS_RSA_WITH_ARIA_256_GCM_SHA384 = (ushort)49233,
+        TLS_RSA_WITH_CAMELLIA_128_CBC_SHA = (ushort)65,
+        TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256 = (ushort)186,
+        TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256 = (ushort)49274,
+        TLS_RSA_WITH_CAMELLIA_256_CBC_SHA = (ushort)132,
+        TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256 = (ushort)192,
+        TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384 = (ushort)49275,
+        TLS_RSA_WITH_DES_CBC_SHA = (ushort)9,
+        TLS_RSA_WITH_IDEA_CBC_SHA = (ushort)7,
+        TLS_RSA_WITH_NULL_MD5 = (ushort)1,
+        TLS_RSA_WITH_NULL_SHA = (ushort)2,
+        TLS_RSA_WITH_NULL_SHA256 = (ushort)59,
+        TLS_RSA_WITH_RC4_128_MD5 = (ushort)4,
+        TLS_RSA_WITH_RC4_128_SHA = (ushort)5,
+        TLS_RSA_WITH_SEED_CBC_SHA = (ushort)150,
+        TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = (ushort)49180,
+        TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = (ushort)49183,
+        TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = (ushort)49186,
+        TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = (ushort)49179,
+        TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = (ushort)49182,
+        TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = (ushort)49185,
+        TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA = (ushort)49178,
+        TLS_SRP_SHA_WITH_AES_128_CBC_SHA = (ushort)49181,
+        TLS_SRP_SHA_WITH_AES_256_CBC_SHA = (ushort)49184,
+    }
 }
```

