# System.Reflection.Metadata

``` diff
+namespace System.Reflection.Metadata {
+    public readonly struct ArrayShape {
+        public ArrayShape(int rank, ImmutableArray<int> sizes, ImmutableArray<int> lowerBounds);
+        public ImmutableArray<int> LowerBounds { get; }
+        public int Rank { get; }
+        public ImmutableArray<int> Sizes { get; }
+    }
+    public readonly struct AssemblyDefinition {
+        public StringHandle Culture { get; }
+        public AssemblyFlags Flags { get; }
+        public AssemblyHashAlgorithm HashAlgorithm { get; }
+        public StringHandle Name { get; }
+        public BlobHandle PublicKey { get; }
+        public Version Version { get; }
+        public AssemblyName GetAssemblyName();
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public DeclarativeSecurityAttributeHandleCollection GetDeclarativeSecurityAttributes();
+    }
+    public readonly struct AssemblyDefinitionHandle : IEquatable<AssemblyDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(AssemblyDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(AssemblyDefinitionHandle left, AssemblyDefinitionHandle right);
+        public static explicit operator AssemblyDefinitionHandle (EntityHandle handle);
+        public static explicit operator AssemblyDefinitionHandle (Handle handle);
+        public static implicit operator EntityHandle (AssemblyDefinitionHandle handle);
+        public static implicit operator Handle (AssemblyDefinitionHandle handle);
+        public static bool operator !=(AssemblyDefinitionHandle left, AssemblyDefinitionHandle right);
+    }
+    public static class AssemblyExtensions {
+        public unsafe static bool TryGetRawMetadata(this Assembly assembly, out byte* blob, out int length);
+    }
+    public readonly struct AssemblyFile {
+        public bool ContainsMetadata { get; }
+        public BlobHandle HashValue { get; }
+        public StringHandle Name { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct AssemblyFileHandle : IEquatable<AssemblyFileHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(AssemblyFileHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(AssemblyFileHandle left, AssemblyFileHandle right);
+        public static explicit operator AssemblyFileHandle (EntityHandle handle);
+        public static explicit operator AssemblyFileHandle (Handle handle);
+        public static implicit operator EntityHandle (AssemblyFileHandle handle);
+        public static implicit operator Handle (AssemblyFileHandle handle);
+        public static bool operator !=(AssemblyFileHandle left, AssemblyFileHandle right);
+    }
+    public readonly struct AssemblyFileHandleCollection : IEnumerable, IEnumerable<AssemblyFileHandle>, IReadOnlyCollection<AssemblyFileHandle> {
+        public int Count { get; }
+        public AssemblyFileHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<AssemblyFileHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.AssemblyFileHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<AssemblyFileHandle> {
+            public AssemblyFileHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct AssemblyReference {
+        public StringHandle Culture { get; }
+        public AssemblyFlags Flags { get; }
+        public BlobHandle HashValue { get; }
+        public StringHandle Name { get; }
+        public BlobHandle PublicKeyOrToken { get; }
+        public Version Version { get; }
+        public AssemblyName GetAssemblyName();
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct AssemblyReferenceHandle : IEquatable<AssemblyReferenceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(AssemblyReferenceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(AssemblyReferenceHandle left, AssemblyReferenceHandle right);
+        public static explicit operator AssemblyReferenceHandle (EntityHandle handle);
+        public static explicit operator AssemblyReferenceHandle (Handle handle);
+        public static implicit operator EntityHandle (AssemblyReferenceHandle handle);
+        public static implicit operator Handle (AssemblyReferenceHandle handle);
+        public static bool operator !=(AssemblyReferenceHandle left, AssemblyReferenceHandle right);
+    }
+    public readonly struct AssemblyReferenceHandleCollection : IEnumerable, IEnumerable<AssemblyReferenceHandle>, IReadOnlyCollection<AssemblyReferenceHandle> {
+        public int Count { get; }
+        public AssemblyReferenceHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<AssemblyReferenceHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.AssemblyReferenceHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<AssemblyReferenceHandle> {
+            public AssemblyReferenceHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct Blob {
+        public bool IsDefault { get; }
+        public int Length { get; }
+        public ArraySegment<byte> GetBytes();
+    }
+    public class BlobBuilder {
+        public BlobBuilder(int capacity = 256);
+        protected internal int ChunkCapacity { get; }
+        public int Count { get; }
+        protected int FreeBytes { get; }
+        public void Align(int alignment);
+        protected virtual BlobBuilder AllocateChunk(int minimalSize);
+        public void Clear();
+        public bool ContentEquals(BlobBuilder other);
+        protected void Free();
+        protected virtual void FreeChunk();
+        public BlobBuilder.Blobs GetBlobs();
+        public void LinkPrefix(BlobBuilder prefix);
+        public void LinkSuffix(BlobBuilder suffix);
+        public void PadTo(int position);
+        public Blob ReserveBytes(int byteCount);
+        public byte[] ToArray();
+        public byte[] ToArray(int start, int byteCount);
+        public ImmutableArray<byte> ToImmutableArray();
+        public ImmutableArray<byte> ToImmutableArray(int start, int byteCount);
+        public int TryWriteBytes(Stream source, int byteCount);
+        public void WriteBoolean(bool value);
+        public void WriteByte(byte value);
+        public unsafe void WriteBytes(byte* buffer, int byteCount);
+        public void WriteBytes(byte value, int byteCount);
+        public void WriteBytes(byte[] buffer);
+        public void WriteBytes(byte[] buffer, int start, int byteCount);
+        public void WriteBytes(ImmutableArray<byte> buffer);
+        public void WriteBytes(ImmutableArray<byte> buffer, int start, int byteCount);
+        public void WriteCompressedInteger(int value);
+        public void WriteCompressedSignedInteger(int value);
+        public void WriteConstant(object value);
+        public void WriteContentTo(Stream destination);
+        public void WriteContentTo(BlobBuilder destination);
+        public void WriteContentTo(ref BlobWriter destination);
+        public void WriteDateTime(DateTime value);
+        public void WriteDecimal(decimal value);
+        public void WriteDouble(double value);
+        public void WriteGuid(Guid value);
+        public void WriteInt16(short value);
+        public void WriteInt16BE(short value);
+        public void WriteInt32(int value);
+        public void WriteInt32BE(int value);
+        public void WriteInt64(long value);
+        public void WriteReference(int reference, bool isSmall);
+        public void WriteSByte(sbyte value);
+        public void WriteSerializedString(string value);
+        public void WriteSingle(float value);
+        public void WriteUInt16(ushort value);
+        public void WriteUInt16BE(ushort value);
+        public void WriteUInt32(uint value);
+        public void WriteUInt32BE(uint value);
+        public void WriteUInt64(ulong value);
+        public void WriteUserString(string value);
+        public void WriteUTF16(char[] value);
+        public void WriteUTF16(string value);
+        public void WriteUTF8(string value, bool allowUnpairedSurrogates = true);
+        public struct Blobs : IDisposable, IEnumerable, IEnumerable<Blob>, IEnumerator, IEnumerator<Blob> {
+            public Blob Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public BlobBuilder.Blobs GetEnumerator();
+            public bool MoveNext();
+            public void Reset();
+            IEnumerator<Blob> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.Blob>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct BlobContentId : IEquatable<BlobContentId> {
+        public BlobContentId(byte[] id);
+        public BlobContentId(ImmutableArray<byte> id);
+        public BlobContentId(Guid guid, uint stamp);
+        public Guid Guid { get; }
+        public bool IsDefault { get; }
+        public uint Stamp { get; }
+        public override bool Equals(object obj);
+        public bool Equals(BlobContentId other);
+        public static BlobContentId FromHash(byte[] hashCode);
+        public static BlobContentId FromHash(ImmutableArray<byte> hashCode);
+        public override int GetHashCode();
+        public static Func<IEnumerable<Blob>, BlobContentId> GetTimeBasedProvider();
+        public static bool operator ==(BlobContentId left, BlobContentId right);
+        public static bool operator !=(BlobContentId left, BlobContentId right);
+    }
+    public readonly struct BlobHandle : IEquatable<BlobHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(BlobHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(BlobHandle left, BlobHandle right);
+        public static explicit operator BlobHandle (Handle handle);
+        public static implicit operator Handle (BlobHandle handle);
+        public static bool operator !=(BlobHandle left, BlobHandle right);
+    }
+    public struct BlobReader {
+        public unsafe BlobReader(byte* buffer, int length);
+        public unsafe byte* CurrentPointer { get; }
+        public int Length { get; }
+        public int Offset { get; set; }
+        public int RemainingBytes { get; }
+        public unsafe byte* StartPointer { get; }
+        public void Align(byte alignment);
+        public int IndexOf(byte value);
+        public BlobHandle ReadBlobHandle();
+        public bool ReadBoolean();
+        public byte ReadByte();
+        public byte[] ReadBytes(int byteCount);
+        public void ReadBytes(int byteCount, byte[] buffer, int bufferOffset);
+        public char ReadChar();
+        public int ReadCompressedInteger();
+        public int ReadCompressedSignedInteger();
+        public object ReadConstant(ConstantTypeCode typeCode);
+        public DateTime ReadDateTime();
+        public decimal ReadDecimal();
+        public double ReadDouble();
+        public Guid ReadGuid();
+        public short ReadInt16();
+        public int ReadInt32();
+        public long ReadInt64();
+        public sbyte ReadSByte();
+        public SerializationTypeCode ReadSerializationTypeCode();
+        public string ReadSerializedString();
+        public SignatureHeader ReadSignatureHeader();
+        public SignatureTypeCode ReadSignatureTypeCode();
+        public float ReadSingle();
+        public EntityHandle ReadTypeHandle();
+        public ushort ReadUInt16();
+        public uint ReadUInt32();
+        public ulong ReadUInt64();
+        public string ReadUTF16(int byteCount);
+        public string ReadUTF8(int byteCount);
+        public void Reset();
+        public bool TryReadCompressedInteger(out int value);
+        public bool TryReadCompressedSignedInteger(out int value);
+    }
+    public struct BlobWriter {
+        public BlobWriter(byte[] buffer);
+        public BlobWriter(byte[] buffer, int start, int count);
+        public BlobWriter(int size);
+        public BlobWriter(Blob blob);
+        public Blob Blob { get; }
+        public int Length { get; }
+        public int Offset { get; set; }
+        public int RemainingBytes { get; }
+        public void Align(int alignment);
+        public void Clear();
+        public bool ContentEquals(BlobWriter other);
+        public void PadTo(int offset);
+        public byte[] ToArray();
+        public byte[] ToArray(int start, int byteCount);
+        public ImmutableArray<byte> ToImmutableArray();
+        public ImmutableArray<byte> ToImmutableArray(int start, int byteCount);
+        public void WriteBoolean(bool value);
+        public void WriteByte(byte value);
+        public unsafe void WriteBytes(byte* buffer, int byteCount);
+        public void WriteBytes(byte value, int byteCount);
+        public void WriteBytes(byte[] buffer);
+        public void WriteBytes(byte[] buffer, int start, int byteCount);
+        public void WriteBytes(ImmutableArray<byte> buffer);
+        public void WriteBytes(ImmutableArray<byte> buffer, int start, int byteCount);
+        public int WriteBytes(Stream source, int byteCount);
+        public void WriteBytes(BlobBuilder source);
+        public void WriteCompressedInteger(int value);
+        public void WriteCompressedSignedInteger(int value);
+        public void WriteConstant(object value);
+        public void WriteDateTime(DateTime value);
+        public void WriteDecimal(decimal value);
+        public void WriteDouble(double value);
+        public void WriteGuid(Guid value);
+        public void WriteInt16(short value);
+        public void WriteInt16BE(short value);
+        public void WriteInt32(int value);
+        public void WriteInt32BE(int value);
+        public void WriteInt64(long value);
+        public void WriteReference(int reference, bool isSmall);
+        public void WriteSByte(sbyte value);
+        public void WriteSerializedString(string str);
+        public void WriteSingle(float value);
+        public void WriteUInt16(ushort value);
+        public void WriteUInt16BE(ushort value);
+        public void WriteUInt32(uint value);
+        public void WriteUInt32BE(uint value);
+        public void WriteUInt64(ulong value);
+        public void WriteUserString(string value);
+        public void WriteUTF16(char[] value);
+        public void WriteUTF16(string value);
+        public void WriteUTF8(string value, bool allowUnpairedSurrogates);
+    }
+    public readonly struct Constant {
+        public EntityHandle Parent { get; }
+        public ConstantTypeCode TypeCode { get; }
+        public BlobHandle Value { get; }
+    }
+    public readonly struct ConstantHandle : IEquatable<ConstantHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ConstantHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ConstantHandle left, ConstantHandle right);
+        public static explicit operator ConstantHandle (EntityHandle handle);
+        public static explicit operator ConstantHandle (Handle handle);
+        public static implicit operator EntityHandle (ConstantHandle handle);
+        public static implicit operator Handle (ConstantHandle handle);
+        public static bool operator !=(ConstantHandle left, ConstantHandle right);
+    }
+    public enum ConstantTypeCode : byte {
+        Boolean = (byte)2,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        Invalid = (byte)0,
+        NullReference = (byte)18,
+        SByte = (byte)4,
+        Single = (byte)12,
+        String = (byte)14,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+    }
+    public readonly struct CustomAttribute {
+        public EntityHandle Constructor { get; }
+        public EntityHandle Parent { get; }
+        public BlobHandle Value { get; }
+        public CustomAttributeValue<TType> DecodeValue<TType>(ICustomAttributeTypeProvider<TType> provider);
+    }
+    public readonly struct CustomAttributeHandle : IEquatable<CustomAttributeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(CustomAttributeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(CustomAttributeHandle left, CustomAttributeHandle right);
+        public static explicit operator CustomAttributeHandle (EntityHandle handle);
+        public static explicit operator CustomAttributeHandle (Handle handle);
+        public static implicit operator EntityHandle (CustomAttributeHandle handle);
+        public static implicit operator Handle (CustomAttributeHandle handle);
+        public static bool operator !=(CustomAttributeHandle left, CustomAttributeHandle right);
+    }
+    public readonly struct CustomAttributeHandleCollection : IEnumerable, IEnumerable<CustomAttributeHandle>, IReadOnlyCollection<CustomAttributeHandle> {
+        public int Count { get; }
+        public CustomAttributeHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<CustomAttributeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.CustomAttributeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<CustomAttributeHandle> {
+            public CustomAttributeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct CustomAttributeNamedArgument<TType> {
+        public CustomAttributeNamedArgument(string name, CustomAttributeNamedArgumentKind kind, TType type, object value);
+        public CustomAttributeNamedArgumentKind Kind { get; }
+        public string Name { get; }
+        public TType Type { get; }
+        public object Value { get; }
+    }
+    public enum CustomAttributeNamedArgumentKind : byte {
+        Field = (byte)83,
+        Property = (byte)84,
+    }
+    public readonly struct CustomAttributeTypedArgument<TType> {
+        public CustomAttributeTypedArgument(TType type, object value);
+        public TType Type { get; }
+        public object Value { get; }
+    }
+    public readonly struct CustomAttributeValue<TType> {
+        public CustomAttributeValue(ImmutableArray<CustomAttributeTypedArgument<TType>> fixedArguments, ImmutableArray<CustomAttributeNamedArgument<TType>> namedArguments);
+        public ImmutableArray<CustomAttributeTypedArgument<TType>> FixedArguments { get; }
+        public ImmutableArray<CustomAttributeNamedArgument<TType>> NamedArguments { get; }
+    }
+    public readonly struct CustomDebugInformation {
+        public GuidHandle Kind { get; }
+        public EntityHandle Parent { get; }
+        public BlobHandle Value { get; }
+    }
+    public readonly struct CustomDebugInformationHandle : IEquatable<CustomDebugInformationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(CustomDebugInformationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(CustomDebugInformationHandle left, CustomDebugInformationHandle right);
+        public static explicit operator CustomDebugInformationHandle (EntityHandle handle);
+        public static explicit operator CustomDebugInformationHandle (Handle handle);
+        public static implicit operator EntityHandle (CustomDebugInformationHandle handle);
+        public static implicit operator Handle (CustomDebugInformationHandle handle);
+        public static bool operator !=(CustomDebugInformationHandle left, CustomDebugInformationHandle right);
+    }
+    public readonly struct CustomDebugInformationHandleCollection : IEnumerable, IEnumerable<CustomDebugInformationHandle>, IReadOnlyCollection<CustomDebugInformationHandle> {
+        public int Count { get; }
+        public CustomDebugInformationHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<CustomDebugInformationHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.CustomDebugInformationHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<CustomDebugInformationHandle> {
+            public CustomDebugInformationHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public sealed class DebugMetadataHeader {
+        public MethodDefinitionHandle EntryPoint { get; }
+        public ImmutableArray<byte> Id { get; }
+        public int IdStartOffset { get; }
+    }
+    public readonly struct DeclarativeSecurityAttribute {
+        public DeclarativeSecurityAction Action { get; }
+        public EntityHandle Parent { get; }
+        public BlobHandle PermissionSet { get; }
+    }
+    public readonly struct DeclarativeSecurityAttributeHandle : IEquatable<DeclarativeSecurityAttributeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(DeclarativeSecurityAttributeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(DeclarativeSecurityAttributeHandle left, DeclarativeSecurityAttributeHandle right);
+        public static explicit operator DeclarativeSecurityAttributeHandle (EntityHandle handle);
+        public static explicit operator DeclarativeSecurityAttributeHandle (Handle handle);
+        public static implicit operator EntityHandle (DeclarativeSecurityAttributeHandle handle);
+        public static implicit operator Handle (DeclarativeSecurityAttributeHandle handle);
+        public static bool operator !=(DeclarativeSecurityAttributeHandle left, DeclarativeSecurityAttributeHandle right);
+    }
+    public readonly struct DeclarativeSecurityAttributeHandleCollection : IEnumerable, IEnumerable<DeclarativeSecurityAttributeHandle>, IReadOnlyCollection<DeclarativeSecurityAttributeHandle> {
+        public int Count { get; }
+        public DeclarativeSecurityAttributeHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<DeclarativeSecurityAttributeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.DeclarativeSecurityAttributeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<DeclarativeSecurityAttributeHandle> {
+            public DeclarativeSecurityAttributeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct Document {
+        public BlobHandle Hash { get; }
+        public GuidHandle HashAlgorithm { get; }
+        public GuidHandle Language { get; }
+        public DocumentNameBlobHandle Name { get; }
+    }
+    public readonly struct DocumentHandle : IEquatable<DocumentHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(DocumentHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(DocumentHandle left, DocumentHandle right);
+        public static explicit operator DocumentHandle (EntityHandle handle);
+        public static explicit operator DocumentHandle (Handle handle);
+        public static implicit operator EntityHandle (DocumentHandle handle);
+        public static implicit operator Handle (DocumentHandle handle);
+        public static bool operator !=(DocumentHandle left, DocumentHandle right);
+    }
+    public readonly struct DocumentHandleCollection : IEnumerable, IEnumerable<DocumentHandle>, IReadOnlyCollection<DocumentHandle> {
+        public int Count { get; }
+        public DocumentHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<DocumentHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.DocumentHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<DocumentHandle> {
+            public DocumentHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct DocumentNameBlobHandle : IEquatable<DocumentNameBlobHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(DocumentNameBlobHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(DocumentNameBlobHandle left, DocumentNameBlobHandle right);
+        public static explicit operator DocumentNameBlobHandle (BlobHandle handle);
+        public static implicit operator BlobHandle (DocumentNameBlobHandle handle);
+        public static bool operator !=(DocumentNameBlobHandle left, DocumentNameBlobHandle right);
+    }
+    public readonly struct EntityHandle : IEquatable<EntityHandle> {
+        public static readonly AssemblyDefinitionHandle AssemblyDefinition;
+        public static readonly ModuleDefinitionHandle ModuleDefinition;
+        public bool IsNil { get; }
+        public HandleKind Kind { get; }
+        public override bool Equals(object obj);
+        public bool Equals(EntityHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(EntityHandle left, EntityHandle right);
+        public static explicit operator EntityHandle (Handle handle);
+        public static implicit operator Handle (EntityHandle handle);
+        public static bool operator !=(EntityHandle left, EntityHandle right);
+    }
+    public readonly struct EventAccessors {
+        public MethodDefinitionHandle Adder { get; }
+        public ImmutableArray<MethodDefinitionHandle> Others { get; }
+        public MethodDefinitionHandle Raiser { get; }
+        public MethodDefinitionHandle Remover { get; }
+    }
+    public readonly struct EventDefinition {
+        public EventAttributes Attributes { get; }
+        public StringHandle Name { get; }
+        public EntityHandle Type { get; }
+        public EventAccessors GetAccessors();
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct EventDefinitionHandle : IEquatable<EventDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(EventDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(EventDefinitionHandle left, EventDefinitionHandle right);
+        public static explicit operator EventDefinitionHandle (EntityHandle handle);
+        public static explicit operator EventDefinitionHandle (Handle handle);
+        public static implicit operator EntityHandle (EventDefinitionHandle handle);
+        public static implicit operator Handle (EventDefinitionHandle handle);
+        public static bool operator !=(EventDefinitionHandle left, EventDefinitionHandle right);
+    }
+    public readonly struct EventDefinitionHandleCollection : IEnumerable, IEnumerable<EventDefinitionHandle>, IReadOnlyCollection<EventDefinitionHandle> {
+        public int Count { get; }
+        public EventDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<EventDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.EventDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<EventDefinitionHandle> {
+            public EventDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct ExceptionRegion {
+        public EntityHandle CatchType { get; }
+        public int FilterOffset { get; }
+        public int HandlerLength { get; }
+        public int HandlerOffset { get; }
+        public ExceptionRegionKind Kind { get; }
+        public int TryLength { get; }
+        public int TryOffset { get; }
+    }
+    public enum ExceptionRegionKind : ushort {
+        Catch = (ushort)0,
+        Fault = (ushort)4,
+        Filter = (ushort)1,
+        Finally = (ushort)2,
+    }
+    public readonly struct ExportedType {
+        public TypeAttributes Attributes { get; }
+        public EntityHandle Implementation { get; }
+        public bool IsForwarder { get; }
+        public StringHandle Name { get; }
+        public StringHandle Namespace { get; }
+        public NamespaceDefinitionHandle NamespaceDefinition { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct ExportedTypeHandle : IEquatable<ExportedTypeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ExportedTypeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ExportedTypeHandle left, ExportedTypeHandle right);
+        public static explicit operator ExportedTypeHandle (EntityHandle handle);
+        public static explicit operator ExportedTypeHandle (Handle handle);
+        public static implicit operator EntityHandle (ExportedTypeHandle handle);
+        public static implicit operator Handle (ExportedTypeHandle handle);
+        public static bool operator !=(ExportedTypeHandle left, ExportedTypeHandle right);
+    }
+    public readonly struct ExportedTypeHandleCollection : IEnumerable, IEnumerable<ExportedTypeHandle>, IReadOnlyCollection<ExportedTypeHandle> {
+        public int Count { get; }
+        public ExportedTypeHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<ExportedTypeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ExportedTypeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ExportedTypeHandle> {
+            public ExportedTypeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct FieldDefinition {
+        public FieldAttributes Attributes { get; }
+        public StringHandle Name { get; }
+        public BlobHandle Signature { get; }
+        public TType DecodeSignature<TType, TGenericContext>(ISignatureTypeProvider<TType, TGenericContext> provider, TGenericContext genericContext);
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public TypeDefinitionHandle GetDeclaringType();
+        public ConstantHandle GetDefaultValue();
+        public BlobHandle GetMarshallingDescriptor();
+        public int GetOffset();
+        public int GetRelativeVirtualAddress();
+    }
+    public readonly struct FieldDefinitionHandle : IEquatable<FieldDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(FieldDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(FieldDefinitionHandle left, FieldDefinitionHandle right);
+        public static explicit operator FieldDefinitionHandle (EntityHandle handle);
+        public static explicit operator FieldDefinitionHandle (Handle handle);
+        public static implicit operator EntityHandle (FieldDefinitionHandle handle);
+        public static implicit operator Handle (FieldDefinitionHandle handle);
+        public static bool operator !=(FieldDefinitionHandle left, FieldDefinitionHandle right);
+    }
+    public readonly struct FieldDefinitionHandleCollection : IEnumerable, IEnumerable<FieldDefinitionHandle>, IReadOnlyCollection<FieldDefinitionHandle> {
+        public int Count { get; }
+        public FieldDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<FieldDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.FieldDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<FieldDefinitionHandle> {
+            public FieldDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct GenericParameter {
+        public GenericParameterAttributes Attributes { get; }
+        public int Index { get; }
+        public StringHandle Name { get; }
+        public EntityHandle Parent { get; }
+        public GenericParameterConstraintHandleCollection GetConstraints();
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct GenericParameterConstraint {
+        public GenericParameterHandle Parameter { get; }
+        public EntityHandle Type { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct GenericParameterConstraintHandle : IEquatable<GenericParameterConstraintHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(GenericParameterConstraintHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(GenericParameterConstraintHandle left, GenericParameterConstraintHandle right);
+        public static explicit operator GenericParameterConstraintHandle (EntityHandle handle);
+        public static explicit operator GenericParameterConstraintHandle (Handle handle);
+        public static implicit operator EntityHandle (GenericParameterConstraintHandle handle);
+        public static implicit operator Handle (GenericParameterConstraintHandle handle);
+        public static bool operator !=(GenericParameterConstraintHandle left, GenericParameterConstraintHandle right);
+    }
+    public readonly struct GenericParameterConstraintHandleCollection : IEnumerable, IEnumerable<GenericParameterConstraintHandle>, IReadOnlyCollection<GenericParameterConstraintHandle>, IReadOnlyList<GenericParameterConstraintHandle> {
+        public int Count { get; }
+        public GenericParameterConstraintHandle this[int index] { get; }
+        public GenericParameterConstraintHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<GenericParameterConstraintHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.GenericParameterConstraintHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<GenericParameterConstraintHandle> {
+            public GenericParameterConstraintHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct GenericParameterHandle : IEquatable<GenericParameterHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(GenericParameterHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(GenericParameterHandle left, GenericParameterHandle right);
+        public static explicit operator GenericParameterHandle (EntityHandle handle);
+        public static explicit operator GenericParameterHandle (Handle handle);
+        public static implicit operator EntityHandle (GenericParameterHandle handle);
+        public static implicit operator Handle (GenericParameterHandle handle);
+        public static bool operator !=(GenericParameterHandle left, GenericParameterHandle right);
+    }
+    public readonly struct GenericParameterHandleCollection : IEnumerable, IEnumerable<GenericParameterHandle>, IReadOnlyCollection<GenericParameterHandle>, IReadOnlyList<GenericParameterHandle> {
+        public int Count { get; }
+        public GenericParameterHandle this[int index] { get; }
+        public GenericParameterHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<GenericParameterHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.GenericParameterHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<GenericParameterHandle> {
+            public GenericParameterHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct GuidHandle : IEquatable<GuidHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(GuidHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(GuidHandle left, GuidHandle right);
+        public static explicit operator GuidHandle (Handle handle);
+        public static implicit operator Handle (GuidHandle handle);
+        public static bool operator !=(GuidHandle left, GuidHandle right);
+    }
+    public readonly struct Handle : IEquatable<Handle> {
+        public static readonly AssemblyDefinitionHandle AssemblyDefinition;
+        public static readonly ModuleDefinitionHandle ModuleDefinition;
+        public bool IsNil { get; }
+        public HandleKind Kind { get; }
+        public override bool Equals(object obj);
+        public bool Equals(Handle other);
+        public override int GetHashCode();
+        public static bool operator ==(Handle left, Handle right);
+        public static bool operator !=(Handle left, Handle right);
+    }
+    public sealed class HandleComparer : IComparer<EntityHandle>, IComparer<Handle>, IEqualityComparer<EntityHandle>, IEqualityComparer<Handle> {
+        public static HandleComparer Default { get; }
+        public int Compare(EntityHandle x, EntityHandle y);
+        public int Compare(Handle x, Handle y);
+        public bool Equals(EntityHandle x, EntityHandle y);
+        public bool Equals(Handle x, Handle y);
+        public int GetHashCode(EntityHandle obj);
+        public int GetHashCode(Handle obj);
+    }
+    public enum HandleKind : byte {
+        AssemblyDefinition = (byte)32,
+        AssemblyFile = (byte)38,
+        AssemblyReference = (byte)35,
+        Blob = (byte)113,
+        Constant = (byte)11,
+        CustomAttribute = (byte)12,
+        CustomDebugInformation = (byte)55,
+        DeclarativeSecurityAttribute = (byte)14,
+        Document = (byte)48,
+        EventDefinition = (byte)20,
+        ExportedType = (byte)39,
+        FieldDefinition = (byte)4,
+        GenericParameter = (byte)42,
+        GenericParameterConstraint = (byte)44,
+        Guid = (byte)114,
+        ImportScope = (byte)53,
+        InterfaceImplementation = (byte)9,
+        LocalConstant = (byte)52,
+        LocalScope = (byte)50,
+        LocalVariable = (byte)51,
+        ManifestResource = (byte)40,
+        MemberReference = (byte)10,
+        MethodDebugInformation = (byte)49,
+        MethodDefinition = (byte)6,
+        MethodImplementation = (byte)25,
+        MethodSpecification = (byte)43,
+        ModuleDefinition = (byte)0,
+        ModuleReference = (byte)26,
+        NamespaceDefinition = (byte)124,
+        Parameter = (byte)8,
+        PropertyDefinition = (byte)23,
+        StandaloneSignature = (byte)17,
+        String = (byte)120,
+        TypeDefinition = (byte)2,
+        TypeReference = (byte)1,
+        TypeSpecification = (byte)27,
+        UserString = (byte)112,
+    }
+    public interface IConstructedTypeProvider<TType> : ISZArrayTypeProvider<TType> {
+        TType GetArrayType(TType elementType, ArrayShape shape);
+        TType GetByReferenceType(TType elementType);
+        TType GetGenericInstantiation(TType genericType, ImmutableArray<TType> typeArguments);
+        TType GetPointerType(TType elementType);
+    }
+    public interface ICustomAttributeTypeProvider<TType> : ISimpleTypeProvider<TType>, ISZArrayTypeProvider<TType> {
+        TType GetSystemType();
+        TType GetTypeFromSerializedName(string name);
+        PrimitiveTypeCode GetUnderlyingEnumType(TType type);
+        bool IsSystemType(TType type);
+    }
+    public enum ILOpCode : ushort {
+        Add = (ushort)88,
+        Add_ovf = (ushort)214,
+        Add_ovf_un = (ushort)215,
+        And = (ushort)95,
+        Arglist = (ushort)65024,
+        Beq = (ushort)59,
+        Beq_s = (ushort)46,
+        Bge = (ushort)60,
+        Bge_s = (ushort)47,
+        Bge_un = (ushort)65,
+        Bge_un_s = (ushort)52,
+        Bgt = (ushort)61,
+        Bgt_s = (ushort)48,
+        Bgt_un = (ushort)66,
+        Bgt_un_s = (ushort)53,
+        Ble = (ushort)62,
+        Ble_s = (ushort)49,
+        Ble_un = (ushort)67,
+        Ble_un_s = (ushort)54,
+        Blt = (ushort)63,
+        Blt_s = (ushort)50,
+        Blt_un = (ushort)68,
+        Blt_un_s = (ushort)55,
+        Bne_un = (ushort)64,
+        Bne_un_s = (ushort)51,
+        Box = (ushort)140,
+        Br = (ushort)56,
+        Break = (ushort)1,
+        Brfalse = (ushort)57,
+        Brfalse_s = (ushort)44,
+        Brtrue = (ushort)58,
+        Brtrue_s = (ushort)45,
+        Br_s = (ushort)43,
+        Call = (ushort)40,
+        Calli = (ushort)41,
+        Callvirt = (ushort)111,
+        Castclass = (ushort)116,
+        Ceq = (ushort)65025,
+        Cgt = (ushort)65026,
+        Cgt_un = (ushort)65027,
+        Ckfinite = (ushort)195,
+        Clt = (ushort)65028,
+        Clt_un = (ushort)65029,
+        Constrained = (ushort)65046,
+        Conv_i = (ushort)211,
+        Conv_i1 = (ushort)103,
+        Conv_i2 = (ushort)104,
+        Conv_i4 = (ushort)105,
+        Conv_i8 = (ushort)106,
+        Conv_ovf_i = (ushort)212,
+        Conv_ovf_i1 = (ushort)179,
+        Conv_ovf_i1_un = (ushort)130,
+        Conv_ovf_i2 = (ushort)181,
+        Conv_ovf_i2_un = (ushort)131,
+        Conv_ovf_i4 = (ushort)183,
+        Conv_ovf_i4_un = (ushort)132,
+        Conv_ovf_i8 = (ushort)185,
+        Conv_ovf_i8_un = (ushort)133,
+        Conv_ovf_i_un = (ushort)138,
+        Conv_ovf_u = (ushort)213,
+        Conv_ovf_u1 = (ushort)180,
+        Conv_ovf_u1_un = (ushort)134,
+        Conv_ovf_u2 = (ushort)182,
+        Conv_ovf_u2_un = (ushort)135,
+        Conv_ovf_u4 = (ushort)184,
+        Conv_ovf_u4_un = (ushort)136,
+        Conv_ovf_u8 = (ushort)186,
+        Conv_ovf_u8_un = (ushort)137,
+        Conv_ovf_u_un = (ushort)139,
+        Conv_r4 = (ushort)107,
+        Conv_r8 = (ushort)108,
+        Conv_r_un = (ushort)118,
+        Conv_u = (ushort)224,
+        Conv_u1 = (ushort)210,
+        Conv_u2 = (ushort)209,
+        Conv_u4 = (ushort)109,
+        Conv_u8 = (ushort)110,
+        Cpblk = (ushort)65047,
+        Cpobj = (ushort)112,
+        Div = (ushort)91,
+        Div_un = (ushort)92,
+        Dup = (ushort)37,
+        Endfilter = (ushort)65041,
+        Endfinally = (ushort)220,
+        Initblk = (ushort)65048,
+        Initobj = (ushort)65045,
+        Isinst = (ushort)117,
+        Jmp = (ushort)39,
+        Ldarg = (ushort)65033,
+        Ldarga = (ushort)65034,
+        Ldarga_s = (ushort)15,
+        Ldarg_0 = (ushort)2,
+        Ldarg_1 = (ushort)3,
+        Ldarg_2 = (ushort)4,
+        Ldarg_3 = (ushort)5,
+        Ldarg_s = (ushort)14,
+        Ldc_i4 = (ushort)32,
+        Ldc_i4_0 = (ushort)22,
+        Ldc_i4_1 = (ushort)23,
+        Ldc_i4_2 = (ushort)24,
+        Ldc_i4_3 = (ushort)25,
+        Ldc_i4_4 = (ushort)26,
+        Ldc_i4_5 = (ushort)27,
+        Ldc_i4_6 = (ushort)28,
+        Ldc_i4_7 = (ushort)29,
+        Ldc_i4_8 = (ushort)30,
+        Ldc_i4_m1 = (ushort)21,
+        Ldc_i4_s = (ushort)31,
+        Ldc_i8 = (ushort)33,
+        Ldc_r4 = (ushort)34,
+        Ldc_r8 = (ushort)35,
+        Ldelem = (ushort)163,
+        Ldelema = (ushort)143,
+        Ldelem_i = (ushort)151,
+        Ldelem_i1 = (ushort)144,
+        Ldelem_i2 = (ushort)146,
+        Ldelem_i4 = (ushort)148,
+        Ldelem_i8 = (ushort)150,
+        Ldelem_r4 = (ushort)152,
+        Ldelem_r8 = (ushort)153,
+        Ldelem_ref = (ushort)154,
+        Ldelem_u1 = (ushort)145,
+        Ldelem_u2 = (ushort)147,
+        Ldelem_u4 = (ushort)149,
+        Ldfld = (ushort)123,
+        Ldflda = (ushort)124,
+        Ldftn = (ushort)65030,
+        Ldind_i = (ushort)77,
+        Ldind_i1 = (ushort)70,
+        Ldind_i2 = (ushort)72,
+        Ldind_i4 = (ushort)74,
+        Ldind_i8 = (ushort)76,
+        Ldind_r4 = (ushort)78,
+        Ldind_r8 = (ushort)79,
+        Ldind_ref = (ushort)80,
+        Ldind_u1 = (ushort)71,
+        Ldind_u2 = (ushort)73,
+        Ldind_u4 = (ushort)75,
+        Ldlen = (ushort)142,
+        Ldloc = (ushort)65036,
+        Ldloca = (ushort)65037,
+        Ldloca_s = (ushort)18,
+        Ldloc_0 = (ushort)6,
+        Ldloc_1 = (ushort)7,
+        Ldloc_2 = (ushort)8,
+        Ldloc_3 = (ushort)9,
+        Ldloc_s = (ushort)17,
+        Ldnull = (ushort)20,
+        Ldobj = (ushort)113,
+        Ldsfld = (ushort)126,
+        Ldsflda = (ushort)127,
+        Ldstr = (ushort)114,
+        Ldtoken = (ushort)208,
+        Ldvirtftn = (ushort)65031,
+        Leave = (ushort)221,
+        Leave_s = (ushort)222,
+        Localloc = (ushort)65039,
+        Mkrefany = (ushort)198,
+        Mul = (ushort)90,
+        Mul_ovf = (ushort)216,
+        Mul_ovf_un = (ushort)217,
+        Neg = (ushort)101,
+        Newarr = (ushort)141,
+        Newobj = (ushort)115,
+        Nop = (ushort)0,
+        Not = (ushort)102,
+        Or = (ushort)96,
+        Pop = (ushort)38,
+        Readonly = (ushort)65054,
+        Refanytype = (ushort)65053,
+        Refanyval = (ushort)194,
+        Rem = (ushort)93,
+        Rem_un = (ushort)94,
+        Ret = (ushort)42,
+        Rethrow = (ushort)65050,
+        Shl = (ushort)98,
+        Shr = (ushort)99,
+        Shr_un = (ushort)100,
+        Sizeof = (ushort)65052,
+        Starg = (ushort)65035,
+        Starg_s = (ushort)16,
+        Stelem = (ushort)164,
+        Stelem_i = (ushort)155,
+        Stelem_i1 = (ushort)156,
+        Stelem_i2 = (ushort)157,
+        Stelem_i4 = (ushort)158,
+        Stelem_i8 = (ushort)159,
+        Stelem_r4 = (ushort)160,
+        Stelem_r8 = (ushort)161,
+        Stelem_ref = (ushort)162,
+        Stfld = (ushort)125,
+        Stind_i = (ushort)223,
+        Stind_i1 = (ushort)82,
+        Stind_i2 = (ushort)83,
+        Stind_i4 = (ushort)84,
+        Stind_i8 = (ushort)85,
+        Stind_r4 = (ushort)86,
+        Stind_r8 = (ushort)87,
+        Stind_ref = (ushort)81,
+        Stloc = (ushort)65038,
+        Stloc_0 = (ushort)10,
+        Stloc_1 = (ushort)11,
+        Stloc_2 = (ushort)12,
+        Stloc_3 = (ushort)13,
+        Stloc_s = (ushort)19,
+        Stobj = (ushort)129,
+        Stsfld = (ushort)128,
+        Sub = (ushort)89,
+        Sub_ovf = (ushort)218,
+        Sub_ovf_un = (ushort)219,
+        Switch = (ushort)69,
+        Tail = (ushort)65044,
+        Throw = (ushort)122,
+        Unaligned = (ushort)65042,
+        Unbox = (ushort)121,
+        Unbox_any = (ushort)165,
+        Volatile = (ushort)65043,
+        Xor = (ushort)97,
+    }
+    public static class ILOpCodeExtensions {
+        public static int GetBranchOperandSize(this ILOpCode opCode);
+        public static ILOpCode GetLongBranch(this ILOpCode opCode);
+        public static ILOpCode GetShortBranch(this ILOpCode opCode);
+        public static bool IsBranch(this ILOpCode opCode);
+    }
+    public class ImageFormatLimitationException : Exception {
+        public ImageFormatLimitationException();
+        protected ImageFormatLimitationException(SerializationInfo info, StreamingContext context);
+        public ImageFormatLimitationException(string message);
+        public ImageFormatLimitationException(string message, Exception innerException);
+    }
+    public readonly struct ImportDefinition {
+        public BlobHandle Alias { get; }
+        public ImportDefinitionKind Kind { get; }
+        public AssemblyReferenceHandle TargetAssembly { get; }
+        public BlobHandle TargetNamespace { get; }
+        public EntityHandle TargetType { get; }
+    }
+    public readonly struct ImportDefinitionCollection : IEnumerable, IEnumerable<ImportDefinition> {
+        public ImportDefinitionCollection.Enumerator GetEnumerator();
+        IEnumerator<ImportDefinition> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ImportDefinition>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ImportDefinition> {
+            public ImportDefinition Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            public void Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public enum ImportDefinitionKind {
+        AliasAssemblyNamespace = 8,
+        AliasAssemblyReference = 6,
+        AliasNamespace = 7,
+        AliasType = 9,
+        ImportAssemblyNamespace = 2,
+        ImportAssemblyReferenceAlias = 5,
+        ImportNamespace = 1,
+        ImportType = 3,
+        ImportXmlNamespace = 4,
+    }
+    public readonly struct ImportScope {
+        public BlobHandle ImportsBlob { get; }
+        public ImportScopeHandle Parent { get; }
+        public ImportDefinitionCollection GetImports();
+    }
+    public readonly struct ImportScopeCollection : IEnumerable, IEnumerable<ImportScopeHandle>, IReadOnlyCollection<ImportScopeHandle> {
+        public int Count { get; }
+        public ImportScopeCollection.Enumerator GetEnumerator();
+        IEnumerator<ImportScopeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ImportScopeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ImportScopeHandle> {
+            public ImportScopeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct ImportScopeHandle : IEquatable<ImportScopeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ImportScopeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ImportScopeHandle left, ImportScopeHandle right);
+        public static explicit operator ImportScopeHandle (EntityHandle handle);
+        public static explicit operator ImportScopeHandle (Handle handle);
+        public static implicit operator EntityHandle (ImportScopeHandle handle);
+        public static implicit operator Handle (ImportScopeHandle handle);
+        public static bool operator !=(ImportScopeHandle left, ImportScopeHandle right);
+    }
+    public readonly struct InterfaceImplementation {
+        public EntityHandle Interface { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct InterfaceImplementationHandle : IEquatable<InterfaceImplementationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(InterfaceImplementationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(InterfaceImplementationHandle left, InterfaceImplementationHandle right);
+        public static explicit operator InterfaceImplementationHandle (EntityHandle handle);
+        public static explicit operator InterfaceImplementationHandle (Handle handle);
+        public static implicit operator EntityHandle (InterfaceImplementationHandle handle);
+        public static implicit operator Handle (InterfaceImplementationHandle handle);
+        public static bool operator !=(InterfaceImplementationHandle left, InterfaceImplementationHandle right);
+    }
+    public readonly struct InterfaceImplementationHandleCollection : IEnumerable, IEnumerable<InterfaceImplementationHandle>, IReadOnlyCollection<InterfaceImplementationHandle> {
+        public int Count { get; }
+        public InterfaceImplementationHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<InterfaceImplementationHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.InterfaceImplementationHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<InterfaceImplementationHandle> {
+            public InterfaceImplementationHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public interface ISignatureTypeProvider<TType, TGenericContext> : IConstructedTypeProvider<TType>, ISimpleTypeProvider<TType>, ISZArrayTypeProvider<TType> {
+        TType GetFunctionPointerType(MethodSignature<TType> signature);
+        TType GetGenericMethodParameter(TGenericContext genericContext, int index);
+        TType GetGenericTypeParameter(TGenericContext genericContext, int index);
+        TType GetModifiedType(TType modifier, TType unmodifiedType, bool isRequired);
+        TType GetPinnedType(TType elementType);
+        TType GetTypeFromSpecification(MetadataReader reader, TGenericContext genericContext, TypeSpecificationHandle handle, byte rawTypeKind);
+    }
+    public interface ISimpleTypeProvider<TType> {
+        TType GetPrimitiveType(PrimitiveTypeCode typeCode);
+        TType GetTypeFromDefinition(MetadataReader reader, TypeDefinitionHandle handle, byte rawTypeKind);
+        TType GetTypeFromReference(MetadataReader reader, TypeReferenceHandle handle, byte rawTypeKind);
+    }
+    public interface ISZArrayTypeProvider<TType> {
+        TType GetSZArrayType(TType elementType);
+    }
+    public readonly struct LocalConstant {
+        public StringHandle Name { get; }
+        public BlobHandle Signature { get; }
+    }
+    public readonly struct LocalConstantHandle : IEquatable<LocalConstantHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(LocalConstantHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(LocalConstantHandle left, LocalConstantHandle right);
+        public static explicit operator LocalConstantHandle (EntityHandle handle);
+        public static explicit operator LocalConstantHandle (Handle handle);
+        public static implicit operator EntityHandle (LocalConstantHandle handle);
+        public static implicit operator Handle (LocalConstantHandle handle);
+        public static bool operator !=(LocalConstantHandle left, LocalConstantHandle right);
+    }
+    public readonly struct LocalConstantHandleCollection : IEnumerable, IEnumerable<LocalConstantHandle>, IReadOnlyCollection<LocalConstantHandle> {
+        public int Count { get; }
+        public LocalConstantHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<LocalConstantHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.LocalConstantHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<LocalConstantHandle> {
+            public LocalConstantHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct LocalScope {
+        public int EndOffset { get; }
+        public ImportScopeHandle ImportScope { get; }
+        public int Length { get; }
+        public MethodDefinitionHandle Method { get; }
+        public int StartOffset { get; }
+        public LocalScopeHandleCollection.ChildrenEnumerator GetChildren();
+        public LocalConstantHandleCollection GetLocalConstants();
+        public LocalVariableHandleCollection GetLocalVariables();
+    }
+    public readonly struct LocalScopeHandle : IEquatable<LocalScopeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(LocalScopeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(LocalScopeHandle left, LocalScopeHandle right);
+        public static explicit operator LocalScopeHandle (EntityHandle handle);
+        public static explicit operator LocalScopeHandle (Handle handle);
+        public static implicit operator EntityHandle (LocalScopeHandle handle);
+        public static implicit operator Handle (LocalScopeHandle handle);
+        public static bool operator !=(LocalScopeHandle left, LocalScopeHandle right);
+    }
+    public readonly struct LocalScopeHandleCollection : IEnumerable, IEnumerable<LocalScopeHandle>, IReadOnlyCollection<LocalScopeHandle> {
+        public int Count { get; }
+        public LocalScopeHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<LocalScopeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.LocalScopeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct ChildrenEnumerator : IDisposable, IEnumerator, IEnumerator<LocalScopeHandle> {
+            public LocalScopeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<LocalScopeHandle> {
+            public LocalScopeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct LocalVariable {
+        public LocalVariableAttributes Attributes { get; }
+        public int Index { get; }
+        public StringHandle Name { get; }
+    }
+    public enum LocalVariableAttributes {
+        DebuggerHidden = 1,
+        None = 0,
+    }
+    public readonly struct LocalVariableHandle : IEquatable<LocalVariableHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(LocalVariableHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(LocalVariableHandle left, LocalVariableHandle right);
+        public static explicit operator LocalVariableHandle (EntityHandle handle);
+        public static explicit operator LocalVariableHandle (Handle handle);
+        public static implicit operator EntityHandle (LocalVariableHandle handle);
+        public static implicit operator Handle (LocalVariableHandle handle);
+        public static bool operator !=(LocalVariableHandle left, LocalVariableHandle right);
+    }
+    public readonly struct LocalVariableHandleCollection : IEnumerable, IEnumerable<LocalVariableHandle>, IReadOnlyCollection<LocalVariableHandle> {
+        public int Count { get; }
+        public LocalVariableHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<LocalVariableHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.LocalVariableHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<LocalVariableHandle> {
+            public LocalVariableHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct ManifestResource {
+        public ManifestResourceAttributes Attributes { get; }
+        public EntityHandle Implementation { get; }
+        public StringHandle Name { get; }
+        public long Offset { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct ManifestResourceHandle : IEquatable<ManifestResourceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ManifestResourceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ManifestResourceHandle left, ManifestResourceHandle right);
+        public static explicit operator ManifestResourceHandle (EntityHandle handle);
+        public static explicit operator ManifestResourceHandle (Handle handle);
+        public static implicit operator EntityHandle (ManifestResourceHandle handle);
+        public static implicit operator Handle (ManifestResourceHandle handle);
+        public static bool operator !=(ManifestResourceHandle left, ManifestResourceHandle right);
+    }
+    public readonly struct ManifestResourceHandleCollection : IEnumerable, IEnumerable<ManifestResourceHandle>, IReadOnlyCollection<ManifestResourceHandle> {
+        public int Count { get; }
+        public ManifestResourceHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<ManifestResourceHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ManifestResourceHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ManifestResourceHandle> {
+            public ManifestResourceHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct MemberReference {
+        public StringHandle Name { get; }
+        public EntityHandle Parent { get; }
+        public BlobHandle Signature { get; }
+        public TType DecodeFieldSignature<TType, TGenericContext>(ISignatureTypeProvider<TType, TGenericContext> provider, TGenericContext genericContext);
+        public MethodSignature<TType> DecodeMethodSignature<TType, TGenericContext>(ISignatureTypeProvider<TType, TGenericContext> provider, TGenericContext genericContext);
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public MemberReferenceKind GetKind();
+    }
+    public readonly struct MemberReferenceHandle : IEquatable<MemberReferenceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MemberReferenceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MemberReferenceHandle left, MemberReferenceHandle right);
+        public static explicit operator MemberReferenceHandle (EntityHandle handle);
+        public static explicit operator MemberReferenceHandle (Handle handle);
+        public static implicit operator EntityHandle (MemberReferenceHandle handle);
+        public static implicit operator Handle (MemberReferenceHandle handle);
+        public static bool operator !=(MemberReferenceHandle left, MemberReferenceHandle right);
+    }
+    public readonly struct MemberReferenceHandleCollection : IEnumerable, IEnumerable<MemberReferenceHandle>, IReadOnlyCollection<MemberReferenceHandle> {
+        public int Count { get; }
+        public MemberReferenceHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<MemberReferenceHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.MemberReferenceHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<MemberReferenceHandle> {
+            public MemberReferenceHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public enum MemberReferenceKind {
+        Field = 1,
+        Method = 0,
+    }
+    public enum MetadataKind {
+        Ecma335 = 0,
+        ManagedWindowsMetadata = 2,
+        WindowsMetadata = 1,
+    }
+    public sealed class MetadataReader {
+        public unsafe MetadataReader(byte* metadata, int length);
+        public unsafe MetadataReader(byte* metadata, int length, MetadataReaderOptions options);
+        public unsafe MetadataReader(byte* metadata, int length, MetadataReaderOptions options, MetadataStringDecoder utf8Decoder);
+        public AssemblyFileHandleCollection AssemblyFiles { get; }
+        public AssemblyReferenceHandleCollection AssemblyReferences { get; }
+        public CustomAttributeHandleCollection CustomAttributes { get; }
+        public CustomDebugInformationHandleCollection CustomDebugInformation { get; }
+        public DebugMetadataHeader DebugMetadataHeader { get; }
+        public DeclarativeSecurityAttributeHandleCollection DeclarativeSecurityAttributes { get; }
+        public DocumentHandleCollection Documents { get; }
+        public EventDefinitionHandleCollection EventDefinitions { get; }
+        public ExportedTypeHandleCollection ExportedTypes { get; }
+        public FieldDefinitionHandleCollection FieldDefinitions { get; }
+        public ImportScopeCollection ImportScopes { get; }
+        public bool IsAssembly { get; }
+        public LocalConstantHandleCollection LocalConstants { get; }
+        public LocalScopeHandleCollection LocalScopes { get; }
+        public LocalVariableHandleCollection LocalVariables { get; }
+        public ManifestResourceHandleCollection ManifestResources { get; }
+        public MemberReferenceHandleCollection MemberReferences { get; }
+        public MetadataKind MetadataKind { get; }
+        public int MetadataLength { get; }
+        public unsafe byte* MetadataPointer { get; }
+        public string MetadataVersion { get; }
+        public MethodDebugInformationHandleCollection MethodDebugInformation { get; }
+        public MethodDefinitionHandleCollection MethodDefinitions { get; }
+        public MetadataReaderOptions Options { get; }
+        public PropertyDefinitionHandleCollection PropertyDefinitions { get; }
+        public MetadataStringComparer StringComparer { get; }
+        public TypeDefinitionHandleCollection TypeDefinitions { get; }
+        public TypeReferenceHandleCollection TypeReferences { get; }
+        public MetadataStringDecoder UTF8Decoder { get; }
+        public AssemblyDefinition GetAssemblyDefinition();
+        public AssemblyFile GetAssemblyFile(AssemblyFileHandle handle);
+        public AssemblyReference GetAssemblyReference(AssemblyReferenceHandle handle);
+        public byte[] GetBlobBytes(BlobHandle handle);
+        public ImmutableArray<byte> GetBlobContent(BlobHandle handle);
+        public BlobReader GetBlobReader(BlobHandle handle);
+        public BlobReader GetBlobReader(StringHandle handle);
+        public Constant GetConstant(ConstantHandle handle);
+        public CustomAttribute GetCustomAttribute(CustomAttributeHandle handle);
+        public CustomAttributeHandleCollection GetCustomAttributes(EntityHandle handle);
+        public CustomDebugInformation GetCustomDebugInformation(CustomDebugInformationHandle handle);
+        public CustomDebugInformationHandleCollection GetCustomDebugInformation(EntityHandle handle);
+        public DeclarativeSecurityAttribute GetDeclarativeSecurityAttribute(DeclarativeSecurityAttributeHandle handle);
+        public Document GetDocument(DocumentHandle handle);
+        public EventDefinition GetEventDefinition(EventDefinitionHandle handle);
+        public ExportedType GetExportedType(ExportedTypeHandle handle);
+        public FieldDefinition GetFieldDefinition(FieldDefinitionHandle handle);
+        public GenericParameter GetGenericParameter(GenericParameterHandle handle);
+        public GenericParameterConstraint GetGenericParameterConstraint(GenericParameterConstraintHandle handle);
+        public Guid GetGuid(GuidHandle handle);
+        public ImportScope GetImportScope(ImportScopeHandle handle);
+        public InterfaceImplementation GetInterfaceImplementation(InterfaceImplementationHandle handle);
+        public LocalConstant GetLocalConstant(LocalConstantHandle handle);
+        public LocalScope GetLocalScope(LocalScopeHandle handle);
+        public LocalScopeHandleCollection GetLocalScopes(MethodDebugInformationHandle handle);
+        public LocalScopeHandleCollection GetLocalScopes(MethodDefinitionHandle handle);
+        public LocalVariable GetLocalVariable(LocalVariableHandle handle);
+        public ManifestResource GetManifestResource(ManifestResourceHandle handle);
+        public MemberReference GetMemberReference(MemberReferenceHandle handle);
+        public MethodDebugInformation GetMethodDebugInformation(MethodDebugInformationHandle handle);
+        public MethodDebugInformation GetMethodDebugInformation(MethodDefinitionHandle handle);
+        public MethodDefinition GetMethodDefinition(MethodDefinitionHandle handle);
+        public MethodImplementation GetMethodImplementation(MethodImplementationHandle handle);
+        public MethodSpecification GetMethodSpecification(MethodSpecificationHandle handle);
+        public ModuleDefinition GetModuleDefinition();
+        public ModuleReference GetModuleReference(ModuleReferenceHandle handle);
+        public NamespaceDefinition GetNamespaceDefinition(NamespaceDefinitionHandle handle);
+        public NamespaceDefinition GetNamespaceDefinitionRoot();
+        public Parameter GetParameter(ParameterHandle handle);
+        public PropertyDefinition GetPropertyDefinition(PropertyDefinitionHandle handle);
+        public StandaloneSignature GetStandaloneSignature(StandaloneSignatureHandle handle);
+        public string GetString(DocumentNameBlobHandle handle);
+        public string GetString(NamespaceDefinitionHandle handle);
+        public string GetString(StringHandle handle);
+        public TypeDefinition GetTypeDefinition(TypeDefinitionHandle handle);
+        public TypeReference GetTypeReference(TypeReferenceHandle handle);
+        public TypeSpecification GetTypeSpecification(TypeSpecificationHandle handle);
+        public string GetUserString(UserStringHandle handle);
+    }
+    public enum MetadataReaderOptions {
+        ApplyWindowsRuntimeProjections = 1,
+        Default = 1,
+        None = 0,
+    }
+    public sealed class MetadataReaderProvider : IDisposable {
+        public void Dispose();
+        public unsafe static MetadataReaderProvider FromMetadataImage(byte* start, int size);
+        public static MetadataReaderProvider FromMetadataImage(ImmutableArray<byte> image);
+        public static MetadataReaderProvider FromMetadataStream(Stream stream, MetadataStreamOptions options = MetadataStreamOptions.Default, int size = 0);
+        public unsafe static MetadataReaderProvider FromPortablePdbImage(byte* start, int size);
+        public static MetadataReaderProvider FromPortablePdbImage(ImmutableArray<byte> image);
+        public static MetadataReaderProvider FromPortablePdbStream(Stream stream, MetadataStreamOptions options = MetadataStreamOptions.Default, int size = 0);
+        public MetadataReader GetMetadataReader(MetadataReaderOptions options = MetadataReaderOptions.ApplyWindowsRuntimeProjections, MetadataStringDecoder utf8Decoder = null);
+    }
+    public enum MetadataStreamOptions {
+        Default = 0,
+        LeaveOpen = 1,
+        PrefetchMetadata = 2,
+    }
+    public readonly struct MetadataStringComparer {
+        public bool Equals(DocumentNameBlobHandle handle, string value);
+        public bool Equals(DocumentNameBlobHandle handle, string value, bool ignoreCase);
+        public bool Equals(NamespaceDefinitionHandle handle, string value);
+        public bool Equals(NamespaceDefinitionHandle handle, string value, bool ignoreCase);
+        public bool Equals(StringHandle handle, string value);
+        public bool Equals(StringHandle handle, string value, bool ignoreCase);
+        public bool StartsWith(StringHandle handle, string value);
+        public bool StartsWith(StringHandle handle, string value, bool ignoreCase);
+    }
+    public class MetadataStringDecoder {
+        public MetadataStringDecoder(Encoding encoding);
+        public static MetadataStringDecoder DefaultUTF8 { get; }
+        public Encoding Encoding { get; }
+        public unsafe virtual string GetString(byte* bytes, int byteCount);
+    }
+    public sealed class MethodBodyBlock {
+        public ImmutableArray<ExceptionRegion> ExceptionRegions { get; }
+        public StandaloneSignatureHandle LocalSignature { get; }
+        public bool LocalVariablesInitialized { get; }
+        public int MaxStack { get; }
+        public int Size { get; }
+        public static MethodBodyBlock Create(BlobReader reader);
+        public byte[] GetILBytes();
+        public ImmutableArray<byte> GetILContent();
+        public BlobReader GetILReader();
+    }
+    public readonly struct MethodDebugInformation {
+        public DocumentHandle Document { get; }
+        public StandaloneSignatureHandle LocalSignature { get; }
+        public BlobHandle SequencePointsBlob { get; }
+        public SequencePointCollection GetSequencePoints();
+        public MethodDefinitionHandle GetStateMachineKickoffMethod();
+    }
+    public readonly struct MethodDebugInformationHandle : IEquatable<MethodDebugInformationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MethodDebugInformationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MethodDebugInformationHandle left, MethodDebugInformationHandle right);
+        public static explicit operator MethodDebugInformationHandle (EntityHandle handle);
+        public static explicit operator MethodDebugInformationHandle (Handle handle);
+        public static implicit operator EntityHandle (MethodDebugInformationHandle handle);
+        public static implicit operator Handle (MethodDebugInformationHandle handle);
+        public static bool operator !=(MethodDebugInformationHandle left, MethodDebugInformationHandle right);
+        public MethodDefinitionHandle ToDefinitionHandle();
+    }
+    public readonly struct MethodDebugInformationHandleCollection : IEnumerable, IEnumerable<MethodDebugInformationHandle>, IReadOnlyCollection<MethodDebugInformationHandle> {
+        public int Count { get; }
+        public MethodDebugInformationHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<MethodDebugInformationHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.MethodDebugInformationHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<MethodDebugInformationHandle> {
+            public MethodDebugInformationHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct MethodDefinition {
+        public MethodAttributes Attributes { get; }
+        public MethodImplAttributes ImplAttributes { get; }
+        public StringHandle Name { get; }
+        public int RelativeVirtualAddress { get; }
+        public BlobHandle Signature { get; }
+        public MethodSignature<TType> DecodeSignature<TType, TGenericContext>(ISignatureTypeProvider<TType, TGenericContext> provider, TGenericContext genericContext);
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public DeclarativeSecurityAttributeHandleCollection GetDeclarativeSecurityAttributes();
+        public TypeDefinitionHandle GetDeclaringType();
+        public GenericParameterHandleCollection GetGenericParameters();
+        public MethodImport GetImport();
+        public ParameterHandleCollection GetParameters();
+    }
+    public readonly struct MethodDefinitionHandle : IEquatable<MethodDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MethodDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MethodDefinitionHandle left, MethodDefinitionHandle right);
+        public static explicit operator MethodDefinitionHandle (EntityHandle handle);
+        public static explicit operator MethodDefinitionHandle (Handle handle);
+        public static implicit operator EntityHandle (MethodDefinitionHandle handle);
+        public static implicit operator Handle (MethodDefinitionHandle handle);
+        public static bool operator !=(MethodDefinitionHandle left, MethodDefinitionHandle right);
+        public MethodDebugInformationHandle ToDebugInformationHandle();
+    }
+    public readonly struct MethodDefinitionHandleCollection : IEnumerable, IEnumerable<MethodDefinitionHandle>, IReadOnlyCollection<MethodDefinitionHandle> {
+        public int Count { get; }
+        public MethodDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<MethodDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.MethodDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<MethodDefinitionHandle> {
+            public MethodDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct MethodImplementation {
+        public EntityHandle MethodBody { get; }
+        public EntityHandle MethodDeclaration { get; }
+        public TypeDefinitionHandle Type { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct MethodImplementationHandle : IEquatable<MethodImplementationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MethodImplementationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MethodImplementationHandle left, MethodImplementationHandle right);
+        public static explicit operator MethodImplementationHandle (EntityHandle handle);
+        public static explicit operator MethodImplementationHandle (Handle handle);
+        public static implicit operator EntityHandle (MethodImplementationHandle handle);
+        public static implicit operator Handle (MethodImplementationHandle handle);
+        public static bool operator !=(MethodImplementationHandle left, MethodImplementationHandle right);
+    }
+    public readonly struct MethodImplementationHandleCollection : IEnumerable, IEnumerable<MethodImplementationHandle>, IReadOnlyCollection<MethodImplementationHandle> {
+        public int Count { get; }
+        public MethodImplementationHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<MethodImplementationHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.MethodImplementationHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<MethodImplementationHandle> {
+            public MethodImplementationHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct MethodImport {
+        public MethodImportAttributes Attributes { get; }
+        public ModuleReferenceHandle Module { get; }
+        public StringHandle Name { get; }
+    }
+    public readonly struct MethodSignature<TType> {
+        public MethodSignature(SignatureHeader header, TType returnType, int requiredParameterCount, int genericParameterCount, ImmutableArray<TType> parameterTypes);
+        public int GenericParameterCount { get; }
+        public SignatureHeader Header { get; }
+        public ImmutableArray<TType> ParameterTypes { get; }
+        public int RequiredParameterCount { get; }
+        public TType ReturnType { get; }
+    }
+    public readonly struct MethodSpecification {
+        public EntityHandle Method { get; }
+        public BlobHandle Signature { get; }
+        public ImmutableArray<TType> DecodeSignature<TType, TGenericContext>(ISignatureTypeProvider<TType, TGenericContext> provider, TGenericContext genericContext);
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct MethodSpecificationHandle : IEquatable<MethodSpecificationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MethodSpecificationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MethodSpecificationHandle left, MethodSpecificationHandle right);
+        public static explicit operator MethodSpecificationHandle (EntityHandle handle);
+        public static explicit operator MethodSpecificationHandle (Handle handle);
+        public static implicit operator EntityHandle (MethodSpecificationHandle handle);
+        public static implicit operator Handle (MethodSpecificationHandle handle);
+        public static bool operator !=(MethodSpecificationHandle left, MethodSpecificationHandle right);
+    }
+    public readonly struct ModuleDefinition {
+        public GuidHandle BaseGenerationId { get; }
+        public int Generation { get; }
+        public GuidHandle GenerationId { get; }
+        public GuidHandle Mvid { get; }
+        public StringHandle Name { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct ModuleDefinitionHandle : IEquatable<ModuleDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ModuleDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ModuleDefinitionHandle left, ModuleDefinitionHandle right);
+        public static explicit operator ModuleDefinitionHandle (EntityHandle handle);
+        public static explicit operator ModuleDefinitionHandle (Handle handle);
+        public static implicit operator EntityHandle (ModuleDefinitionHandle handle);
+        public static implicit operator Handle (ModuleDefinitionHandle handle);
+        public static bool operator !=(ModuleDefinitionHandle left, ModuleDefinitionHandle right);
+    }
+    public readonly struct ModuleReference {
+        public StringHandle Name { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct ModuleReferenceHandle : IEquatable<ModuleReferenceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ModuleReferenceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ModuleReferenceHandle left, ModuleReferenceHandle right);
+        public static explicit operator ModuleReferenceHandle (EntityHandle handle);
+        public static explicit operator ModuleReferenceHandle (Handle handle);
+        public static implicit operator EntityHandle (ModuleReferenceHandle handle);
+        public static implicit operator Handle (ModuleReferenceHandle handle);
+        public static bool operator !=(ModuleReferenceHandle left, ModuleReferenceHandle right);
+    }
+    public struct NamespaceDefinition {
+        public ImmutableArray<ExportedTypeHandle> ExportedTypes { get; }
+        public StringHandle Name { get; }
+        public ImmutableArray<NamespaceDefinitionHandle> NamespaceDefinitions { get; }
+        public NamespaceDefinitionHandle Parent { get; }
+        public ImmutableArray<TypeDefinitionHandle> TypeDefinitions { get; }
+    }
+    public readonly struct NamespaceDefinitionHandle : IEquatable<NamespaceDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(NamespaceDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(NamespaceDefinitionHandle left, NamespaceDefinitionHandle right);
+        public static explicit operator NamespaceDefinitionHandle (Handle handle);
+        public static implicit operator Handle (NamespaceDefinitionHandle handle);
+        public static bool operator !=(NamespaceDefinitionHandle left, NamespaceDefinitionHandle right);
+    }
+    public readonly struct Parameter {
+        public ParameterAttributes Attributes { get; }
+        public StringHandle Name { get; }
+        public int SequenceNumber { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public ConstantHandle GetDefaultValue();
+        public BlobHandle GetMarshallingDescriptor();
+    }
+    public readonly struct ParameterHandle : IEquatable<ParameterHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ParameterHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ParameterHandle left, ParameterHandle right);
+        public static explicit operator ParameterHandle (EntityHandle handle);
+        public static explicit operator ParameterHandle (Handle handle);
+        public static implicit operator EntityHandle (ParameterHandle handle);
+        public static implicit operator Handle (ParameterHandle handle);
+        public static bool operator !=(ParameterHandle left, ParameterHandle right);
+    }
+    public readonly struct ParameterHandleCollection : IEnumerable, IEnumerable<ParameterHandle>, IReadOnlyCollection<ParameterHandle> {
+        public int Count { get; }
+        public ParameterHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<ParameterHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ParameterHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ParameterHandle> {
+            public ParameterHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public static class PEReaderExtensions {
+        public static MetadataReader GetMetadataReader(this PEReader peReader);
+        public static MetadataReader GetMetadataReader(this PEReader peReader, MetadataReaderOptions options);
+        public static MetadataReader GetMetadataReader(this PEReader peReader, MetadataReaderOptions options, MetadataStringDecoder utf8Decoder);
+        public static MethodBodyBlock GetMethodBody(this PEReader peReader, int relativeVirtualAddress);
+    }
+    public enum PrimitiveSerializationTypeCode : byte {
+        Boolean = (byte)2,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        SByte = (byte)4,
+        Single = (byte)12,
+        String = (byte)14,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+    }
+    public enum PrimitiveTypeCode : byte {
+        Boolean = (byte)2,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        IntPtr = (byte)24,
+        Object = (byte)28,
+        SByte = (byte)4,
+        Single = (byte)12,
+        String = (byte)14,
+        TypedReference = (byte)22,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+        UIntPtr = (byte)25,
+        Void = (byte)1,
+    }
+    public readonly struct PropertyAccessors {
+        public MethodDefinitionHandle Getter { get; }
+        public ImmutableArray<MethodDefinitionHandle> Others { get; }
+        public MethodDefinitionHandle Setter { get; }
+    }
+    public readonly struct PropertyDefinition {
+        public PropertyAttributes Attributes { get; }
+        public StringHandle Name { get; }
+        public BlobHandle Signature { get; }
+        public MethodSignature<TType> DecodeSignature<TType, TGenericContext>(ISignatureTypeProvider<TType, TGenericContext> provider, TGenericContext genericContext);
+        public PropertyAccessors GetAccessors();
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public ConstantHandle GetDefaultValue();
+    }
+    public readonly struct PropertyDefinitionHandle : IEquatable<PropertyDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(PropertyDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(PropertyDefinitionHandle left, PropertyDefinitionHandle right);
+        public static explicit operator PropertyDefinitionHandle (EntityHandle handle);
+        public static explicit operator PropertyDefinitionHandle (Handle handle);
+        public static implicit operator EntityHandle (PropertyDefinitionHandle handle);
+        public static implicit operator Handle (PropertyDefinitionHandle handle);
+        public static bool operator !=(PropertyDefinitionHandle left, PropertyDefinitionHandle right);
+    }
+    public readonly struct PropertyDefinitionHandleCollection : IEnumerable, IEnumerable<PropertyDefinitionHandle>, IReadOnlyCollection<PropertyDefinitionHandle> {
+        public int Count { get; }
+        public PropertyDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<PropertyDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.PropertyDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<PropertyDefinitionHandle> {
+            public PropertyDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct ReservedBlob<THandle> where THandle : struct {
+        public Blob Content { get; }
+        public THandle Handle { get; }
+        public BlobWriter CreateWriter();
+    }
+    public readonly struct SequencePoint : IEquatable<SequencePoint> {
+        public const int HiddenLine = 16707566;
+        public DocumentHandle Document { get; }
+        public int EndColumn { get; }
+        public int EndLine { get; }
+        public bool IsHidden { get; }
+        public int Offset { get; }
+        public int StartColumn { get; }
+        public int StartLine { get; }
+        public override bool Equals(object obj);
+        public bool Equals(SequencePoint other);
+        public override int GetHashCode();
+    }
+    public readonly struct SequencePointCollection : IEnumerable, IEnumerable<SequencePoint> {
+        public SequencePointCollection.Enumerator GetEnumerator();
+        IEnumerator<SequencePoint> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.SequencePoint>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<SequencePoint> {
+            public SequencePoint Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            public void Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public enum SerializationTypeCode : byte {
+        Boolean = (byte)2,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        Enum = (byte)85,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        Invalid = (byte)0,
+        SByte = (byte)4,
+        Single = (byte)12,
+        String = (byte)14,
+        SZArray = (byte)29,
+        TaggedObject = (byte)81,
+        Type = (byte)80,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+    }
+    public enum SignatureAttributes : byte {
+        ExplicitThis = (byte)64,
+        Generic = (byte)16,
+        Instance = (byte)32,
+        None = (byte)0,
+    }
+    public enum SignatureCallingConvention : byte {
+        CDecl = (byte)1,
+        Default = (byte)0,
+        FastCall = (byte)4,
+        StdCall = (byte)2,
+        ThisCall = (byte)3,
+        Unmanaged = (byte)9,
+        VarArgs = (byte)5,
+    }
+    public struct SignatureHeader : IEquatable<SignatureHeader> {
+        public const byte CallingConventionOrKindMask = (byte)15;
+        public SignatureHeader(byte rawValue);
+        public SignatureHeader(SignatureKind kind, SignatureCallingConvention convention, SignatureAttributes attributes);
+        public SignatureAttributes Attributes { get; }
+        public SignatureCallingConvention CallingConvention { get; }
+        public bool HasExplicitThis { get; }
+        public bool IsGeneric { get; }
+        public bool IsInstance { get; }
+        public SignatureKind Kind { get; }
+        public byte RawValue { get; }
+        public override bool Equals(object obj);
+        public bool Equals(SignatureHeader other);
+        public override int GetHashCode();
+        public static bool operator ==(SignatureHeader left, SignatureHeader right);
+        public static bool operator !=(SignatureHeader left, SignatureHeader right);
+        public override string ToString();
+    }
+    public enum SignatureKind : byte {
+        Field = (byte)6,
+        LocalVariables = (byte)7,
+        Method = (byte)0,
+        MethodSpecification = (byte)10,
+        Property = (byte)8,
+    }
+    public enum SignatureTypeCode : byte {
+        Array = (byte)20,
+        Boolean = (byte)2,
+        ByReference = (byte)16,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        FunctionPointer = (byte)27,
+        GenericMethodParameter = (byte)30,
+        GenericTypeInstance = (byte)21,
+        GenericTypeParameter = (byte)19,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        IntPtr = (byte)24,
+        Invalid = (byte)0,
+        Object = (byte)28,
+        OptionalModifier = (byte)32,
+        Pinned = (byte)69,
+        Pointer = (byte)15,
+        RequiredModifier = (byte)31,
+        SByte = (byte)4,
+        Sentinel = (byte)65,
+        Single = (byte)12,
+        String = (byte)14,
+        SZArray = (byte)29,
+        TypedReference = (byte)22,
+        TypeHandle = (byte)64,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+        UIntPtr = (byte)25,
+        Void = (byte)1,
+    }
+    public enum SignatureTypeKind : byte {
+        Class = (byte)18,
+        Unknown = (byte)0,
+        ValueType = (byte)17,
+    }
+    public readonly struct StandaloneSignature {
+        public BlobHandle Signature { get; }
+        public ImmutableArray<TType> DecodeLocalSignature<TType, TGenericContext>(ISignatureTypeProvider<TType, TGenericContext> provider, TGenericContext genericContext);
+        public MethodSignature<TType> DecodeMethodSignature<TType, TGenericContext>(ISignatureTypeProvider<TType, TGenericContext> provider, TGenericContext genericContext);
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public StandaloneSignatureKind GetKind();
+    }
+    public readonly struct StandaloneSignatureHandle : IEquatable<StandaloneSignatureHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(StandaloneSignatureHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(StandaloneSignatureHandle left, StandaloneSignatureHandle right);
+        public static explicit operator StandaloneSignatureHandle (EntityHandle handle);
+        public static explicit operator StandaloneSignatureHandle (Handle handle);
+        public static implicit operator EntityHandle (StandaloneSignatureHandle handle);
+        public static implicit operator Handle (StandaloneSignatureHandle handle);
+        public static bool operator !=(StandaloneSignatureHandle left, StandaloneSignatureHandle right);
+    }
+    public enum StandaloneSignatureKind {
+        LocalVariables = 1,
+        Method = 0,
+    }
+    public readonly struct StringHandle : IEquatable<StringHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(StringHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(StringHandle left, StringHandle right);
+        public static explicit operator StringHandle (Handle handle);
+        public static implicit operator Handle (StringHandle handle);
+        public static bool operator !=(StringHandle left, StringHandle right);
+    }
+    public readonly struct TypeDefinition {
+        public TypeAttributes Attributes { get; }
+        public EntityHandle BaseType { get; }
+        public bool IsNested { get; }
+        public StringHandle Name { get; }
+        public StringHandle Namespace { get; }
+        public NamespaceDefinitionHandle NamespaceDefinition { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public DeclarativeSecurityAttributeHandleCollection GetDeclarativeSecurityAttributes();
+        public TypeDefinitionHandle GetDeclaringType();
+        public EventDefinitionHandleCollection GetEvents();
+        public FieldDefinitionHandleCollection GetFields();
+        public GenericParameterHandleCollection GetGenericParameters();
+        public InterfaceImplementationHandleCollection GetInterfaceImplementations();
+        public TypeLayout GetLayout();
+        public MethodImplementationHandleCollection GetMethodImplementations();
+        public MethodDefinitionHandleCollection GetMethods();
+        public ImmutableArray<TypeDefinitionHandle> GetNestedTypes();
+        public PropertyDefinitionHandleCollection GetProperties();
+    }
+    public readonly struct TypeDefinitionHandle : IEquatable<TypeDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(TypeDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(TypeDefinitionHandle left, TypeDefinitionHandle right);
+        public static explicit operator TypeDefinitionHandle (EntityHandle handle);
+        public static explicit operator TypeDefinitionHandle (Handle handle);
+        public static implicit operator EntityHandle (TypeDefinitionHandle handle);
+        public static implicit operator Handle (TypeDefinitionHandle handle);
+        public static bool operator !=(TypeDefinitionHandle left, TypeDefinitionHandle right);
+    }
+    public readonly struct TypeDefinitionHandleCollection : IEnumerable, IEnumerable<TypeDefinitionHandle>, IReadOnlyCollection<TypeDefinitionHandle> {
+        public int Count { get; }
+        public TypeDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<TypeDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.TypeDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TypeDefinitionHandle> {
+            public TypeDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct TypeLayout {
+        public TypeLayout(int size, int packingSize);
+        public bool IsDefault { get; }
+        public int PackingSize { get; }
+        public int Size { get; }
+    }
+    public readonly struct TypeReference {
+        public StringHandle Name { get; }
+        public StringHandle Namespace { get; }
+        public EntityHandle ResolutionScope { get; }
+    }
+    public readonly struct TypeReferenceHandle : IEquatable<TypeReferenceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(TypeReferenceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(TypeReferenceHandle left, TypeReferenceHandle right);
+        public static explicit operator TypeReferenceHandle (EntityHandle handle);
+        public static explicit operator TypeReferenceHandle (Handle handle);
+        public static implicit operator EntityHandle (TypeReferenceHandle handle);
+        public static implicit operator Handle (TypeReferenceHandle handle);
+        public static bool operator !=(TypeReferenceHandle left, TypeReferenceHandle right);
+    }
+    public readonly struct TypeReferenceHandleCollection : IEnumerable, IEnumerable<TypeReferenceHandle>, IReadOnlyCollection<TypeReferenceHandle> {
+        public int Count { get; }
+        public TypeReferenceHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<TypeReferenceHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.TypeReferenceHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TypeReferenceHandle> {
+            public TypeReferenceHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public readonly struct TypeSpecification {
+        public BlobHandle Signature { get; }
+        public TType DecodeSignature<TType, TGenericContext>(ISignatureTypeProvider<TType, TGenericContext> provider, TGenericContext genericContext);
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    public readonly struct TypeSpecificationHandle : IEquatable<TypeSpecificationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(TypeSpecificationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(TypeSpecificationHandle left, TypeSpecificationHandle right);
+        public static explicit operator TypeSpecificationHandle (EntityHandle handle);
+        public static explicit operator TypeSpecificationHandle (Handle handle);
+        public static implicit operator EntityHandle (TypeSpecificationHandle handle);
+        public static implicit operator Handle (TypeSpecificationHandle handle);
+        public static bool operator !=(TypeSpecificationHandle left, TypeSpecificationHandle right);
+    }
+    public readonly struct UserStringHandle : IEquatable<UserStringHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(UserStringHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(UserStringHandle left, UserStringHandle right);
+        public static explicit operator UserStringHandle (Handle handle);
+        public static implicit operator Handle (UserStringHandle handle);
+        public static bool operator !=(UserStringHandle left, UserStringHandle right);
+    }
+}
```

