# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public sealed class AesManaged : Aes {
-        public override ICryptoTransform CreateDecryptor(byte[] key, byte[] iv);
+        public override ICryptoTransform CreateDecryptor(byte[] rgbKey, byte[] rgbIV);
-        public override ICryptoTransform CreateEncryptor(byte[] key, byte[] iv);
+        public override ICryptoTransform CreateEncryptor(byte[] rgbKey, byte[] rgbIV);
     }
     public class AsnEncodedData {
+        public AsnEncodedData(ReadOnlySpan<byte> rawData);
+        public AsnEncodedData(Oid oid, ReadOnlySpan<byte> rawData);
+        public AsnEncodedData(string oid, ReadOnlySpan<byte> rawData);
     }
     public abstract class AsymmetricAlgorithm : IDisposable {
+        public virtual void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);
+        public virtual void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);
+        public virtual void ImportFromPem(ReadOnlySpan<char> input);
     }
     public class CryptoStream : Stream, IDisposable {
+        public ValueTask FlushFinalBlockAsync(CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class DSA : AsymmetricAlgorithm {
+        public byte[] CreateSignature(byte[] rgbHash, DSASignatureFormat signatureFormat);
+        protected virtual byte[] CreateSignatureCore(ReadOnlySpan<byte> hash, DSASignatureFormat signatureFormat);
+        public int GetMaxSignatureSize(DSASignatureFormat signatureFormat);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);
+        public override void ImportFromPem(ReadOnlySpan<char> input);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public byte[] SignData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public byte[] SignData(byte[] data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public byte[] SignData(Stream data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        protected virtual byte[] SignDataCore(Stream data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        protected virtual byte[] SignDataCore(ReadOnlySpan<byte> data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public bool TryCreateSignature(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat, out int bytesWritten);
+        protected virtual bool TryCreateSignatureCore(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
+        public bool TrySignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat, out int bytesWritten);
+        protected virtual bool TrySignDataCore(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat, out int bytesWritten);
+        public bool VerifyData(byte[] data, byte[] signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public bool VerifyData(byte[] data, int offset, int count, byte[] signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public bool VerifyData(Stream data, byte[] signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public bool VerifyData(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        protected virtual bool VerifyDataCore(Stream data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        protected virtual bool VerifyDataCore(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public bool VerifySignature(byte[] rgbHash, byte[] rgbSignature, DSASignatureFormat signatureFormat);
+        public bool VerifySignature(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, DSASignatureFormat signatureFormat);
+        protected virtual bool VerifySignatureCore(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, DSASignatureFormat signatureFormat);
     }
+    public enum DSASignatureFormat {
+        IeeeP1363FixedFieldConcatenation = 0,
+        Rfc3279DerSequence = 1,
+    }
     public abstract class ECDiffieHellman : AsymmetricAlgorithm {
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);
+        public override void ImportFromPem(ReadOnlySpan<char> input);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public abstract class ECDsa : AsymmetricAlgorithm {
+        public int GetMaxSignatureSize(DSASignatureFormat signatureFormat);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);
+        public override void ImportFromPem(ReadOnlySpan<char> input);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public byte[] SignData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public byte[] SignData(byte[] data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public byte[] SignData(Stream data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        protected virtual byte[] SignDataCore(Stream data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        protected virtual byte[] SignDataCore(ReadOnlySpan<byte> data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public byte[] SignHash(byte[] hash, DSASignatureFormat signatureFormat);
+        protected virtual byte[] SignHashCore(ReadOnlySpan<byte> hash, DSASignatureFormat signatureFormat);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
+        public bool TrySignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat, out int bytesWritten);
+        protected virtual bool TrySignDataCore(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat, out int bytesWritten);
+        public bool TrySignHash(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat, out int bytesWritten);
+        protected virtual bool TrySignHashCore(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat, out int bytesWritten);
+        public bool VerifyData(byte[] data, byte[] signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public bool VerifyData(byte[] data, int offset, int count, byte[] signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public bool VerifyData(Stream data, byte[] signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public bool VerifyData(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        protected virtual bool VerifyDataCore(Stream data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        protected virtual bool VerifyDataCore(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public bool VerifyHash(byte[] hash, byte[] signature, DSASignatureFormat signatureFormat);
+        public bool VerifyHash(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, DSASignatureFormat signatureFormat);
+        protected virtual bool VerifyHashCore(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, DSASignatureFormat signatureFormat);
     }
     public abstract class HashAlgorithm : ICryptoTransform, IDisposable {
+        public Task<byte[]> ComputeHashAsync(Stream inputStream, CancellationToken cancellationToken = default(CancellationToken));
     }
     public readonly struct HashAlgorithmName : IEquatable<HashAlgorithmName> {
+        public static HashAlgorithmName FromOid(string oidValue);
+        public static bool TryFromOid(string oidValue, out HashAlgorithmName value);
     }
+    public static class HKDF {
+        public static byte[] DeriveKey(HashAlgorithmName hashAlgorithmName, byte[] ikm, int outputLength, byte[] salt = null, byte[] info = null);
+        public static void DeriveKey(HashAlgorithmName hashAlgorithmName, ReadOnlySpan<byte> ikm, Span<byte> output, ReadOnlySpan<byte> salt, ReadOnlySpan<byte> info);
+        public static byte[] Expand(HashAlgorithmName hashAlgorithmName, byte[] prk, int outputLength, byte[] info = null);
+        public static void Expand(HashAlgorithmName hashAlgorithmName, ReadOnlySpan<byte> prk, Span<byte> output, ReadOnlySpan<byte> info);
+        public static byte[] Extract(HashAlgorithmName hashAlgorithmName, byte[] ikm, byte[] salt = null);
+        public static int Extract(HashAlgorithmName hashAlgorithmName, ReadOnlySpan<byte> ikm, ReadOnlySpan<byte> salt, Span<byte> prk);
+    }
     public sealed class IncrementalHash : IDisposable {
+        public int HashLengthInBytes { get; }
+        public static IncrementalHash CreateHMAC(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> key);
+        public byte[] GetCurrentHash();
+        public int GetCurrentHash(Span<byte> destination);
+        public int GetHashAndReset(Span<byte> destination);
+        public bool TryGetCurrentHash(Span<byte> destination, out int bytesWritten);
     }
     public abstract class MD5 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public sealed class MD5CryptoServiceProvider : MD5 {
-        protected override void HashCore(byte[] rgb, int ibStart, int cbSize);
+        protected override void HashCore(byte[] array, int ibStart, int cbSize);
     }
+    public static class PemEncoding {
+        public static PemFields Find(ReadOnlySpan<char> pemData);
+        public static int GetEncodedSize(int labelLength, int dataLength);
+        public static bool TryFind(ReadOnlySpan<char> pemData, out PemFields fields);
+        public static bool TryWrite(ReadOnlySpan<char> label, ReadOnlySpan<byte> data, Span<char> destination, out int charsWritten);
+        public static char[] Write(ReadOnlySpan<char> label, ReadOnlySpan<byte> data);
+    }
+    public readonly struct PemFields {
+        public Range Base64Data { get; }
+        public int DecodedDataLength { get; }
+        public Range Label { get; }
+        public Range Location { get; }
+    }
     public abstract class RSA : AsymmetricAlgorithm {
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);
+        public override void ImportFromPem(ReadOnlySpan<char> input);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public abstract class SHA1 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA1CryptoServiceProvider : SHA1 {
-        protected override void HashCore(byte[] rgb, int ibStart, int cbSize);
+        protected override void HashCore(byte[] array, int ibStart, int cbSize);
     }
     public sealed class SHA1Managed : SHA1 {
-        protected override void Dispose(bool disposing);
+        protected sealed override void Dispose(bool disposing);
-        protected override void HashCore(byte[] rgb, int ibStart, int cbSize);
+        protected sealed override void HashCore(byte[] array, int ibStart, int cbSize);
-        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
-        protected override byte[] HashFinal();
+        protected sealed override byte[] HashFinal();
-        public override void Initialize();
+        public sealed override void Initialize();
-        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public abstract class SHA256 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA256Managed : SHA256 {
-        protected override void Dispose(bool disposing);
+        protected sealed override void Dispose(bool disposing);
-        protected override void HashCore(byte[] rgb, int ibStart, int cbSize);
+        protected sealed override void HashCore(byte[] array, int ibStart, int cbSize);
-        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
-        protected override byte[] HashFinal();
+        protected sealed override byte[] HashFinal();
-        public override void Initialize();
+        public sealed override void Initialize();
-        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public abstract class SHA384 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA384Managed : SHA384 {
-        protected override void Dispose(bool disposing);
+        protected sealed override void Dispose(bool disposing);
-        protected override void HashCore(byte[] rgb, int ibStart, int cbSize);
+        protected sealed override void HashCore(byte[] array, int ibStart, int cbSize);
-        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
-        protected override byte[] HashFinal();
+        protected sealed override byte[] HashFinal();
-        public override void Initialize();
+        public sealed override void Initialize();
-        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public abstract class SHA512 : HashAlgorithm {
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA512Managed : SHA512 {
-        protected override void Dispose(bool disposing);
+        protected sealed override void Dispose(bool disposing);
-        protected override void HashCore(byte[] rgb, int ibStart, int cbSize);
+        protected sealed override void HashCore(byte[] array, int ibStart, int cbSize);
-        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
-        protected override byte[] HashFinal();
+        protected sealed override byte[] HashFinal();
-        public override void Initialize();
+        public sealed override void Initialize();
-        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
 }
```

