# .NET 5.0.0 Preview 2 - April 2, 2020

.NET 5.0.0 Preview 2 is available for download and usage in your environment. This release includes .NET 5.0.0 Preview 2 and .NET SDK 5.0.100 Preview 2.

* [Downloads](https://dotnet.microsoft.com/download/dotnet/5.0)
* [.NET 5.0 Preview 2 Blog][dotnet-blog]
* [ASP.NET Core Blog][aspnet-blog]
* [EF Core Blog][ef-blog]
* [Changes in this release](#notable-changes-in-500-preview-2)
* [Known issues](../5.0-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET SDK 5.0.100 Preview 2 includes .NET 5.0.0 preview Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET SDK 5.0.100 preview, the following command will show that you're running version `5.0.100-preview.2.20176.6` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4500](https://github.com/dotnet/core/issues/4500) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [Snap and Package Manager](5.0.0-preview.2-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET 5 Preview 2 requires Visual Studio 2019 16.6 Preview to take full advantage of all its features. .NET 5 Preview 2 will not work properly in earlier versions of Visual Studio. Visit [Visual Studio Preview](https://visualstudio.microsoft.com/vs/preview/) to learn about VS previews.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

## Notable Changes in 5.0.0 Preview 2

Here is list of some of the additions and updates we're excited to bring in Preview 2. See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.

* Runtime: [bugs][runtime_bugs] | [features][runtime_features]
* ASP.NET Core: [features][aspnet_features]
* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.0-preview.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-preview.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-preview.2-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-5-0-preview-2/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-preview-2/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-5-0-preview-2/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0-preview2+is%3Aclosed+label%3Atype-bug+is%3Aclosed
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0-preview2+is%3Aclosed+label%3Atype-enhancement+is%3Aclosed

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-preview2+label%3ADone+label%3Abug+is%3Aclosed
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-preview2+label%3ADone+label%3Aenhancement+is%3Aclosed
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A5.0+label%3Abug+is%3Aclosed
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A5.0+label%3Aenhancement+is%3Aclosed

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.1xx+is%3Aclosed


[//]: # ( Runtime 5.0.0-preview.2.20160.6)
[dotnet-apphost-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/44853b8b-53b4-4f85-affc-b98f62167358/0b690b9675696ae8a2f2d4ea86c5de3a/dotnet-apphost-pack-5.0.0-preview.2.20160.6-x64.deb
[dotnet-apphost-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/364e6a3a-486a-48ae-9f7e-b6ed36c72e55/9432eb01047c21d2999357dfcbdec0a2/dotnet-apphost-pack-5.0.0-preview.2.20160.6-x64.rpm
[dotnet-host-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/7ae67930-daf1-4eb7-9a90-0b119c8c0be4/b1b0776885d0895384bb82e1c9b2205c/dotnet-host-5.0.0-preview.2.20160.6-x64.deb
[dotnet-host-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/4b5422a7-1b37-45b1-985d-357599a7e838/ddfe668bd25054a0ab0d37940d70b80a/dotnet-host-5.0.0-preview.2.20160.6-x64.rpm
[dotnet-hostfxr-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/eeeea1b9-55f4-41de-b1d9-eaff6f4548d1/84d6146b817601fbd57e982d02c9fad5/dotnet-hostfxr-5.0.0-preview.2.20160.6-x64.deb
[dotnet-hostfxr-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/0bc83586-0c67-4de4-9234-b3f25478da34/307c9c79dfac51dfc1e775b00407e59a/dotnet-hostfxr-5.0.0-preview.2.20160.6-x64.rpm
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f0267d8-77f6-4677-8c7d-757b100d3b54/f57788735881fd95b90ca020653c6bb6/dotnet-runtime-5.0.0-preview.2.20160.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c224d38-8f76-4ae7-808b-c9617fc46d27/26bee5ca707c17eb8afec45acd4785fe/dotnet-runtime-5.0.0-preview.2.20160.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf5994eb-1eda-49b1-8912-2bd7386b4f56/380f690e7904a32e4b8ce89736458d8d/dotnet-runtime-5.0.0-preview.2.20160.6-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/85a0c2f5-f0b7-445a-84c1-bfcea1c94d9c/7c0808ed36558df5487b6196967344e8/dotnet-runtime-5.0.0-preview.2.20160.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f98746fd-2d36-4181-9978-e373a321e247/7cf737bead76e4b09b309fa7122cd134/dotnet-runtime-5.0.0-preview.2.20160.6-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e486a3b0-7689-4429-8c6b-8388df41c14c/3ccd26660a01b4af7b24d77d0f4128b1/dotnet-runtime-5.0.0-preview.2.20160.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da039879-4fea-4e4b-a779-2f3c271c0a09/777fc8882d54407f82bf3d0b801d853f/dotnet-runtime-5.0.0-preview.2.20160.6-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/90f0831b-4699-4314-866a-977ac8a64e59/794fd7e14bc6404257a04d225d0ade79/dotnet-runtime-5.0.0-preview.2.20160.6-win-arm.zip
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a26cea08-bc46-4d97-a8a3-0aebb3f135f4/2aece2998f2eb12292bb410912c8cca3/dotnet-runtime-5.0.0-preview.2.20160.6-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ca6db74a-5f97-48e5-9abf-14414e825215/d6f04952fd2bb61d7af4a4fa6d8d0759/dotnet-runtime-5.0.0-preview.2.20160.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6d7798d7-2df3-469e-a6ff-f3e99c35838f/9aa0b9ada7f2c43524e67c0ead227693/dotnet-runtime-5.0.0-preview.2.20160.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a82ac5a9-cd97-4a27-a02e-5fcf98be31f2/014f4378b742465f7772998b25cf53bc/dotnet-runtime-5.0.0-preview.2.20160.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/236c8426-af8a-40b1-b1f7-449971674dd9/db79bdd104621b1e6fde4e334cbb534a/dotnet-runtime-5.0.0-preview.2.20160.6-win-x86.zip
[dotnet-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/7636e659-2bdd-4a99-82d8-852a76623d7c/c9bd97db81e20d4a6323acaaf8315695/dotnet-runtime-5.0.0-preview.2.20160.6-x64.deb
[dotnet-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/e9d54bc7-511c-45e9-b1cd-be7000ebae4d/e9428374b9b96b59cb534ecb7972a08d/dotnet-runtime-5.0.0-preview.2.20160.6-x64.rpm
[dotnet-runtime-deps-centos.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/473bf5ec-2cb8-41fe-bc20-7ed3aff24e97/da775dc162abd69f4f56ec3bd5a4eab3/dotnet-runtime-deps-5.0.0-preview.2.20160.6-centos.7-x64.rpm
[dotnet-runtime-deps-fedora.27-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/331480bd-392e-441f-a2fd-7cc44eb91963/4bd8a7444c84cdb330a57e112b378840/dotnet-runtime-deps-5.0.0-preview.2.20160.6-fedora.27-x64.rpm
[dotnet-runtime-deps-opensuse.42-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/016e84d1-12cd-4936-a395-f59175f315c1/3be52ec84087310f818062c9eddfb8cd/dotnet-runtime-deps-5.0.0-preview.2.20160.6-opensuse.42-x64.rpm
[dotnet-runtime-deps-oraclelinux.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/a90a5ac1-a810-4949-9a80-375edb781a20/7446a37848fbfbd71a7a5712fa1b00e2/dotnet-runtime-deps-5.0.0-preview.2.20160.6-oraclelinux.7-x64.rpm
[dotnet-runtime-deps-rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/8a3a4c2a-2d1c-452c-98e2-f7d311e5da6c/be182c8bab34374882fc9e8983401ff0/dotnet-runtime-deps-5.0.0-preview.2.20160.6-rhel.7-x64.rpm
[dotnet-runtime-deps-sles.12-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/44284ae1-547f-4b70-aae5-ed4845c062dc/2dc547727ead01a436355f5ef62fa0fb/dotnet-runtime-deps-5.0.0-preview.2.20160.6-sles.12-x64.rpm
[dotnet-runtime-deps-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/f2690fbb-0339-451a-b9d9-2524e5e0f5ca/96b2876bce44409090b0f9f6e857e50e/dotnet-runtime-deps-5.0.0-preview.2.20160.6-x64.deb
[dotnet-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/76d622f8-a4ac-48f7-91ee-067a57b3f1fa/c806d99c72e3df42e804d42790fbde17/dotnet-targeting-pack-5.0.0-preview.2.20160.6-x64.deb
[dotnet-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/123647ba-a2f7-42b6-b0ab-71ca13eedcdc/821eeda51d3c6f1f10d5131ac75eaa9a/dotnet-targeting-pack-5.0.0-preview.2.20160.6-x64.rpm
[netstandard-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/52431976-cd2a-4c7a-a8e3-7b5f1d76fdd8/f8c4af99f9c02963a5d152bd65017013/netstandard-targeting-pack-2.1.0-preview.2.20160.6-x64.deb
[netstandard-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/41364085-9a79-4cbf-ad99-ad7fbe075196/4e0965ed7e784897e433af673b85ea69/netstandard-targeting-pack-2.1.0-preview.2.20160.6-x64.rpm

[//]: # ( WindowsDesktop 5.0.0-preview.2.20160.6)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7fac4640-23f9-4e48-bce1-988292457ece/c6eff69e2d349a94794825a651657442/windowsdesktop-runtime-5.0.0-preview.2.20160.6-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/db134090-e6c1-4354-94ef-72a8bf42b6d6/c33b7f134c8778107d58b70aaf17af24/windowsdesktop-runtime-5.0.0-preview.2.20160.6-win-x86.exe

[//]: # ( ASP 5.0.0-preview.2.20167.3)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30617205-4338-4610-aa52-f15e92f9cbca/e6e9e688f333bab1aeaf8a94ded6b894/aspnetcore-runtime-5.0.0-preview.2.20167.3-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75836796-02cf-4fe6-a3ea-e80aca657853/6ae8b11f79026141b47205cbe22fb549/aspnetcore-runtime-5.0.0-preview.2.20167.3-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ed6c92e-e82a-4b9f-8241-f589903bb9d2/4328a009d8296b949a9f5dd845e42cfd/aspnetcore-runtime-5.0.0-preview.2.20167.3-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/05b6fd6b-3233-43dc-885e-6f25b1fe15c1/7834ecd7688f9e258ce78fbf942f0fb9/aspnetcore-runtime-5.0.0-preview.2.20167.3-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/169871b7-ce8f-4518-a342-209f98342569/4bb2abeecf4b064eac907fb28f96b5ca/aspnetcore-runtime-5.0.0-preview.2.20167.3-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b8c4d3d2-b298-481c-8058-2f297c679be7/77e5e16c704720a52f89d39e676a3e7c/aspnetcore-runtime-5.0.0-preview.2.20167.3-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9fa60f80-a627-4dfc-8013-33f407112328/7809d7025c557beba477a0a49da6b9a0/aspnetcore-runtime-5.0.0-preview.2.20167.3-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fbe8e0a5-7d9b-4cc4-bb16-7166ac5c8caa/3dde80bb4d0e312a418d20ba459b2a88/aspnetcore-runtime-5.0.0-preview.2.20167.3-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a0bf9c39-d15e-4957-a7f2-cdd7aef660bf/d171c3c8ae27d6887eeec4e834f79234/aspnetcore-runtime-5.0.0-preview.2.20167.3-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b87565ce-850f-4406-813e-d38911d6528c/5828bcf354e2d7de213b097077e37ead/aspnetcore-runtime-5.0.0-preview.2.20167.3-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9b0aea06-9e28-4fc0-8a47-5d999a6d2589/7e243fc0b1ddcc61a971a7f36a36a2cd/aspnetcore-runtime-5.0.0-preview.2.20167.3-win-x86.zip
[aspnetcore-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/450b65be-bd49-40d8-be9a-627dd060e014/b5d03d57ae4a0f489a61514f7f328beb/aspnetcore-runtime-5.0.0-preview.2.20167.3-x64.deb
[aspnetcore-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/c56b28c4-4af7-42d9-9951-389d50d6704b/8369cd45ef688c8b9c2e05aee0c5df25/aspnetcore-runtime-5.0.0-preview.2.20167.3-x64.rpm
[aspnetcore-targeting-pack.deb]: https://download.visualstudio.microsoft.com/download/pr/4fbbab52-c028-4a68-85a3-158278c82006/ee9fda837661283d82a78ff1a6ad4ebd/aspnetcore-targeting-pack-5.0.0-preview.2.20167.3.deb
[aspnetcore-targeting-pack.rpm]: https://download.visualstudio.microsoft.com/download/pr/c45beaea-2f14-4ff6-bc9a-a1a3e7260055/b1f0a2d352cfab9de6bbb3611da00a99/aspnetcore-targeting-pack-5.0.0-preview.2.20167.3.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/e563b5c8-380d-4ccc-8e5e-272c6cee6520/66a77e469c68453714dfe13a281b89a9/dotnet-hosting-5.0.0-preview.2.20167.3-win.exe

[//]: # ( SDK 5.0.100-preview.2.20176.6 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c35cd82b-2b99-4572-a8f3-64718bb62ad1/c7e67beb45f7819545e1a62139ed96a7/dotnet-sdk-5.0.100-preview.2.20176.6-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f87574ee-c128-4e91-b436-68c99d801daf/b296bea9d987a4edaa71df47cd2e7aca/dotnet-sdk-5.0.100-preview.2.20176.6-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a759ab8d-26fe-4862-8b02-788f6ec47ede/7c2ca8984e9a0bfef27ab95cf28379a1/dotnet-sdk-5.0.100-preview.2.20176.6-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/727a5825-d29a-4f45-beaa-053399f8b5ee/5f15827ceb4851ef87a008f5de0acf6c/dotnet-sdk-5.0.100-preview.2.20176.6-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3ce4af4f-f5d5-406c-a065-2ecc9bcc5fd2/353affd22a0727b476998312738ac35f/dotnet-sdk-5.0.100-preview.2.20176.6-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5046ce80-6398-4173-9717-e2947f2585eb/841aad7475e8c9b78cbc50e3b8d35dae/dotnet-sdk-5.0.100-preview.2.20176.6-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/7d12d31d-a6c7-49d4-b1d3-91f531932553/43331ea36d39b63238d30c19e5a4bec9/dotnet-sdk-5.0.100-preview.2.20176.6-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/00296620-d967-4ae4-af29-bef9b0019970/4cdb51006f22059c14913bdfca57f5a1/dotnet-sdk-5.0.100-preview.2.20176.6-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/023b41aa-073b-491e-93ac-7e726fb81bda/b06f72654e32d1bddc941ff932f32c59/dotnet-sdk-5.0.100-preview.2.20176.6-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2f9d9ebd-07b9-4c88-b4e6-8cff9d5be760/ac3e76c14c15cf0999b3b8d2bb3a904a/dotnet-sdk-5.0.100-preview.2.20176.6-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c1a5bd0c-6236-45a9-bda4-fb9e2007e770/0a078520e350f64a92d5f97ee9b89a9f/dotnet-sdk-5.0.100-preview.2.20176.6-win-x86.zip
[dotnet-sdk-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/d10bf368-79f0-4635-a04f-93301569844d/a3991083c98a2cc5ba1700e0048aaa88/dotnet-sdk-5.0.100-preview.2.20176.6-x64.deb
[dotnet-sdk-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/ce4434c6-31be-4f7b-9c42-3c43a3e3a9cc/becff13989b2a126637acc2692e223cf/dotnet-sdk-5.0.100-preview.2.20176.6-x64.rpm

[//]: # ( Symbols )
