# .NET 5.0.0 Preview 3 - April 23, 2020

.NET 5.0.0 Preview 3 is available for download and usage in your environment. This release includes .NET 5.0.0 Preview 3 and .NET SDK 5.0.100 Preview 3.

* [Downloads](https://dotnet.microsoft.com/download/dotnet/5.0)
* [.NET 5.0 Preview 3 Blog][dotnet-blog]
* [ASP.NET Core Blog][aspnet-blog]
* [EF Core Blog][ef-blog]
* [Changes in this release](#notable-changes-in-500-preview-3)
* [Known issues](../5.0-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET SDK 5.0.100 Preview 3 includes .NET 5.0.0 preview Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET SDK 5.0.100 preview, the following command will show that you're running version `5.0.100-preview.3.20216.6` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4607](https://github.com/dotnet/core/issues/4607) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [Snap and Package Manager](5.0.0-preview.3-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET 5 Preview 3 requires Visual Studio 2019 16.6 Preview to take full advantage of all its features. .NET 5 Preview 3 will not work properly in earlier versions of Visual Studio. Visit [Visual Studio Preview](https://visualstudio.microsoft.com/vs/preview/) to learn about VS previews.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

## Notable Changes in 5.0.0 Preview 3

Here is list of some of the additions and updates we're excited to bring in Preview 3. See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.

* Runtime: [bugs][runtime_bugs] | [features][runtime_features]
* ASP.NET Core: [bugs][aspnet_bugs] | [features][aspnet_features]
* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.0-preview.3.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-preview.3-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-preview.3-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-5-0-preview-3/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-preview-3/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-5-0-preview-3/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0-preview3+is%3Aclosed+label%3Atype-bug+is%3Aclosed
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0-preview3+is%3Aclosed+label%3Atype-enhancement+is%3Aclosed

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-preview3+label%3ADone+label%3Abug+is%3Aclosed
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-preview3+label%3ADone+label%3Aenhancement+is%3Aclosed
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A5.0+label%3Abug+is%3Aclosed
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A5.0+label%3Aenhancement+is%3Aclosed

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.1xx+is%3Aclosed


[//]: # ( Runtime 5.0.0-preview.3.20214.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca8f37c7-b5b2-450b-9469-b2941861df64/c722ff6e03c6c8f276faf391c7a8bae4/dotnet-runtime-5.0.0-preview.3.20214.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56f1893f-d059-4825-ad3f-488859fb86d7/022976b07c9b8bfc9e650c95fc3b91be/dotnet-runtime-5.0.0-preview.3.20214.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/858f5b65-8b2c-4ab1-9769-7fec5b38c8a1/44a1c0f6131e44f21425076ac295a41b/dotnet-runtime-5.0.0-preview.3.20214.6-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d5f23cce-759b-44c7-a456-a668d855b506/3dd2f633b763236a6bcb7d4bf63f1ec0/dotnet-runtime-5.0.0-preview.3.20214.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/038fae85-6953-4518-adc6-55038ccf1c33/ccf2b3e7ba7ebe4da8b35c91eede7d6a/dotnet-runtime-5.0.0-preview.3.20214.6-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/de092180-43f4-4f89-b72c-a149aa86caf4/d603d2b043ae80556f1239946140471a/dotnet-runtime-5.0.0-preview.3.20214.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/933ae6ba-87e0-4d25-86b8-51ae5a7c709e/7849e0ef58f691fce783ed5e00001833/dotnet-runtime-5.0.0-preview.3.20214.6-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/a4deeca3-1c0c-40c5-8225-163f7ae7e5e5/a18293ed8f7329f99ffca364a9a86107/dotnet-runtime-5.0.0-preview.3.20214.6-win-arm.zip
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6a69b58d-7aa2-4b11-b679-762b0cc48427/cf23f3f6a78c36936a486d8d35a3e105/dotnet-runtime-5.0.0-preview.3.20214.6-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/138d840f-5583-4f3d-bd79-05f0ff719cc9/5cfa84f529bf0227427beda07c74d7f7/dotnet-runtime-5.0.0-preview.3.20214.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bbd5a03c-0a4e-4530-947f-eb4f44eb30f4/34f0574dbe0525a1073e4b7c83c340bb/dotnet-runtime-5.0.0-preview.3.20214.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/020c789e-510a-4c61-8614-18f48272cc89/097461f8baa43cc90d1507460cb75ed0/dotnet-runtime-5.0.0-preview.3.20214.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8d0c54d3-f87b-42f8-904e-ac7a093f3a00/677c2cc203a451eb31cf8a461440c428/dotnet-runtime-5.0.0-preview.3.20214.6-win-x86.zip

[//]: # ( WindowsDesktop 5.0.0-preview.3.20214.2)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3d928a84-9d22-44e2-b273-c0ba24d95018/7f168212264a949c0f3799cf450f0a14/windowsdesktop-runtime-5.0.0-preview.3.20214.2-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/39d51d83-8b69-4b8b-8fd2-8ea451fc743e/dd667944896af153df70036bd9323fef/windowsdesktop-runtime-5.0.0-preview.3.20214.2-win-x86.exe

[//]: # ( ASP 5.0.0-preview.3.20215.14)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ffbb2903-bd07-47e0-aa7d-9264c942cc38/9937a6b2cf97e16f878f4f3feb874479/aspnetcore-runtime-5.0.0-preview.3.20215.14-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d7fdf8a-9163-4044-8626-a0e83bf2a4d9/a02834ce1a5f88021e0c764ccef582c1/aspnetcore-runtime-5.0.0-preview.3.20215.14-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f2bbffd9-83c3-4ad0-aabd-0f6a54b720d4/a6b5f14b44aaf5abb6dea3ad9e88b7d5/aspnetcore-runtime-5.0.0-preview.3.20215.14-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20473703-695e-45c5-b5f3-7d307d3e1aa5/e09ef05ba456f3968d5cff24ceff3358/aspnetcore-runtime-5.0.0-preview.3.20215.14-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76655cff-bf24-4445-a4af-9dbca1f00e86/4366686af0585397f290d27a042a1449/aspnetcore-runtime-5.0.0-preview.3.20215.14-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dcf33838-366b-45c9-9db5-8ae6d59c1433/afa19a627e073b7f7e26c740ba56f352/aspnetcore-runtime-5.0.0-preview.3.20215.14-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/64048ca3-4b02-422a-a8aa-e088b7dd521c/b7007855d06ccba94111e8bccdd8e968/aspnetcore-runtime-5.0.0-preview.3.20215.14-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/389a714a-d6e9-4e2d-a78c-04e45ed12e17/7cfbdf77fc2a0dc1dbdf2bd0985e5199/aspnetcore-runtime-5.0.0-preview.3.20215.14-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7683a95e-1336-4f8b-a3a0-21f6dab44138/9248f166869d1906a6e37a80e81b7b16/aspnetcore-runtime-5.0.0-preview.3.20215.14-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f309e08f-d2f6-46a4-92bf-09cc20475884/06fd23949d41b46fcb76e3ee60c3c4e2/aspnetcore-runtime-5.0.0-preview.3.20215.14-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/cf56d473-8868-41c2-b86f-14c7b0ae56ef/4c54b358bdb5f86ca77df4a3a79d0f59/aspnetcore-runtime-5.0.0-preview.3.20215.14-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/f84dffc7-f825-47d4-aad5-f3af1444ecc1/935d1397344d5179cf210787d6435c44/dotnet-hosting-5.0.0-preview.3.20215.14-win.exe

[//]: # ( SDK 5.0.100-preview.3.20216.6 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58276f20-1ff1-49e7-afbd-fcc6a20acf56/18aacff58da12a91e691036be7ef8063/dotnet-sdk-5.0.100-preview.3.20216.6-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/67d8e63e-753d-4900-997f-b332bb63b025/303b7ac855985d077056ef4552f4a4e9/dotnet-sdk-5.0.100-preview.3.20216.6-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9d2501d-4089-4255-9d5c-e94e1ec6532c/9abb1d2998427fa23701649a7b1b1513/dotnet-sdk-5.0.100-preview.3.20216.6-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7ceba34e-5d50-4b23-b326-0a7d02b4decd/62dd73db9be67127a5645ef0efb0bba4/dotnet-sdk-5.0.100-preview.3.20216.6-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3fa9a36e-907c-4d7a-a98a-e50ad0aa4990/ff63364b94e98687d5933c1b9a50a5d0/dotnet-sdk-5.0.100-preview.3.20216.6-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b8fe806-7a65-43e8-889d-215999715bbf/22005a4af0c34e257e652dbe39d3661f/dotnet-sdk-5.0.100-preview.3.20216.6-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/585c7f99-1d47-4422-8e74-4beb2809e9c7/531e64c80bfa9937ad5a3e19f78847c0/dotnet-sdk-5.0.100-preview.3.20216.6-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/848d5ef2-81ca-43ff-81f7-6b6e9e38c186/e3462954d7cd7ac54e40d45b9d07d9c9/dotnet-sdk-5.0.100-preview.3.20216.6-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5d93d786-1442-4479-868d-5d3b4175b160/b7629a4cd3f95cb0a2d7b202537fdc2d/dotnet-sdk-5.0.100-preview.3.20216.6-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ed38b46c-2373-4e81-aab9-18a7f727685e/018f9be726039087d1654b055c2eb641/dotnet-sdk-5.0.100-preview.3.20216.6-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/be4d30a2-9cb9-43d0-b5a7-b6ba63d77bbe/f77ee9cd22084283dd23762b23996db8/dotnet-sdk-5.0.100-preview.3.20216.6-win-x86.zip

[//]: # ( Symbols )
