# .NET 5.0.0 Preview 5 - June 10, 2020

.NET 5.0.0 Preview 5 is available for download and usage in your environment. This release includes .NET 5.0.0 Runtime Preview 5 and .NET SDK 5.0.100 Preview 5.

* [Downloads](https://dotnet.microsoft.com/download/dotnet/5.0)
* [.NET 5.0 Preview 5 Blog][dotnet-blog]
* [ASP.NET Core Blog][aspnet-blog]
* [EF Core Blog][ef-blog]
* [Changes in this release](#notable-changes-in-500-preview-5)
* [Known issues](../5.0-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET SDK 5.0.100 Preview 5 includes .NET 5.0.0 preview Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET SDK 5.0.100 preview, the following command will show that you're running version `5.0.100-preview.5.20279.10` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4813](https://github.com/dotnet/core/issues/4813) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [Snap and Package Manager](5.0.0-preview.5-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET 5 Preview 5 requires Visual Studio 2019 16.6 to take full advantage of all its features. .NET 5 Preview 5 won't work properly in earlier versions of Visual Studio. Visit [Visual Studio Preview](https://visualstudio.microsoft.com/vs/preview/) to learn about VS previews.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

## Notable Changes in 5.0.0 Preview 5

Here is list of some of the additions and updates we're excited to bring in Preview 5. See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.

* Runtime: [bugs][runtime_bugs] | [features][runtime_features]
* ASP.NET Core: [bugs][aspnet_bugs] | [features][aspnet_features]
* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.0-preview.5.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-preview.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.0-preview.5-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-5-0-preview-5/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-preview-5/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-5-0-preview-5/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0-preview5+is%3Aclosed+label%3Atype-bug+is%3Aclosed
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A5.0.0-preview5+is%3Aclosed+label%3Atype-enhancement+is%3Aclosed

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-preview5+label%3ADone+label%3Abug+is%3Aclosed
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A5.0.0-preview5+label%3ADone+label%3Aenhancement+is%3Aclosed
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A5.0+label%3Abug+is%3Aclosed
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A5.0+label%3Aenhancement+is%3Aclosed

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.1xx+is%3Aclosed


[//]: # ( Runtime 5.0.0-preview.5.20278.1)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/51a30257-7167-452f-bb48-8bf52874a312/3442cb330320a26a2b6a060202f4ee7a/dotnet-runtime-5.0.0-preview.5.20278.1-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/875a8949-420f-4fdc-858a-30f293a4cc9b/5b44049862dc82764c6e03120d52a9b6/dotnet-runtime-5.0.0-preview.5.20278.1-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b1e4ff98-4e4b-4cd6-981e-33acfc20bc7a/840d6032bc7e4dc55c4d03a6ab44ab98/dotnet-runtime-5.0.0-preview.5.20278.1-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f23ebe0b-74be-4fd3-841b-123b32dbcffb/3c33ceb3af2f23632689e670fc9fc397/dotnet-runtime-5.0.0-preview.5.20278.1-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95306227-0c75-4645-87ef-3d5b46af79a4/bb4aeba4db192c2a62fac09cb797ba08/dotnet-runtime-5.0.0-preview.5.20278.1-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ed4dddfa-d703-451e-bd2f-8dfbe81a735e/9b15085e7d4be3d3c881abc24db523b8/dotnet-runtime-5.0.0-preview.5.20278.1-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/896a86ec-29db-4915-b2c6-f2f7b4e672fb/27fe60394d6a00ee18c37038b9e3280e/dotnet-runtime-5.0.0-preview.5.20278.1-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/01efb1c0-2b52-4ab7-be2b-38369d8fd806/e8366cf8870271e1da2b6f07a8b983c2/dotnet-runtime-5.0.0-preview.5.20278.1-win-arm.zip
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7e01b3e5-e9ce-4e9c-baa1-ba71a6c7b415/dee7f90305b7bbf9a95d5529cf125eee/dotnet-runtime-5.0.0-preview.5.20278.1-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/add3d66a-0362-4963-9cb6-995a35bbc462/8641decedefe5f3026ea00cfb669667b/dotnet-runtime-5.0.0-preview.5.20278.1-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/77eae450-bf51-46dd-a464-c705efe62f7f/89c0c2c7a7eed4f492a8cc2ed4342f00/dotnet-runtime-5.0.0-preview.5.20278.1-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5a1a5d33-3e09-46ee-941c-73ed1f4e5092/dacf37c9b40b973f78a11c95e9550d51/dotnet-runtime-5.0.0-preview.5.20278.1-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2ea3be64-1cec-4ded-a992-703de2aa40c5/1eea262da0c415e926a6b411c2def271/dotnet-runtime-5.0.0-preview.5.20278.1-win-x86.zip

[//]: # ( WindowsDesktop 5.0.0-preview.5.20278.3)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6cc1a99f-4e83-408f-95aa-b44dfdc9bc56/88d52d94d7f4f96c1313cb95d72c8515/windowsdesktop-runtime-5.0.0-preview.5.20278.3-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/94c3c646-f95d-41d3-a534-6617b3edfe87/4e36ed04c3ea19e82a42104982d1fd3d/windowsdesktop-runtime-5.0.0-preview.5.20278.3-win-x86.exe

[//]: # ( ASP 5.0.0-preview.5.20279.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1c2aaaf5-a2e4-479e-8e66-c75415ea167d/b4b71f1a89af057334187b0c36d5b6dd/aspnetcore-runtime-5.0.0-preview.5.20279.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/adc871bb-2eb6-4083-8665-a005367fff17/a76aee5f824dc9876a6d27adf9be28a6/aspnetcore-runtime-5.0.0-preview.5.20279.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eae4efcc-9105-45ba-a1ee-3a79f9ed51af/f879cce5713bb029254eba12b4aecb0b/aspnetcore-runtime-5.0.0-preview.5.20279.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5bf853cd-5736-4411-b853-0f6e24430d76/de830144eebdb7f681c1bdefd403c9a3/aspnetcore-runtime-5.0.0-preview.5.20279.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c4697b7a-c408-48e9-8d80-4ead593ee22b/8d03d322a7ca93efa1e8dbe66cf7a781/aspnetcore-runtime-5.0.0-preview.5.20279.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6aac3844-086d-48d5-9ed3-35ba1df3ba5a/587b8b0af9dda657c2331a3a205d2bf4/aspnetcore-runtime-5.0.0-preview.5.20279.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/04ad6c6d-c9b6-41f6-8636-671f51581831/429e3ca50495018d31c007f491accb81/aspnetcore-runtime-5.0.0-preview.5.20279.2-win-arm.zip
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/42156656-028a-4974-8a9a-cd368740e8fd/c16e719c0636401dd3e7442c436e2b15/aspnetcore-runtime-5.0.0-preview.5.20279.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9159b7cf-5285-48dc-b391-14cab2fd15c0/c3ce1d1d230bb2afc924c18b652f68f9/aspnetcore-runtime-5.0.0-preview.5.20279.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/36105bcc-125d-4269-8504-2c5fe5401fdd/11b4934407d307ab9f3951b6bb1a791a/aspnetcore-runtime-5.0.0-preview.5.20279.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/30e238e3-b342-4c67-a71d-e4220625f52d/e11097c56bd2707b1207de183ef3fcdb/aspnetcore-runtime-5.0.0-preview.5.20279.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/16474f86-f8d4-456e-85b4-7cd5e2dfe5f4/8935d76519cfa109128ecc66648a8732/aspnetcore-runtime-5.0.0-preview.5.20279.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/b1aaa280-c8d3-45cf-990e-cd1c736bb474/0c964ee4264bb54a5893d434942b7c73/dotnet-hosting-5.0.0-preview.5.20279.2-win.exe

[//]: # ( SDK 5.0.100-preview.5.20279.10 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6fb3f700-22ed-43d8-8f54-8152f359054b/050d3254d477aeb124a45d0cb13f864d/dotnet-sdk-5.0.100-preview.5.20279.10-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a529731c-7c51-42f4-9386-46c6466019dc/e408a0275c2333ae29a6e31c00c1ae64/dotnet-sdk-5.0.100-preview.5.20279.10-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/190ba32d-e1d5-442e-ac07-09b002e5750c/da229668b853a5912bdf1b224dbd371c/dotnet-sdk-5.0.100-preview.5.20279.10-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7cf9fa3e-af03-4181-baab-e04ed4b05268/fd44776a5169d6b126ee11d6140691be/dotnet-sdk-5.0.100-preview.5.20279.10-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f63b5b1e-25f9-4213-a147-ca8a252b8e27/094a39437dfc8f03eda852b36b499115/dotnet-sdk-5.0.100-preview.5.20279.10-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34e0dc05-8cf3-4deb-a9d2-14a697684cf3/5b37bee096f464f04393ac35cea8439a/dotnet-sdk-5.0.100-preview.5.20279.10-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/7022cbbf-275c-48fd-ba94-a994892e0bdc/91a25f084fe2595ab33fd7431fb68cf5/dotnet-sdk-5.0.100-preview.5.20279.10-win-arm.zip
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ecd42d26-c097-4755-a5cf-1e1cb0365d62/e71a36687a026248792177e2b42d0602/dotnet-sdk-5.0.100-preview.5.20279.10-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/38c82743-6223-4a51-a424-ac79a4db189b/5c88aa3116df3b81564077fe49a83c7f/dotnet-sdk-5.0.100-preview.5.20279.10-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d4c38dd9-6cfe-4e0b-91d3-511ede217bcc/6e6a85d8a85194a416503d1a103e95e0/dotnet-sdk-5.0.100-preview.5.20279.10-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6163690f-c627-4063-9229-fed74d955402/e33f89f431867b98e1a74297fe73cc7f/dotnet-sdk-5.0.100-preview.5.20279.10-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/63061248-531e-488d-a9c8-794a33a06ab7/910cf966d38c953d94d3140487786bb7/dotnet-sdk-5.0.100-preview.5.20279.10-win-x86.zip

[//]: # ( Symbols )
