# System.Net.Http

``` diff
 namespace System.Net.Http {
     public class ByteArrayContent : HttpContent {
+        protected override Stream CreateContentReadStream(CancellationToken cancellationToken);
+        protected override void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public abstract class DelegatingHandler : HttpMessageHandler {
+        protected internal override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class HttpClient : HttpMessageInvoker {
+        public HttpResponseMessage Send(HttpRequestMessage request);
+        public HttpResponseMessage Send(HttpRequestMessage request, HttpCompletionOption completionOption);
+        public HttpResponseMessage Send(HttpRequestMessage request, HttpCompletionOption completionOption, CancellationToken cancellationToken);
+        public override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class HttpClientHandler : HttpMessageHandler {
+        protected internal override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public abstract class HttpContent : IDisposable {
+        public void CopyTo(Stream stream, TransportContext context, CancellationToken cancellationToken);
+        protected virtual Stream CreateContentReadStream(CancellationToken cancellationToken);
+        public Stream ReadAsStream();
+        public Stream ReadAsStream(CancellationToken cancellationToken);
+        protected virtual void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public abstract class HttpMessageHandler : IDisposable {
+        protected internal virtual HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class HttpMessageInvoker : IDisposable {
+        public virtual HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public abstract class MessageProcessingHandler : DelegatingHandler {
+        protected internal sealed override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class MultipartContent : HttpContent, IEnumerable, IEnumerable<HttpContent> {
+        protected override Stream CreateContentReadStream(CancellationToken cancellationToken);
+        protected override void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public sealed class ReadOnlyMemoryContent : HttpContent {
+        protected override Stream CreateContentReadStream(CancellationToken cancellationToken);
+        protected override void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public sealed class SocketsHttpHandler : HttpMessageHandler {
+        protected internal override HttpResponseMessage Send(HttpRequestMessage request, CancellationToken cancellationToken);
     }
     public class StreamContent : HttpContent {
+        protected override Stream CreateContentReadStream(CancellationToken cancellationToken);
+        protected override void SerializeToStream(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
 }
```

