# System.Net.Security

``` diff
 namespace System.Net.Security {
+    public delegate ValueTask<SslServerAuthenticationOptions> ServerOptionsSelectionCallback(SslStream stream, SslClientHelloInfo clientHelloInfo, object state, CancellationToken cancellationToken);
+    public readonly struct SslClientHelloInfo {
+        public string ServerName { get; }
+        public SslProtocols SslProtocols { get; }
+    }
     public class SslServerAuthenticationOptions {
+        public SslStreamCertificateContext ServerCertificateContext { get; set; }
     }
     public class SslStream : AuthenticatedStream {
+        public string TargetHostName { get; }
+        public Task AuthenticateAsServerAsync(ServerOptionsSelectionCallback optionsCallback, object state, CancellationToken cancellationToken = default(CancellationToken));
     }
+    public sealed class SslStreamCertificateContext {
+        public static SslStreamCertificateContext Create(X509Certificate2 target, X509Certificate2Collection additionalCertificates, bool offline = false);
+    }
 }
```

