# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public readonly struct OSPlatform : IEquatable<OSPlatform> {
+        public static OSPlatform Android { get; }
+        public static OSPlatform iOS { get; }
+        public static OSPlatform macOS { get; }
+        public static OSPlatform tvOS { get; }
+        public static OSPlatform watchOS { get; }
     }
     public static class RuntimeInformation {
+        public static bool IsOSPlatformEarlierThan(OSPlatform osPlatform, int major);
+        public static bool IsOSPlatformEarlierThan(OSPlatform osPlatform, int major, int minor);
+        public static bool IsOSPlatformEarlierThan(OSPlatform osPlatform, int major, int minor, int build);
+        public static bool IsOSPlatformEarlierThan(OSPlatform osPlatform, int major, int minor, int build, int revision);
+        public static bool IsOSPlatformEarlierThan(string platformName);
+        public static bool IsOSPlatformOrLater(OSPlatform osPlatform, int major);
+        public static bool IsOSPlatformOrLater(OSPlatform osPlatform, int major, int minor);
+        public static bool IsOSPlatformOrLater(OSPlatform osPlatform, int major, int minor, int build);
+        public static bool IsOSPlatformOrLater(OSPlatform osPlatform, int major, int minor, int build, int revision);
+        public static bool IsOSPlatformOrLater(string platformName);
     }
     public sealed class UnmanagedCallersOnlyAttribute : Attribute {
-        public CallingConvention CallingConvention;

+        public Type[] CallConvs;
     }
 }
```

