# Microsoft.Extensions.Logging.Console

``` diff
 namespace Microsoft.Extensions.Logging.Console {
+    public abstract class ConsoleFormatter {
+        protected ConsoleFormatter(string name);
+        public string Name { get; }
+        public abstract void Write<TState>(in LogEntry<TState> logEntry, IExternalScopeProvider scopeProvider, TextWriter textWriter);
+    }
+    public static class ConsoleFormatterNames {
+        public const string Json = "json";
+        public const string Simple = "simple";
+        public const string Systemd = "systemd";
+    }
+    public class ConsoleFormatterOptions {
+        public ConsoleFormatterOptions();
+        public bool IncludeScopes { get; set; }
+        public string TimestampFormat { get; set; }
+        public bool UseUtcTimestamp { get; set; }
+    }
     public class ConsoleLoggerOptions {
+        public string FormatterName { get; set; }
     }
     public class ConsoleLoggerProvider : IDisposable, ILoggerProvider, ISupportExternalScope {
+        public ConsoleLoggerProvider(IOptionsMonitor<ConsoleLoggerOptions> options, IEnumerable<ConsoleFormatter> formatters);
     }
+    public class JsonConsoleFormatterOptions : ConsoleFormatterOptions {
+        public JsonConsoleFormatterOptions();
+        public JsonWriterOptions JsonWriterOptions { get; set; }
+    }
+    public class SimpleConsoleFormatterOptions : ConsoleFormatterOptions {
+        public SimpleConsoleFormatterOptions();
+        public bool DisableColors { get; set; }
+        public bool SingleLine { get; set; }
+    }
 }
```

