# Microsoft.JSInterop

``` diff
 namespace Microsoft.JSInterop {
+    public interface IJSInProcessObjectReference : IAsyncDisposable, IDisposable, IJSObjectReference {
+        TValue Invoke<TValue>(string identifier, params object[] args);
+    }
     public interface IJSInProcessRuntime : IJSRuntime {
-        T Invoke<T>(string identifier, params object[] args);

+        TResult Invoke<TResult>(string identifier, params object[] args);
     }
+    public interface IJSObjectReference : IAsyncDisposable {
+        ValueTask<TValue> InvokeAsync<TValue>(string identifier, object[] args);
+        ValueTask<TValue> InvokeAsync<TValue>(string identifier, CancellationToken cancellationToken, object[] args);
+    }
+    public interface IJSUnmarshalledObjectReference : IAsyncDisposable, IDisposable, IJSInProcessObjectReference, IJSObjectReference {
+        TResult InvokeUnmarshalled<T0, T1, T2, TResult>(string identifier, T0 arg0, T1 arg1, T2 arg2);
+        TResult InvokeUnmarshalled<T0, T1, TResult>(string identifier, T0 arg0, T1 arg1);
+        TResult InvokeUnmarshalled<T0, TResult>(string identifier, T0 arg0);
+        TResult InvokeUnmarshalled<TResult>(string identifier);
+    }
-    public class JSInProcessObjectReference : JSObjectReference {
 {
-        public TValue Invoke<TValue>(string identifier, params object[] args);

-    }
+    public static class JSInProcessObjectReferenceExtensions {
+        public static void InvokeVoid(this IJSInProcessObjectReference jsObjectReference, string identifier, params object[] args);
+    }
-    public class JSObjectReference : IAsyncDisposable {
 {
-        public ValueTask DisposeAsync();

-        public ValueTask<TValue> InvokeAsync<TValue>(string identifier, params object[] args);

-        public ValueTask<TValue> InvokeAsync<TValue>(string identifier, CancellationToken cancellationToken, params object[] args);

-        public ValueTask InvokeVoidAsync(string identifier, params object[] args);

-        protected void ThrowIfDisposed();

-    }
+    public static class JSObjectReferenceExtensions {
+        public static ValueTask<TValue> InvokeAsync<TValue>(this IJSObjectReference jsObjectReference, string identifier, params object[] args);
+        public static ValueTask<TValue> InvokeAsync<TValue>(this IJSObjectReference jsObjectReference, string identifier, CancellationToken cancellationToken, params object[] args);
+        public static ValueTask<TValue> InvokeAsync<TValue>(this IJSObjectReference jsObjectReference, string identifier, TimeSpan timeout, params object[] args);
+        public static ValueTask InvokeVoidAsync(this IJSObjectReference jsObjectReference, string identifier, params object[] args);
+        public static ValueTask InvokeVoidAsync(this IJSObjectReference jsObjectReference, string identifier, CancellationToken cancellationToken, params object[] args);
+        public static ValueTask InvokeVoidAsync(this IJSObjectReference jsObjectReference, string identifier, TimeSpan timeout, params object[] args);
+    }
     public abstract class JSRuntime : IJSRuntime {
-        protected static JSCallResultType ResultTypeFromGeneric<TResult>();

     }
 }
```

