# .NET 6.0.0 Preview 4 - May 25, 2021

The .NET 6.0.0 Preview 4 and .NET SDK 6.0.100-preview.4.21255.9 releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

## What's new in .NET 6 Preview 4

.NET 6 is the next major release of .NET following .NET 5.0. You can see some of the new features available with .NET 6 Preview 4 at [dotnet/core #6098](https://github.com/dotnet/core/issues/6098).

See the [.NET][dotnet-blog], [ASP.NET Core][aspnet-blog], [Entity Framework Core][ef-blog] and [.NET MAUI][maui-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 4. 

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-Arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [Arm64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz]  \| [Arm64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [Arm64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [Arm64][dotnet-runtime-osx-arm64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [Arm64][aspnetcore-runtime-osx-arm64.tar.gz]  | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](6.0.0-preview.4-install-instructions.md) | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz] \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup>  \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.100-preview.4.21255.9
```

### .NET Multi-Platform App UI Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET Multi-platform App UI](https://github.com/dotnet/maui). See [dotnet/net6-mobile-samples](https://github.com/dotnet/net6-mobile-samples) for additional setup instructions and sample projects you can run today.

|           | Android SDK Installer                        | iOS SDK Installer                 | Mac Catalyst SDK Installer                 | Mac Cocoa SDK Installer |
| --------- | :------------------------------------------:     | :----------------------:                 | :----------------------: | :----------------------: |
| Windows   | [x64][android-win] | [x64][ios-win]  | |
| macOS   | [x64][android-mac] | [x64][ios-mac]  | [x64][maccatalyst-mac]  | [x64][maccocoa-mac]  |

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.


## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples


## Visual Studio Compatibility

You need [Visual Studio 16.10](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. 

## Notable Changes
.NET 6.0.100-preview4 SDK release carries following new changes:

* [Add up to date check command](https://github.com/dotnet/sdk/pull/16141)
    `dotnet sdk check`
* [Converting to use System.CommandLine](https://github.com/dotnet/sdk/pull/14379)
* [Add --use-current-runtime option](https://github.com/dotnet/sdk/pull/14093)
* Support for installing [workloads](https://github.com/dotnet/designs/blob/main/accepted/2020/workloads/workloads.md) via CLI
    More documentation coming soon


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6295](https://github.com/dotnet/core/issues/6295) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/preview/6.0.0-preview.4.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.4-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6-preview-4/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-6-preview-4
[maui-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-maui-preview-4/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-6-0-preview-4-performance-edition
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview3+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview3+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview3+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview3+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A6.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A6.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A6.0.1xx
[linux-packages]: 6.0.0-preview.4-install-instructions.md


[//]: # ( Runtime 6.0.0-preview.4.21253.7)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ef4107cb-7f83-4049-8ffb-abb57eca3eba/5b293d0a78a7502098d82bc8cf7fb3ac/dotnet-runtime-6.0.0-preview.4.21253.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b4c1b7bc-22ef-4c03-8bcd-e93c54f2d535/5b697fd959e80c67bb92ce210436c587/dotnet-runtime-6.0.0-preview.4.21253.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f979a82e-ee67-466b-ae95-39014e253007/8a22e3388b8b7fa03d34ae694288abb9/dotnet-runtime-6.0.0-preview.4.21253.7-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b8a735a-6d7a-461c-9ddf-436444d81eeb/ef59b5a55b257ce800e3d537e500bf36/dotnet-runtime-6.0.0-preview.4.21253.7-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/01271d51-222b-4dd9-ac04-ef08781a8d61/b47a41c512e03b97df2e108667cc2004/dotnet-runtime-6.0.0-preview.4.21253.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ba1fca18-cb33-4eb2-a7d3-770331f3fadc/02b0897fe253e3ecb35419c33e985f85/dotnet-runtime-6.0.0-preview.4.21253.7-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fb84fa05-f898-4fa3-b6af-49dd6218fe2a/208ef70454ddebee075044b8e924200f/dotnet-runtime-6.0.0-preview.4.21253.7-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/be13fe16-ecd0-4704-bda6-3a0758bfa3ef/658adf39561a6f711b5dc313ad540d50/dotnet-runtime-6.0.0-preview.4.21253.7-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bab80210-ac54-44fa-bf41-7474c6371cf2/eadcd657b93e347d08bc33c59bd60835/dotnet-runtime-6.0.0-preview.4.21253.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/120689aa-0443-4546-bf0f-49811528d64d/247a950a605bd0cc1a6ae2262898b1d8/dotnet-runtime-6.0.0-preview.4.21253.7-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/8572a5bd-c181-4cd8-b4b5-2b540abb00f7/83e09af677e700938e5ab6fcd2766667/dotnet-runtime-6.0.0-preview.4.21253.7-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/27087b99-d8db-4ce0-81c4-83df88023116/1b97ed48a61e7502d546a68d7c2db300/dotnet-runtime-6.0.0-preview.4.21253.7-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4da29c93-2f04-4c51-9bd2-920c455a6379/b9a822a68b93f234d818863d83c8b02f/dotnet-runtime-6.0.0-preview.4.21253.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/686f3a1d-8737-47c3-8b7d-c6270833cedc/42e66fda0bd3d34f3d309ff0b88c4733/dotnet-runtime-6.0.0-preview.4.21253.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0315d2cf-60da-4952-9c12-7ee35069cc79/b49514346b0cd58a2242feb74d54cb81/dotnet-runtime-6.0.0-preview.4.21253.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9875ad23-f779-4ba2-bada-ea5296d303ce/d74a18d7a72131b66c355165a47d3870/dotnet-runtime-6.0.0-preview.4.21253.7-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0-preview.4.21254.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b7ac086b-6a8d-4de1-bec1-d7d4a2e58377/bc2b44c2613b8e7b6ad5b35f9685d7af/windowsdesktop-runtime-6.0.0-preview.4.21254.5-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/dbef10d0-2761-4c02-804d-9ef4b03abcd0/48ebf973c0edad04bf6dce60a256f3fa/windowsdesktop-runtime-6.0.0-preview.4.21254.5-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f9d240ba-00d1-40c3-b338-68854dca2d69/95ec529098d264c9eb1a487f3db46010/windowsdesktop-runtime-6.0.0-preview.4.21254.5-win-x86.exe

[//]: # ( ASP 6.0.0-preview.4.21253.5)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3b12a09-004a-4709-acd5-93f0dfb90821/18e612d56b8c808d98a44b47f29e173d/aspnetcore-runtime-6.0.0-preview.4.21253.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3ae5046-1b5e-490b-846c-5605cdb128cc/7de3931963ca6f84c8e7fec74ca2d391/aspnetcore-runtime-6.0.0-preview.4.21253.5-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7cee89b6-67f3-449f-8988-a21726787100/864544e43715f8aec41e003e69122bd3/aspnetcore-runtime-6.0.0-preview.4.21253.5-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b9d13cc4-9577-45ad-8771-87587dc068cc/401c99b78de4cb733b4a0da9d0b82c26/aspnetcore-runtime-6.0.0-preview.4.21253.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8bc76f9a-faa2-4295-b5f5-113bda7a575b/37dc0bb7dcfe0039e43b24c66865af7a/aspnetcore-runtime-6.0.0-preview.4.21253.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/de01b1f0-784a-44b8-8f79-1f98394565ef/30b1afd3975978cf034861a7fccc0cdb/aspnetcore-runtime-6.0.0-preview.4.21253.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/311e99df-af85-46bd-b4b5-5f138ed77262/b1c20f2d94ac22825e3045e9f2744989/aspnetcore-runtime-6.0.0-preview.4.21253.5-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77c4b5c4-5ca3-4095-97c9-b2d1bc6b333b/b5b967e112f0bfe7a78d450cc18e361c/aspnetcore-runtime-6.0.0-preview.4.21253.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e7d68b87-892d-4089-b0ad-161c60617ca3/559271935acbe8222a78804aa7b7f6ce/aspnetcore-runtime-6.0.0-preview.4.21253.5-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d27bd776-0bb1-4697-b5c5-619c3b7812b4/05c28a15a0d2e40ac38d80c5a10eca0c/aspnetcore-runtime-6.0.0-preview.4.21253.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ee51827f-2eae-4a4a-80a4-239395caa988/a8f9982a0b28959ca5d4a3cb0584965e/aspnetcore-runtime-6.0.0-preview.4.21253.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1c64a041-0eee-44a0-8e7c-60deab05802f/ece6fa09c06215bfe1d514b9121b3135/aspnetcore-runtime-6.0.0-preview.4.21253.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6e269018-0cd8-4518-abd4-811fbb64b086/1b8ffb43a306b41fc4ddf1e87e4e2c57/aspnetcore-runtime-6.0.0-preview.4.21253.5-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/2728666c-860b-4a78-ba42-8ec7b2167d42/72b9c82be95a013e2c15a1fc182e2fc4/dotnet-hosting-6.0.0-preview.4.21253.5-win.exe

[//]: # ( SDK 6.0.100-preview.4.21255.9 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33688994-4547-4f42-b078-2da4c0396fa9/a5904769ea3badfb4758900d16672e4c/dotnet-sdk-6.0.100-preview.4.21255.9-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a0e30f5-9112-45f9-80b0-a5156056907a/7b526737d2907cc9f7c04f9e6b83b9ab/dotnet-sdk-6.0.100-preview.4.21255.9-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af1deca4-59c9-4937-9fa4-94e4bd1bc219/d09f40ebec7acb0c13486de25fd8a3f9/dotnet-sdk-6.0.100-preview.4.21255.9-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43369da5-8224-4521-b016-c80aad952c3b/55c0d35581c09c3e9c8baa5030032fb6/dotnet-sdk-6.0.100-preview.4.21255.9-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d0924ab-30c1-419a-9d0a-2834082f8249/697944b028b6637529854dc17334e7f8/dotnet-sdk-6.0.100-preview.4.21255.9-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5c00d7a-e1c8-494a-a88b-9ed1dc62249e/8438122af4fd928900a0ebf129c6c1d6/dotnet-sdk-6.0.100-preview.4.21255.9-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7211a88f-9174-4898-b993-524bd9be0ccd/b9514532ce0a48b5391563416d00b12e/dotnet-sdk-6.0.100-preview.4.21255.9-linux-x64.zip
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bd11a494-6dc8-4b74-8980-f784593a66e9/13703559437ed332269bda08e90a2f40/dotnet-sdk-6.0.100-preview.4.21255.9-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a033783b-6a59-4ed8-972d-70859ec974d7/208ed46fef3ad3fead8657db0f340ded/dotnet-sdk-6.0.100-preview.4.21255.9-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4bf47b4e-f856-4628-a713-8f2a400a38a0/02bd28f2020d9149ff5a6f7251f193fb/dotnet-sdk-6.0.100-preview.4.21255.9-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1080865-bad2-4478-8a9e-e1bb12bc2686/29674b3439940636a55447edb620b6bb/dotnet-sdk-6.0.100-preview.4.21255.9-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/bedc0958-6615-46e9-ba76-5e9b689c774d/3d9edee2f2005010e562a3e823503f27/dotnet-sdk-6.0.100-preview.4.21255.9-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/823f7ab3-4174-4fd2-9543-c5b8cc8f82e5/ba84f35366686f1a72df1cc228b0cfa7/dotnet-sdk-6.0.100-preview.4.21255.9-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6938823e-9241-4ba2-bb65-dfc154f36fb9/ad7d7beb47384a7ca8d49475f30688d4/dotnet-sdk-6.0.100-preview.4.21255.9-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f593336e-dc82-4440-932b-cbcd7713fb3e/da7cf8215225a99929192c406c897ce6/dotnet-sdk-6.0.100-preview.4.21255.9-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5f51dc81-e293-4814-9a37-8c68bd3ec9a4/b9cf301f425651518a1dd00b53e8cf39/dotnet-sdk-6.0.100-preview.4.21255.9-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0b76b4ce-064d-49ac-85eb-1daaf34942d7/142bce0e13b08eebe07c4d4e07819350/dotnet-sdk-6.0.100-preview.4.21255.9-win-x86.zip

[android-mac]: https://dl.internalx.com/vsts-devdiv/Xamarin.Android/public/net6/4716293/6.0.1xx-preview4/a09fa1e93a94c7ee9f759c840ed7a5829d0e9152/Microsoft.NET.Workload.Android-11.0.200-preview.4.245.pkg
[android-win]: https://dl.internalx.com/vsts-devdiv/Xamarin.Android/public/net6/4716293/6.0.1xx-preview4/a09fa1e93a94c7ee9f759c840ed7a5829d0e9152/Microsoft.NET.Workload.Android.11.0.200.245.msi
[ios-mac]: https://bosstoragemirror.azureedge.net/wrench/6.0.1xx-preview4/05cf7f73ec60d360f1a6391f1c047d4e8957203a/4731910/package/notarized/Microsoft.iOS.Bundle.14.5.100-preview.4.638.pkg
[ios-win]: https://bosstoragemirror.azureedge.net/wrench/6.0.1xx-preview4/05cf7f73ec60d360f1a6391f1c047d4e8957203a/4731910/package/Microsoft.NET.Workload.iOS.14.5.100-preview.4.638.msi
[maccatalyst-mac]: https://bosstoragemirror.azureedge.net/wrench/6.0.1xx-preview4/05cf7f73ec60d360f1a6391f1c047d4e8957203a/4731910/package/notarized/Microsoft.MacCatalyst.Bundle.14.5.100-preview.4.638.pkg
[maccocoa-mac]: https://bosstoragemirror.azureedge.net/wrench/6.0.1xx-preview4/05cf7f73ec60d360f1a6391f1c047d4e8957203a/4731910/package/notarized/Microsoft.macOS.Bundle.11.3.100-preview.4.638.pkg

[//]: # ( Symbols )
