# System.Text.Json.Serialization.Metadata

``` diff
+namespace System.Text.Json.Serialization.Metadata {
+    public static class JsonMetadataServices {
+        public static JsonConverter<bool> BooleanConverter { get; }
+        public static JsonConverter<byte[]> ByteArrayConverter { get; }
+        public static JsonConverter<byte> ByteConverter { get; }
+        public static JsonConverter<char> CharConverter { get; }
+        public static JsonConverter<DateTime> DateTimeConverter { get; }
+        public static JsonConverter<DateTimeOffset> DateTimeOffsetConverter { get; }
+        public static JsonConverter<decimal> DecimalConverter { get; }
+        public static JsonConverter<double> DoubleConverter { get; }
+        public static JsonConverter<Guid> GuidConverter { get; }
+        public static JsonConverter<short> Int16Converter { get; }
+        public static JsonConverter<int> Int32Converter { get; }
+        public static JsonConverter<long> Int64Converter { get; }
+        public static JsonConverter<object> ObjectConverter { get; }
+        public static JsonConverter<sbyte> SByteConverter { get; }
+        public static JsonConverter<float> SingleConverter { get; }
+        public static JsonConverter<string> StringConverter { get; }
+        public static JsonConverter<ushort> UInt16Converter { get; }
+        public static JsonConverter<uint> UInt32Converter { get; }
+        public static JsonConverter<ulong> UInt64Converter { get; }
+        public static JsonConverter<Uri> UriConverter { get; }
+        public static JsonConverter<Version> VersionConverter { get; }
+        public static JsonTypeInfo<TElement[]> CreateArrayInfo<TElement>(JsonSerializerOptions options, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling);
+        public static JsonTypeInfo<TCollection> CreateDictionaryInfo<TCollection, TKey, TValue>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo keyInfo, JsonTypeInfo valueInfo, JsonNumberHandling numberHandling) where TCollection : Dictionary<TKey, TValue>;
+        public static JsonTypeInfo<TCollection> CreateListInfo<TCollection, TElement>(JsonSerializerOptions options, Func<TCollection> createObjectFunc, JsonTypeInfo elementInfo, JsonNumberHandling numberHandling) where TCollection : List<TElement>;
+        public static JsonTypeInfo<T> CreateObjectInfo<T>();
+        public static JsonPropertyInfo CreatePropertyInfo<T>(JsonSerializerOptions options, bool isProperty, Type declaringType, JsonTypeInfo propertyTypeInfo, JsonConverter<T> converter, Func<object, T> getter, Action<object, T> setter, JsonIgnoreCondition ignoreCondition, JsonNumberHandling numberHandling, string propertyName, string jsonPropertyName);
+        public static JsonTypeInfo<T> CreateValueInfo<T>(JsonSerializerOptions options, JsonConverter converter);
+        public static JsonConverter<T> GetEnumConverter<T>(JsonSerializerOptions options) where T : struct;
+        public static JsonConverter<T?> GetNullableConverter<T>(JsonTypeInfo<T> underlyingTypeInfo) where T : struct;
+        public static void InitializeObjectInfo<T>(JsonTypeInfo<T> info, JsonSerializerOptions options, Func<T> createObjectFunc, Func<JsonSerializerContext, JsonPropertyInfo[]> propInitFunc, JsonNumberHandling numberHandling);
+    }
+    public abstract class JsonPropertyInfo
+    public class JsonTypeInfo {
+        public static readonly Type ObjectType;
+    }
+    public abstract class JsonTypeInfo<T> : JsonTypeInfo
+}
```

