# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
+    public sealed class Configuration : IConfiguration, IConfigurationBuilder, IConfigurationRoot {
+        public Configuration();
+        IDictionary<string, object> Microsoft.Extensions.Configuration.IConfigurationBuilder.Properties { get; }
+        IList<IConfigurationSource> Microsoft.Extensions.Configuration.IConfigurationBuilder.Sources { get; }
+        IEnumerable<IConfigurationProvider> Microsoft.Extensions.Configuration.IConfigurationRoot.Providers { get; }
+        public string this[string key] { get; set; }
+        public IEnumerable<IConfigurationSection> GetChildren();
+        public IConfigurationSection GetSection(string key);
+        IChangeToken Microsoft.Extensions.Configuration.IConfiguration.GetReloadToken();
+        IConfigurationBuilder Microsoft.Extensions.Configuration.IConfigurationBuilder.Add(IConfigurationSource source);
+        IConfigurationRoot Microsoft.Extensions.Configuration.IConfigurationBuilder.Build();
+        void Microsoft.Extensions.Configuration.IConfigurationRoot.Reload();
+    }
+    public sealed class ConfigureHostBuilder : IHostBuilder {
+        public IDictionary<object, object> Properties { get; }
+        public IHostBuilder ConfigureAppConfiguration(Action<HostBuilderContext, IConfigurationBuilder> configureDelegate);
+        public IHostBuilder ConfigureContainer<TContainerBuilder>(Action<HostBuilderContext, TContainerBuilder> configureDelegate);
+        public IHostBuilder ConfigureHostConfiguration(Action<IConfigurationBuilder> configureDelegate);
+        public IHostBuilder ConfigureServices(Action<HostBuilderContext, IServiceCollection> configureDelegate);
+        IHost Microsoft.Extensions.Hosting.IHostBuilder.Build();
+        public IHostBuilder UseServiceProviderFactory<TContainerBuilder>(IServiceProviderFactory<TContainerBuilder> factory);
+        public IHostBuilder UseServiceProviderFactory<TContainerBuilder>(Func<HostBuilderContext, IServiceProviderFactory<TContainerBuilder>> factory);
+    }
+    public sealed class ConfigureWebHostBuilder : IWebHostBuilder {
+        public IWebHostBuilder ConfigureAppConfiguration(Action<WebHostBuilderContext, IConfigurationBuilder> configureDelegate);
+        public IWebHostBuilder ConfigureServices(Action<WebHostBuilderContext, IServiceCollection> configureServices);
+        public IWebHostBuilder ConfigureServices(Action<IServiceCollection> configureServices);
+        public string GetSetting(string key);
+        IWebHost Microsoft.AspNetCore.Hosting.IWebHostBuilder.Build();
+        public IWebHostBuilder UseSetting(string key, string value);
+    }
+    public static class HttpLoggingBuilderExtensions {
+        public static IApplicationBuilder UseHttpLogging(this IApplicationBuilder app);
+    }
-    public sealed class MapActionEndpointConventionBuilder : IEndpointConventionBuilder {
 {
-        public void Add(Action<EndpointBuilder> convention);

-    }
-    public static class MapActionEndpointRouteBuilderExtensions {
 {
-        public static MapActionEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, Delegate action);

-        public static MapActionEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-        public static MapActionEndpointConventionBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-        public static MapActionEndpointConventionBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-        public static MapActionEndpointConventionBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, Delegate action);

-        public static MapActionEndpointConventionBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-        public static MapActionEndpointConventionBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-    }
+    public sealed class MinimalActionEndpointConventionBuilder : IEndpointConventionBuilder {
+        public void Add(Action<EndpointBuilder> convention);
+    }
+    public static class MinmalActionEndpointRouteBuilderExtensions {
+        public static MinimalActionEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, Delegate action);
+        public static MinimalActionEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);
+        public static MinimalActionEndpointConventionBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);
+        public static MinimalActionEndpointConventionBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);
+        public static MinimalActionEndpointConventionBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, Delegate action);
+        public static MinimalActionEndpointConventionBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);
+        public static MinimalActionEndpointConventionBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);
+    }
     public static class UseExtensions {
+        public static IApplicationBuilder Use(this IApplicationBuilder app, Func<HttpContext, RequestDelegate, Task> middleware);
     }
+    public sealed class WebApplication : IApplicationBuilder, IAsyncDisposable, IDisposable, IEndpointRouteBuilder, IHost {
+        public IConfiguration Configuration { get; }
+        public IWebHostEnvironment Environment { get; }
+        public IHostApplicationLifetime Lifetime { get; }
+        public ILogger Logger { get; }
+        IServiceProvider Microsoft.AspNetCore.Builder.IApplicationBuilder.ApplicationServices { get; set; }
+        IDictionary<string, object> Microsoft.AspNetCore.Builder.IApplicationBuilder.Properties { get; }
+        IFeatureCollection Microsoft.AspNetCore.Builder.IApplicationBuilder.ServerFeatures { get; }
+        ICollection<EndpointDataSource> Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.DataSources { get; }
+        IServiceProvider Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.ServiceProvider { get; }
+        public IServiceProvider Services { get; }
+        public ICollection<string> Urls { get; }
+        public static WebApplication Create(string[] args = null);
+        public static WebApplicationBuilder CreateBuilder(string[] args = null);
+        public ValueTask DisposeAsync();
+        RequestDelegate Microsoft.AspNetCore.Builder.IApplicationBuilder.Build();
+        IApplicationBuilder Microsoft.AspNetCore.Builder.IApplicationBuilder.New();
+        IApplicationBuilder Microsoft.AspNetCore.Builder.IApplicationBuilder.Use(Func<RequestDelegate, RequestDelegate> middleware);
+        IApplicationBuilder Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.CreateApplicationBuilder();
+        public void Run(string url = null);
+        public Task RunAsync(string url = null);
+        public Task StartAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public Task StopAsync(CancellationToken cancellationToken = default(CancellationToken));
+        void System.IDisposable.Dispose();
+    }
+    public sealed class WebApplicationBuilder {
+        public Configuration Configuration { get; }
+        public IWebHostEnvironment Environment { get; }
+        public ConfigureHostBuilder Host { get; }
+        public ILoggingBuilder Logging { get; }
+        public IServiceCollection Services { get; }
+        public ConfigureWebHostBuilder WebHost { get; }
+        public WebApplication Build();
+    }
 }
```

