# Microsoft.AspNetCore.Connections

``` diff
 namespace Microsoft.AspNetCore.Connections {
+    public interface IMultiplexedConnectionBuilder {
+        IServiceProvider ApplicationServices { get; }
+        MultiplexedConnectionDelegate Build();
+        IMultiplexedConnectionBuilder Use(Func<MultiplexedConnectionDelegate, MultiplexedConnectionDelegate> middleware);
+    }
+    public interface IMultiplexedConnectionFactory {
+        ValueTask<MultiplexedConnectionContext> ConnectAsync(EndPoint endpoint, IFeatureCollection features = null, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public interface IMultiplexedConnectionListener : IAsyncDisposable {
+        EndPoint EndPoint { get; }
+        ValueTask<MultiplexedConnectionContext> AcceptAsync(IFeatureCollection features = null, CancellationToken cancellationToken = default(CancellationToken));
+        ValueTask UnbindAsync(CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public interface IMultiplexedConnectionListenerFactory {
+        ValueTask<IMultiplexedConnectionListener> BindAsync(EndPoint endpoint, IFeatureCollection features = null, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public class MultiplexedConnectionBuilder : IMultiplexedConnectionBuilder {
+        public MultiplexedConnectionBuilder(IServiceProvider applicationServices);
+        public IServiceProvider ApplicationServices { get; }
+        public MultiplexedConnectionDelegate Build();
+        public IMultiplexedConnectionBuilder Use(Func<MultiplexedConnectionDelegate, MultiplexedConnectionDelegate> middleware);
+    }
+    public abstract class MultiplexedConnectionContext : BaseConnectionContext, IAsyncDisposable {
+        protected MultiplexedConnectionContext();
+        public abstract ValueTask<ConnectionContext> AcceptAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public abstract ValueTask<ConnectionContext> ConnectAsync(IFeatureCollection features = null, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public delegate Task MultiplexedConnectionDelegate(MultiplexedConnectionContext connection);
 }
```

