# .NET Core SDK 1.0.4 with .NET Core 1.0.5 & 1.1.2 

The installers and binary archives on this page include .NET Core SDK 1.0.4, .NET Core 1.0.5 and .NET Core 1.1.2. Runtime-only installers and binaries can be found on the .NET Core [1.0.5](1.0.5-download.md) and [1.1.2](1.1.2-download.md) installer pages.

|                         | SDK Installer                                                                                                        | SDK Binaries                                             |
| ----------------------- | :----------------------------------------------:                                                                     | :----------------------------------------------:         |
| Windows                 | [32-bit](https://download.microsoft.com/download/B/9/F/B9F1AF57-C14A-4670-9973-CDF47209B5BF/dotnet-dev-win-x86.1.0.4.exe) / [64-bit](https://download.microsoft.com/download/B/9/F/B9F1AF57-C14A-4670-9973-CDF47209B5BF/dotnet-dev-win-x64.1.0.4.exe)  | [32-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-win-x86.1.0.4.zip) / [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-win-x64.1.0.4.zip)
| macOS                   | [64-bit](https://download.microsoft.com/download/B/9/F/B9F1AF57-C14A-4670-9973-CDF47209B5BF/dotnet-dev-osx-x64.1.0.4.pkg)                                                             | [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-osx-x64.1.0.4.tar.gz) |
| CentOS 7.1              | -                                                                                                                    | [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-centos-x64.1.0.4.tar.gz) |
| Debian 8                | -                                                                                                                    | [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-debian-x64.1.0.4.tar.gz) |
| Fedora 24               | -                                                                                                                    | [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-fedora.24-x64.1.0.4.tar.gz) |
| OpenSUSE 42.1           | -                                                                                                                    | [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-opensuse.42.1-x64.1.0.4.tar.gz) |
| Ubuntu 14.04            |[64-bit](https://download.microsoft.com/download/B/9/F/B9F1AF57-C14A-4670-9973-CDF47209B5BF/dotnet-sdk-ubuntu-x64.1.0.4.deb)                                                              | [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-ubuntu-x64.1.0.4.tar.gz) |
| Ubuntu 16.04            |[64-bit](https://download.microsoft.com/download/B/9/F/B9F1AF57-C14A-4670-9973-CDF47209B5BF/dotnet-sdk-ubuntu.16.04-x64.1.0.4.deb)                                                              | [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-ubuntu.16.04-x64.1.0.4.tar.gz) |
| Ubuntu 16.10            |[64-bit](https://download.microsoft.com/download/B/9/F/B9F1AF57-C14A-4670-9973-CDF47209B5BF/dotnet-sdk-ubuntu.16.10-x64.1.0.4.deb)                                                              | [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-ubuntu.16.10-x64.1.0.4.tar.gz) |
| RHEL 7                  | -                                                                                                                    | [64-bit](https://download.microsoft.com/download/E/7/8/E782433E-7737-4E6C-BFBF-290A0A81C3D7/dotnet-dev-rhel-x64.1.0.4.tar.gz) |

## Installation from a binary archive

When using binary archives to install, we recommend the contents be extracted to `/opt/dotnet` and a symbolic link created for `dotnet`. If an earlier release of .NET Core is already installed, the directory and symbolic link may already exist. Ubuntu and Mint users should follow the instructions in the Ubuntu Installation section below.

```bash
sudo mkdir -p /opt/dotnet
sudo tar zxf [tar.gz filename] -C /opt/dotnet
sudo ln -s /opt/dotnet/dotnet /usr/local/bin
```

## Ubuntu installation

```
dotnet-sdk-ubuntu-x64.1.0.4.deb
```

### Set up package source

The first step is to establish the source feed for the package manager. This is only needed if you have not previously set up the source or if you are installing for the first time.

#### Ubuntu 14.04 and Linux Mint 17

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ trusty main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
sudo apt-get install dotnet-dev-1.0.4

```

Installed packages

```
dotnet-sdk-ubuntu-x64.1.0.4.deb
```

#### Ubuntu 16.04 and Linux Mint 18

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ xenial main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
sudo apt-get install dotnet-dev-1.0.4
```

Installed packages

```
sudo apt-get install dotnet-dev-1.0.4
```

#### Ubuntu 16.10

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ yakkety main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
sudo apt-get install dotnet-dev-1.0.4
```

Installed packages

```
sudo apt-get install dotnet-dev-1.0.4
```

## Windows Server Hosting
If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime. You can download the [Windows (Server Hosting) installer](https://go.microsoft.com/fwlink/?linkid=848766) and run the following command from an Administrator command prompt:

``DotNetCore.1.0.5_1.1.2-WindowsHosting.exe OPT_INSTALL_LTS_REDIST=0 OPT_INSTALL_FTS_REDIST=0``

The above mentoned command will install the ASP.NET Core Module (ANCM) only. Not specifying the OPT_INSTALL_LTS_REDIST or OPT_INSTALL_FTS_REDIST values will default those to 1 and will pull in the LTS or FTS as well.