# .NET Core 2.0.5

.NET Core 2.0.5 comprises:

* .NET Core Runtime 2.0.5
* .NET Core SDK 2.1.4

|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: |
| Windows | [32-bit](https://download.microsoft.com/download/1/1/5/115B762D-2B41-4AF3-9A63-92D9680B9409/dotnet-sdk-2.1.4-win-x86.exe) / [64-bit](https://download.microsoft.com/download/1/1/5/115B762D-2B41-4AF3-9A63-92D9680B9409/dotnet-sdk-2.1.4-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/1/1/5/115B762D-2B41-4AF3-9A63-92D9680B9409/dotnet-sdk-2.1.4-win-x86.zip) / [64-bit](https://download.microsoft.com/download/1/1/5/115B762D-2B41-4AF3-9A63-92D9680B9409/dotnet-sdk-2.1.4-win-x64.zip) | [32-bit](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/dotnet-runtime-2.0.5-win-x86.exe) / [64-bit](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/dotnet-runtime-2.0.5-win-x64.exe) | [32-bit](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/dotnet-runtime-2.0.5-win-x86.zip) / [64-bit](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/dotnet-runtime-2.0.5-win-x64.zip) |
| macOS   | [64-bit](https://download.microsoft.com/download/1/1/5/115B762D-2B41-4AF3-9A63-92D9680B9409/dotnet-sdk-2.1.4-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/1/1/5/115B762D-2B41-4AF3-9A63-92D9680B9409/dotnet-sdk-2.1.4-osx-x64.tar.gz)| [64-bit](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/dotnet-runtime-2.0.5-osx-x64.pkg)      | [64-bit](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/dotnet-runtime-2.0.5-osx-x64.tar.gz)   |
| Linux * | See installations steps below                         | [64-bit](https://download.microsoft.com/download/1/1/5/115B762D-2B41-4AF3-9A63-92D9680B9409/dotnet-sdk-2.1.4-linux-x64.tar.gz)     | -                                                                  | [64-bit](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/dotnet-runtime-2.0.5-linux-x64.tar.gz) |

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.5-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.4-sdk-sha.txt)

**Debug Symbols**
* [Shared Framework](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/corefx-2.0.5-symbols.zip)
* [Runtime](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/coreclr-2.0.5-symbols.zip)
* [Core-Setup](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/core-setup-2.0.5-symbols.zip)

## Docker

Images for .NET Core 2.0.5 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).
## Installing .NET Core on Linux

### Uninstall any Preview versions

If you have .NET Core Previews or daily builds installed, these to be removed before attempting to install .NET Core 2.0. This can be done by running a command such as the following.

`sudo apt remove dotnet-dev-2.0.0-preview2-006497`

### Ubuntu and Debian based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts. To begin, ensure that `apt-transport-https` is installed using `sudo apt-get install apt-transport-https`.

#### Ubuntu 17.10

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/17.10/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```

#### Ubuntu 17.04

**Note:** [Ubuntu 17.04 will reach end-of-life January 13, 2018](https://lists.ubuntu.com/archives/ubuntu-announce/2018-January.txt).

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/17.04/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```

#### Ubuntu 16.04

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/16.04/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```
#### Ubuntu 14.04

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/14.04/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```

#### Debian 8

```bash
wget -qO- https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.asc.gpg
sudo mv microsoft.asc.gpg /etc/apt/trusted.gpg.d/
wget -q https://packages.microsoft.com/config/debian/8/prod.list
sudo mv prod.list /etc/apt/sources.list.d/microsoft-prod.list
 ```

#### Debian 9

```bash
wget -qO- https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.asc.gpg
sudo mv microsoft.asc.gpg /etc/apt/trusted.gpg.d/
wget -q https://packages.microsoft.com/config/debian/9/prod.list
sudo mv prod.list /etc/apt/sources.list.d/microsoft-prod.list
```

Then, update the package cache and install the .NET Core SDK, which includes the .NET Core Runtime.

```bash
sudo apt-get update
sudo apt-get install dotnet-sdk-2.1.4
```

### .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.0.5` using your package manager.

### RHEL and Fedora based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Red Hat, Fedora, CentOS, Oracle Linux

```bash
sudo rpm -Uvh https://packages.microsoft.com/config/rhel/7/packages-microsoft-prod.rpm
```

#### SUSE Enterprise Linux, OpenSUSE

SUSE Enterprise Linux

```bash
sudo rpm -Uvh https://packages.microsoft.com/config/sles/12/packages-microsoft-prod.rpm
```

OpenSUSE

**Note:** [OpenSUSE 42.2 will reach end-of-life January 26, 2018](https://en.opensuse.org/Lifetime).

```bash
sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
wget -qO- https://packages.microsoft.com/config/opensuse/42.2/prod.repo
sudo mv prod.repo /etc/zypp/repos.d/microsoft-prod.repo
```

Then, update the package cache and install .NET Core SDK, which includes the .NET Core Runtime

#### Fedora, CentOS and Oracle Linux

```bash
sudo yum update
sudo yum install dotnet-sdk-2.1.4
```

#### SUSE Enterprise Linux and OpenSUSE

```bash
sudo zypper update
sudo zypper install dotnet-sdk-2.1.4
```

**Note:** When installing the SDK, SUSE and OpenSUSE may report that nothing provides libcurl. libcurl should already be installed on supported versions of both distros. Run zypper search libcurl to confirm. The error will present 2 "solutions". Choose "Solution 2" to continue installing .NET Core.

### .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.0.5` using your package manager.

## Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## Server Hosting

If you are looking to host stand-alone applications on Servers, the appropriate components can be installed

### Windows

Windows Server Hosting installer will install the ASP.NET Core Module for IIS.

[DotNetCore.2.0.5-WindowsHosting.exe](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/DotNetCore.2.0.5-WindowsHosting.exe)

### Linux

On supported Linux systems, register the Microsoft Product feed as described above and install `dotnet-hosting-2.0.5` using your package manager.

### ASP.NET Runtime Core Package Store

The Runtime Package Store is installed by the .NET Core SDK and the Server Hosting installers. If you need to install the Runtime Package Store separately, the following can be used.

* [AspNetCore.2.0.5.RuntimePackageStore_x64.exe](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/AspNetCore.2.0.5.RuntimePackageStore_x64.exe)
* [AspNetCore.2.0.5.RuntimePackageStore_x86.exe](https://download.microsoft.com/download/1/1/0/11046135-4207-40D3-A795-13ECEA741B32/AspNetCore.2.0.5.RuntimePackageStore_x86.exe)
