# .NET Core 2.1.1

.NET Core 2.1.1 comprises:

* .NET Core Runtime 2.1.1
* .NET Core SDK 2.1.301

|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   | ASPNET Core Runtime                                                   |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: | :------------------------------------------------------:|
| Windows | [32-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-win-x86.exe) / [64-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-win-x86.zip) / [64-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-win-x64.zip) | [32-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-win-x86.exe) / [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-win-x64.exe) | [32-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-win-x86.zip) / [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-win-x64.zip) | - |
| macOS   | [64-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-osx-x64.tar.gz)| [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-osx-x64.pkg)      | [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-osx-x64.tar.gz)   | - |
| Linux (for glibc based OS) | See installations steps below<sup>1</sup>  | [64-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-linux-x64.tar.gz)     | -                                                                  | [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-linux-x64.tar.gz) | [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/aspnetcore-runtime-2.1.1-linux-x64.tar.gz)
| Linux (for musl based OS, such as Alpine)   | -  | [64-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-linux-musl-x64.tar.gz)|  -    | [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-linux-musl-x64.tar.gz) | [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/aspnetcore-runtime-2.1.1-linux-musl-x64.tar.gz) |
| Linux ARM | -  | [32-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-linux-arm.tar.gz) / [64-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-linux-arm64.tar.gz)|  -    | [32-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-linux-arm.tar.gz) / [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-linux-arm64.tar.gz)   | [32-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/aspnetcore-runtime-2.1.1-linux-arm.tar.gz) |
| RHEL6 | - | [64-bit](https://download.microsoft.com/download/D/0/4/D04C5489-278D-4C11-9BD3-6128472A7626/dotnet-sdk-2.1.301-rhel.6-x64.tar.gz)     | -  | [64-bit](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-runtime-2.1.1-rhel.6-x64.tar.gz) | - |

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.1-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.301-sdk-sha.txt)

**Debug Symbols**
* [CoreCLR](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/coreclr-2.1.1-symbols.zip)
* [CoreFX](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/corefx-2.1.1-symbols.zip)
* [Core-Setup](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/core-setup-2.1.1-symbols.zip)

## Docker

Images for .NET Core 2.1.1 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).

## Installing .NET Core on Linux <sup>1</sup> 

### Uninstall Pre-release versions

If you have previous .NET Core Previews or daily builds installed, these should be removed before attempting to install .NET Core 2.1. This can be done by running a command such as the following.

```
sudo apt remove 2.1.300-preview2-008530
```

### Installation from a package manager

Instructions for installing using your package manager, such as apt or yum, can be found on the [dotnet-core](https://dotnet.microsoft.com/download) site.

### Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1.1` using your package manager.

## Server Hosting

If you are looking to host stand-alone apps on Servers, the following installers can be used on Windows and Linux systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:
[dotnet-hosting-2.1.1-win.exe](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/dotnet-hosting-2.1.1-win.exe)
This will install the ASP.NET Core Module for IIS

### Linux

On supported Linux systems, register the Microsoft Product feed as described above and install `dotnet-hosting-2.1.1` using your package manager.
This will also install the .NET Core Runtime and other required packages.

### ASP.NET Core Runtime

The ASP.NET Core Runtime is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the ASP.NET Runtime separately, the following can be used.

* [aspnetcore-runtime-2.1.1-win-x64.exe](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/aspnetcore-runtime-2.1.1-win-x64.exe)
* [aspnetcore-runtime-2.1.1-win-x86.exe](https://download.microsoft.com/download/9/3/E/93ED35C8-57B9-4D50-AE32-0330111B38E8/aspnetcore-runtime-2.1.1-win-x86.exe)

On Linux systems install `aspnetcore-runtime-2.1.1` using your package manager. This will install both the ASP.NET Core and .NET Core runtime components.
