
# .NET Releases

The .NET team releases new major versions of .NET annually, each November. Releases are either Long Term Support (LTS) or Current, the two .NET release types, and transition from full support, to maintenance and finally to end-of-life on a defined schedule, per [.NET release policies][policies]. .NET releases are [supported by Microsoft](microsoft-support.md) on [multiple operating systems](os-lifecycle-policy.md) and hardware architectures.

All .NET versions can be downloaded from the [.NET website](https://dotnet.microsoft.com/download/dotnet) or [.NET release notes](release-notes/README.md).

## Supported .NET versions

The following table lists in-support .NET releases.

|  Version  | Release Date | Support | Latest Patch Version | End of Support |
| :-- | :-- | :-- | :-- | :-- |
| [.NET 6](release-notes/6.0/README.md) | [November, 2021](https://devblogs.microsoft.com/dotnet/announcing-net-6-preview-3/) | [Preview][policies] | [6.0 Preview 3][6.0 Preview 3] | November, 2024 |
| [.NET 5](release-notes/5.0/README.md) | [November 10, 2020](https://devblogs.microsoft.com/dotnet/announcing-net-5-0/) | [Current][policies] | [5.0.7][5.0.7] | February, 2022 |
| [.NET Core 3.1](release-notes/3.1/README.md) | [December 3, 2019](https://devblogs.microsoft.com/dotnet/announcing-net-core-3-1/) | [LTS][policies] | [3.1.16][3.1.16] | December 3, 2022 |
| [.NET Core 2.1](release-notes/2.1/README.md) | [May 30, 2018](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-1/) | [LTS][policies] | [2.1.28][2.1.28] | [August 21, 2021](https://devblogs.microsoft.com/dotnet/net-core-2-1-will-reach-end-of-support-on-august-21-2021/) |

[6.0 Preview 3]: release-notes/6.0/preview/6.0.0-preview.3.md
[5.0.7]: release-notes/5.0/5.0.7/5.0.7.md
[3.1.16]: release-notes/3.1/3.1.16/3.1.16.md
[2.1.28]: release-notes/2.1/2.1.28/2.1.28.md

## End-of-life .NET versions

The following table lists end-of-life releases.

|  Version  |  Release Date | Support | Final Patch Version | End of Support |
| :-- | :-- | :-- | :-- | :-- |
| [.NET Core 3.0](release-notes/3.0/README.md) | [September 23, 2019](https://devblogs.microsoft.com/dotnet/announcing-net-core-3-0/) |  [Current][policies] | [3.0.3][3.0.3] | [March 3, 2020](https://devblogs.microsoft.com/dotnet/net-core-3-0-end-of-life/) |
| [.NET Core 2.2](release-notes/2.2/README.md) | [December 4th, 2018](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-2/) | [Current][policies] | [2.2.8][2.2.8] | [December 23, 2019](https://devblogs.microsoft.com/dotnet/net-core-2-2-will-reach-end-of-life-on-december-23-2019/) |
| [.NET Core 2.0](release-notes/2.0/README.md) | [August 14th, 2017](https://blogs.msdn.microsoft.com/dotnet/2017/08/14/announcing-net-core-2-0/) | [Current][policies] | [2.0.9][2.0.9] | [October 1, 2018](https://devblogs.microsoft.com/dotnet/net-core-2-0-will-reach-end-of-life-on-september-1-2018/) |
| [.NET Core 1.1](release-notes/1.1/README.md) | [November 16th, 2016](https://devblogs.microsoft.com/dotnet/announcing-net-core-1-1/) | [LTS][policies] | [1.1.13][1.1.13] | [June 27, 2019](https://devblogs.microsoft.com/dotnet/net-core-1-0-and-1-1-will-reach-end-of-life-on-june-27-2019/) |
| [.NET Core 1.0](release-notes/1.0/README.md) | [June 27th, 2016](https://devblogs.microsoft.com/dotnet/announcing-net-core-1-0/) | [LTS][policies] | [1.0.16][1.0.16] | [June 27, 2019](https://devblogs.microsoft.com/dotnet/net-core-1-0-and-1-1-will-reach-end-of-life-on-june-27-2019/) |

[3.0.3]: release-notes/3.0/3.0.3/3.0.3.md
[2.2.8]: release-notes/2.2/2.2.8/2.2.8.md
[2.0.9]: release-notes/2.0/2.0.9.md
[1.1.13]: release-notes/1.1/1.1.13/1.1.13.md
[1.0.16]: release-notes/1.0/1.0.16/1.0.16.md
[policies]: release-policies.md
