#[macro_use]
extern crate bencher;

use bencher::Bencher;
use tmf::unaligned_rw::{UnalignedRWMode, UnalignedReader, UnalignedWriter};
fn unaligned_read(bench: &mut Bencher) {
    bench.iter(|| {
        let mut reader = UnalignedReader::new(&CHANIGING_ALGHMENT_EXPECTED as &[u8]);
        for byte in 1..64 {
            assert!(
                reader
                    .read_unaligned(UnalignedRWMode::precision_bits(byte))
                    .unwrap()
                    == byte as u64
            );
        }
    })
}

fn unaligned_write(bench: &mut Bencher) {
    bench.iter(|| {
        let mut result = Vec::with_capacity(64);
        {
            let mut writter = UnalignedWriter::new(&mut result);
            for byte in 1..64 {
                writter
                    .write_unaligned(UnalignedRWMode::precision_bits(byte), byte as u64)
                    .unwrap();
            }
        }
        assert!(result == CHANIGING_ALGHMENT_EXPECTED);
    });
}
benchmark_group!(benches, unaligned_read, unaligned_write);
benchmark_main!(benches);
pub const CHANIGING_ALGHMENT_EXPECTED: [u8; 252] = [
    0b11001101, 0b00001010, 0b00110000, 0b01110000, 0b10000000, 0b01001000, 0b00010100, 0b00000010,
    0b11000000, 0b00110000, 0b00000001, 0b10100000, 0b00000111, 0b00000000, 0b00001111, 0b00000000,
    0b00010000, 0b00000000, 0b00001000, 0b10000000, 0b00000010, 0b01000000, 0b00000000, 0b01001100,
    0b00000000, 0b00000101, 0b00000000, 0b00000000, 0b00101010, 0b00000000, 0b00000000, 0b10110000,
    0b00000000, 0b00000001, 0b01110000, 0b00000000, 0b00000001, 0b10000000, 0b00000000, 0b00000000,
    0b11001000, 0b00000000, 0b00000000, 0b00110100, 0b00000000, 0b00000000, 0b00000110, 0b11000000,
    0b00000000, 0b00000000, 0b01110000, 0b00000000, 0b00000000, 0b00000011, 0b10100000, 0b00000000,
    0b00000000, 0b00001111, 0b00000000, 0b00000000, 0b00000000, 0b00011111, 0b00000000, 0b00000000,
    0b00000000, 0b00100000, 0b00000000, 0b00000000, 0b00000000, 0b00010000, 0b10000000, 0b00000000,
    0b00000000, 0b00000100, 0b01000000, 0b00000000, 0b00000000, 0b00000000, 0b10001100, 0b00000000,
    0b00000000, 0b00000000, 0b00001001, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b01001010,
    0b00000000, 0b00000000, 0b00000000, 0b00000001, 0b00110000, 0b00000000, 0b00000000, 0b00000000,
    0b00000010, 0b01110000, 0b00000000, 0b00000000, 0b00000000, 0b00000010, 0b10000000, 0b00000000,
    0b00000000, 0b00000000, 0b00000001, 0b01001000, 0b00000000, 0b00000000, 0b00000000, 0b00000000,
    0b01010100, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00001010, 0b11000000, 0b00000000,
    0b00000000, 0b00000000, 0b00000000, 0b10110000, 0b00000000, 0b00000000, 0b00000000, 0b00000000,
    0b00000101, 0b10100000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00010111, 0b00000000,
    0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00101111, 0b00000000, 0b00000000, 0b00000000,
    0b00000000, 0b00000000, 0b00110000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000,
    0b00011000, 0b10000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000110, 0b01000000,
    0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b11001100, 0b00000000, 0b00000000,
    0b00000000, 0b00000000, 0b00000000, 0b00001101, 0b00000000, 0b00000000, 0b00000000, 0b00000000,
    0b00000000, 0b00000000, 0b01101010, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000,
    0b00000001, 0b10110000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000011,
    0b01110000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000011, 0b10000000,
    0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000001, 0b11001000, 0b00000000,
    0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b01110100, 0b00000000, 0b00000000,
    0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00001110, 0b11000000, 0b00000000, 0b00000000,
    0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b11110000, 0b00000000, 0b00000000, 0b00000000,
    0b00000000, 0b00000000, 0b00000000, 0b00000111, 0b10100000, 0b00000000, 0b00000000, 0b00000000,
    0b00000000, 0b00000000, 0b00000000, 0b00011111, 0b00000000, 0b00000000, 0b00000000, 0b00000000,
    0b00000000, 0b00000000, 0b00000000, 0b00111111,
];
