/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	cephrookiov1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephBlockPools implements CephBlockPoolInterface
type FakeCephBlockPools struct {
	Fake *FakeCephV1
	ns   string
}

var cephblockpoolsResource = schema.GroupVersionResource{Group: "ceph.rook.io", Version: "v1", Resource: "cephblockpools"}

var cephblockpoolsKind = schema.GroupVersionKind{Group: "ceph.rook.io", Version: "v1", Kind: "CephBlockPool"}

// Get takes name of the cephBlockPool, and returns the corresponding cephBlockPool object, and an error if there is any.
func (c *FakeCephBlockPools) Get(name string, options v1.GetOptions) (result *cephrookiov1.CephBlockPool, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(cephblockpoolsResource, c.ns, name), &cephrookiov1.CephBlockPool{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephBlockPool), err
}

// List takes label and field selectors, and returns the list of CephBlockPools that match those selectors.
func (c *FakeCephBlockPools) List(opts v1.ListOptions) (result *cephrookiov1.CephBlockPoolList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(cephblockpoolsResource, cephblockpoolsKind, c.ns, opts), &cephrookiov1.CephBlockPoolList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &cephrookiov1.CephBlockPoolList{ListMeta: obj.(*cephrookiov1.CephBlockPoolList).ListMeta}
	for _, item := range obj.(*cephrookiov1.CephBlockPoolList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephBlockPools.
func (c *FakeCephBlockPools) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(cephblockpoolsResource, c.ns, opts))

}

// Create takes the representation of a cephBlockPool and creates it.  Returns the server's representation of the cephBlockPool, and an error, if there is any.
func (c *FakeCephBlockPools) Create(cephBlockPool *cephrookiov1.CephBlockPool) (result *cephrookiov1.CephBlockPool, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(cephblockpoolsResource, c.ns, cephBlockPool), &cephrookiov1.CephBlockPool{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephBlockPool), err
}

// Update takes the representation of a cephBlockPool and updates it. Returns the server's representation of the cephBlockPool, and an error, if there is any.
func (c *FakeCephBlockPools) Update(cephBlockPool *cephrookiov1.CephBlockPool) (result *cephrookiov1.CephBlockPool, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(cephblockpoolsResource, c.ns, cephBlockPool), &cephrookiov1.CephBlockPool{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephBlockPool), err
}

// Delete takes name of the cephBlockPool and deletes it. Returns an error if one occurs.
func (c *FakeCephBlockPools) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(cephblockpoolsResource, c.ns, name), &cephrookiov1.CephBlockPool{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephBlockPools) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(cephblockpoolsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &cephrookiov1.CephBlockPoolList{})
	return err
}

// Patch applies the patch and returns the patched cephBlockPool.
func (c *FakeCephBlockPools) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *cephrookiov1.CephBlockPool, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(cephblockpoolsResource, c.ns, name, data, subresources...), &cephrookiov1.CephBlockPool{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephBlockPool), err
}
