<div class="description actions comment">
    {{ Form::open(["url" => route("{$endpoint}.assign", $object)]) }}
    <table class="w50">
        <tr>
            <td class="small"> {{ trans_choice('ticket.tag',2) }}: </td>
            <td colspan="2"> <input id="tags" name="tags" value="{{$object->tagsString()}}"></td>
        </tr>
        @can("assignToTeam", $object)
            @include('components.assignTeamField', ["team" => $object->team])
        @endcan
        <tr>
        @can("assignToTeam", $object)
            <td>{{ __('ticket.assigned') }}:</td>
            <td>{{ Form::select('user_id', createSelectArray( App\User::all(),true), $object->user_id ) }}</td>
        @else
            @if( $object->team )
                <td>{{ __('ticket.assigned') }}:</td>
                <td>{{ Form::select('user_id', createSelectArray( $object->team->members, true), $object->user_id ) }}</td>
            @endif
        @endcan
        <td class="text-right"> <button class="uppercase ph4"> {{ __('ticket.assign') }}</button></td>
        </tr>
    </table>
    {{ Form::close() }}
</div>