// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package controlled_generation

import (
	"bytes"
	"testing"

	"github.com/GoogleCloudPlatform/golang-samples/internal/testutil"
)

func TestTextGeneration(t *testing.T) {
	tc := testutil.SystemTest(t)

	t.Setenv("GOOGLE_GENAI_USE_VERTEXAI", "1")
	t.Setenv("GOOGLE_CLOUD_LOCATION", "us-central1")
	t.Setenv("GOOGLE_CLOUD_PROJECT", tc.ProjectID)

	buf := new(bytes.Buffer)

	t.Run("generate with enum schema", func(t *testing.T) {
		buf.Reset()
		err := generateWithEnumSchema(buf)
		if err != nil {
			t.Fatalf("generateWithEnumSchema failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("generate with response schema", func(t *testing.T) {
		buf.Reset()
		err := generateWithRespSchema(buf)
		if err != nil {
			t.Fatalf("generateWithRespSchema failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("generate with response schema with nullable values", func(t *testing.T) {
		buf.Reset()
		err := generateWithNullables(buf)
		if err != nil {
			t.Fatalf("generateWithNullables failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("generate with response class schema", func(t *testing.T) {
		buf.Reset()
		err := generateWithClassSchema(buf)
		if err != nil {
			t.Fatalf("generateWithClassSchema failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("generate with response enum class schema", func(t *testing.T) {
		buf.Reset()
		err := generateWithEnumClassSchema(buf)
		if err != nil {
			t.Fatalf("generateWithEnumClassSchema failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("generate with nested class response schema", func(t *testing.T) {
		buf.Reset()
		err := generateWithNestedClassSchema(buf)
		if err != nil {
			t.Fatalf("generateWithNestedClassSchema failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})
}
