// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package count_tokens

import (
	"bytes"
	"testing"

	"github.com/GoogleCloudPlatform/golang-samples/internal/testutil"
)

func TestTextGeneration(t *testing.T) {
	tc := testutil.SystemTest(t)

	t.Setenv("GOOGLE_GENAI_USE_VERTEXAI", "1")
	t.Setenv("GOOGLE_CLOUD_LOCATION", "us-central1")
	t.Setenv("GOOGLE_CLOUD_PROJECT", tc.ProjectID)

	buf := new(bytes.Buffer)

	t.Run("generate with text prompt", func(t *testing.T) {
		buf.Reset()
		err := generateTextAndCount(buf)
		if err != nil {
			t.Fatalf("generateTextAndCount failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("count tokens with text input", func(t *testing.T) {
		buf.Reset()
		err := countWithTxt(buf)
		if err != nil {
			t.Fatalf("countWithTxt failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("count tokens with text and video inputs", func(t *testing.T) {
		buf.Reset()
		err := countWithTxtAndVid(buf)
		if err != nil {
			t.Fatalf("countWithTxtAndVid failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("compute tokens with text input", func(t *testing.T) {
		buf.Reset()
		err := computeWithTxt(buf)
		if err != nil {
			t.Fatalf("computeWithTxt failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("count local tokens with text input", func(t *testing.T) {
		buf.Reset()
		err := countTokenLocalWithTxt(buf)
		if err != nil {
			t.Fatalf("countTokenLocalWithTxt failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})

	t.Run("compute local tokens with text input", func(t *testing.T) {
		buf.Reset()
		err := countTokenLocalComputeWithTxt(buf)
		if err != nil {
			t.Fatalf("countTokenLocalComputeWithTxt failed: %v", err)
		}

		output := buf.String()
		if output == "" {
			t.Error("expected non-empty output, got empty")
		}
	})
}
