// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package main

// [START logging_list_sinks]
import (
	"context"
	"log"

	"google.golang.org/api/iterator"

	"cloud.google.com/go/logging/logadmin"
)

func listSinks(projectID string) ([]string, error) {
	ctx := context.Background()
	client, err := logadmin.NewClient(ctx, projectID)
	if err != nil {
		log.Fatalf("logadmin.NewClient: %v", err)
	}
	defer client.Close()

	var sinks []string
	it := client.Sinks(ctx)
	for {
		sink, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			return nil, err
		}
		sinks = append(sinks, sink.ID)
	}
	return sinks, nil
}

// [END logging_list_sinks]
