import _merge from 'merge';


/**
 * Recursively merge objects
 *
 * @param {Object} objects to merge
 * @return {Object} the merged objects
 */
export function merge(...params)  {
  return _merge.recursive(true, ...params);
}

/**
 * Returns an object with the skipped properties
 *
 * @param {Object} obj the object to skip properties from
 * @param {[String]} keys keys of the properties to skip
 * @return {Object} the object with the properties skipped
 */
export function skip(obj, keys) {
  const result = {};
  Object.keys(obj)
    .filter(key => !keys.includes(key))
    .forEach((key) => {
      result[key] = obj[key];
    });
  return result;
}

