/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.measurements;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.api.measurements.MetricMeasurementTransformer;
import metrics_influxdb.measurements.Measure;
import metrics_influxdb.measurements.Sender;

public class MeasurementReporter
extends ScheduledReporter {
    private final Sender sender;
    private final Clock clock;
    private Map<String, String> baseTags;
    private MetricMeasurementTransformer transformer;

    public MeasurementReporter(Sender sender, MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, Map<String, String> baseTags, MetricMeasurementTransformer transformer, ScheduledExecutorService executor) {
        super(registry, "measurement-reporter", filter, rateUnit, durationUnit, executor);
        this.baseTags = baseTags;
        this.sender = sender;
        this.clock = clock;
        this.transformer = transformer;
    }

    public MeasurementReporter(Sender sender, MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, Map<String, String> baseTags, MetricMeasurementTransformer transformer) {
        super(registry, "measurement-reporter", filter, rateUnit, durationUnit);
        this.baseTags = baseTags;
        this.sender = sender;
        this.clock = clock;
        this.transformer = transformer;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.getTime();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.sender.send(this.fromGauge(entry.getKey(), entry.getValue(), timestamp));
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.sender.send(this.fromCounter(entry.getKey(), (Counter)entry.getValue(), timestamp));
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.sender.send(this.fromHistogram(entry.getKey(), (Histogram)entry.getValue(), timestamp));
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.sender.send(this.fromMeter(entry.getKey(), (Meter)entry.getValue(), timestamp));
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.sender.send(this.fromTimer(entry.getKey(), (Timer)entry.getValue(), timestamp));
        }
        this.sender.flush();
    }

    private Measure fromTimer(String metricName, Timer t, long timestamp) {
        Snapshot snapshot = t.getSnapshot();
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.transformer.measurementName(metricName)).timestamp(timestamp).addTag(tags).addValue("count", snapshot.size()).addValue("min", this.convertDuration(snapshot.getMin())).addValue("max", this.convertDuration(snapshot.getMax())).addValue("mean", this.convertDuration(snapshot.getMean())).addValue("std-dev", this.convertDuration(snapshot.getStdDev())).addValue("50-percentile", this.convertDuration(snapshot.getMedian())).addValue("75-percentile", this.convertDuration(snapshot.get75thPercentile())).addValue("95-percentile", this.convertDuration(snapshot.get95thPercentile())).addValue("99-percentile", this.convertDuration(snapshot.get99thPercentile())).addValue("999-percentile", this.convertDuration(snapshot.get999thPercentile())).addValue("one-minute", this.convertRate(t.getOneMinuteRate())).addValue("five-minute", this.convertRate(t.getFiveMinuteRate())).addValue("fifteen-minute", this.convertRate(t.getFifteenMinuteRate())).addValue("mean-minute", this.convertRate(t.getMeanRate())).addValue("run-count", t.getCount());
        return measure;
    }

    private Measure fromMeter(String metricName, Meter mt, long timestamp) {
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.transformer.measurementName(metricName)).timestamp(timestamp).addTag(tags).addValue("count", mt.getCount()).addValue("one-minute", this.convertRate(mt.getOneMinuteRate())).addValue("five-minute", this.convertRate(mt.getFiveMinuteRate())).addValue("fifteen-minute", this.convertRate(mt.getFifteenMinuteRate())).addValue("mean-minute", this.convertRate(mt.getMeanRate()));
        return measure;
    }

    private Measure fromHistogram(String metricName, Histogram h, long timestamp) {
        Snapshot snapshot = h.getSnapshot();
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.transformer.measurementName(metricName)).timestamp(timestamp).addTag(tags).addValue("count", snapshot.size()).addValue("min", snapshot.getMin()).addValue("max", snapshot.getMax()).addValue("mean", snapshot.getMean()).addValue("std-dev", snapshot.getStdDev()).addValue("50-percentile", snapshot.getMedian()).addValue("75-percentile", snapshot.get75thPercentile()).addValue("95-percentile", snapshot.get95thPercentile()).addValue("99-percentile", snapshot.get99thPercentile()).addValue("999-percentile", snapshot.get999thPercentile()).addValue("run-count", h.getCount());
        return measure;
    }

    private Measure fromCounter(String metricName, Counter c, long timestamp) {
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.transformer.measurementName(metricName)).timestamp(timestamp).addTag(tags).addValue("count", c.getCount());
        return measure;
    }

    private Measure fromGauge(String metricName, Gauge g, long timestamp) {
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.transformer.measurementName(metricName)).timestamp(timestamp).addTag(tags);
        Object o = g.getValue();
        if (o == null) {
            return null;
        }
        if (o instanceof Long || o instanceof Integer) {
            long value = ((Number)o).longValue();
            measure.addValue("value", value);
        } else if (o instanceof Double) {
            Double d = (Double)o;
            if (d.isInfinite() || d.isNaN()) {
                return null;
            }
            measure.addValue("value", d);
        } else if (o instanceof Float) {
            Float f = (Float)o;
            if (f.isInfinite() || f.isNaN()) {
                return null;
            }
            measure.addValue("value", f.floatValue());
        } else {
            String value = "" + o;
            measure.addValue("value", value);
        }
        return measure;
    }
}

