/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.v08;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.v08.Influxdb;
import metrics_influxdb.v08.JsonBuilder;
import metrics_influxdb.v08.JsonBuilderDefault;

public class InfluxdbHttp
implements Influxdb {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public final URL url;
    public boolean debugJson = false;
    public JsonBuilder jsonBuilder = new JsonBuilderDefault();

    public static String toTimePrecision(TimeUnit t) {
        switch (t) {
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MICROSECONDS: {
                return "u";
            }
        }
        throw new IllegalArgumentException("time precision should be SECONDS or MILLISECONDS or MICROSECONDS");
    }

    public InfluxdbHttp(String host, int port, String database, String username, String password) throws Exception {
        this("http", host, port, "", database, username, password, TimeUnit.MILLISECONDS);
    }

    public InfluxdbHttp(String host, int port, String path, String database, String username, String password) throws Exception {
        this("http", host, port, path, database, username, password, TimeUnit.MILLISECONDS);
    }

    public InfluxdbHttp(String host, int port, String database, String username, String password, TimeUnit timePrecision) throws Exception {
        this("http", host, port, database, username, password, timePrecision);
    }

    public InfluxdbHttp(String scheme, String host, int port, String database, String username, String password, TimeUnit timePrecision) throws Exception {
        this(scheme, host, port, "", database, username, password, timePrecision);
    }

    public InfluxdbHttp(String scheme, String host, int port, String path, String database, String username, String password, TimeUnit timePrecision) throws Exception {
        this.url = new URL(scheme, host, port, path + "/db/" + database + "/series?u=" + URLEncoder.encode(username, UTF_8.name()) + "&p=" + password + "&time_precision=" + InfluxdbHttp.toTimePrecision(timePrecision));
    }

    @Override
    public boolean hasSeriesData() {
        return this.jsonBuilder.hasSeriesData();
    }

    @Override
    public long convertTimestamp(long timestamp) {
        return timestamp;
    }

    @Override
    public void resetRequest() {
        this.jsonBuilder.reset();
    }

    @Override
    public void appendSeries(String namePrefix, String name, String nameSuffix, String[] columns, Object[][] points) {
        this.jsonBuilder.appendSeries(namePrefix, name, nameSuffix, columns, points);
    }

    @Override
    public int sendRequest(boolean throwExc, boolean printJson) throws Exception {
        String json = this.jsonBuilder.toJsonString();
        if (printJson || this.debugJson) {
            System.err.println("----");
            System.err.println(json);
            System.err.println("----");
        }
        HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        OutputStream wr = con.getOutputStream();
        wr.write(json.getBytes(UTF_8));
        wr.flush();
        wr.close();
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            con.getInputStream().close();
        } else if (throwExc) {
            throw new IOException("Server returned HTTP response code: " + responseCode + "for URL: " + this.url + " with content :'" + con.getResponseMessage() + "'");
        }
        return responseCode;
    }
}

