/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.HttpInfluxdbProtocol;
import metrics_influxdb.InfluxdbProtocol;
import metrics_influxdb.InfluxdbReporter;
import metrics_influxdb.api.measurements.CategoriesMetricMeasurementTransformer;
import metrics_influxdb.api.measurements.MetricMeasurementTransformer;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrInfluxdbReporter
extends SolrMetricReporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String scheme = "http";
    private String host = null;
    private int port = -1;
    private String user = null;
    private String password = null;
    private String db = null;
    private int period = 60;
    private ScheduledReporter reporter = null;

    public SolrInfluxdbReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
    }

    protected void doInit() {
        String hostname;
        if (!this.enabled) {
            log.info("Reporter disabled for registry " + this.registryName);
            return;
        }
        if (this.reporter != null) {
            throw new IllegalStateException("Already started once?");
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unknown_host";
        }
        this.reporter = InfluxdbReporter.forRegistry((MetricRegistry)this.metricManager.registry(this.registryName)).protocol((InfluxdbProtocol)new HttpInfluxdbProtocol(this.scheme, this.host, this.port, this.user, this.password, this.db)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).skipIdleMetrics(false).tag("server_ip", hostname).transformer((MetricMeasurementTransformer)new CategoriesMetricMeasurementTransformer(new String[0])).build();
        this.reporter.start((long)this.period, TimeUnit.SECONDS);
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    protected void validate() throws IllegalStateException {
        if (this.host == null) {
            throw new IllegalStateException("Init argument 'host' must be set to a valid InfluxDB server name.");
        }
        if (this.port == -1) {
            throw new IllegalStateException("Init argument 'port' must be set to a valid InfluxDB server port.");
        }
        if (this.user == null) {
            throw new IllegalStateException("Init argument 'user' must be specified");
        }
        if (this.password == null) {
            throw new IllegalStateException("Init argument 'password' must be specified");
        }
        if (this.db == null) {
            throw new IllegalStateException("Init argument 'db' must be specified");
        }
        if (this.period < 1) {
            throw new IllegalStateException("Init argument 'period' is in time unit 'seconds' and must be at least 1.");
        }
    }

    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.close();
        }
    }
}

