let migrationName = '20160731_naming_day.js';
let authorName = 'Sabe'; // in case script author needs to know when their ...
let authorUuid = '7f14ed62-5408-4e1b-be83-ada62d504931'; // ... own data is done

/*
 * Award Royal Purple Gryphon pet to Royal Purple Gryphon mount owners, mount to everyone else
 */

let mongo = require('mongoskin');

let connectionString = 'mongodb://localhost:27017/habitrpg?auto_reconnect=true'; // FOR TEST DATABASE

let dbUsers = mongo.db(connectionString).collection('users');

// specify a query to limit the affected users (empty for all users):
let query = {
  migration: {$ne: migrationName},
  'auth.timestamps.loggedin': {$gt: new Date('2016-07-30')}, // Extend timeframe each run of migration
};

// specify fields we are interested in to limit retrieved data (empty if we're not reading data):
let fields = {
  'items.mounts': 1,
};

console.warn('Updating users...');
let progressCount = 1000;
let count = 0;
dbUsers.findEach(query, fields, {batchSize: 250}, function (err, user) {
  if (err) {
    return exiting(1, `ERROR! ${  err}`);
  }
  if (!user) {
    console.warn('All appropriate users found and modified.');
    setTimeout(displayData, 300000);
    return;
  }
  count++;

  // specify user data to change:
  let set = {};
  let inc = {};
  inc = {
    'achievements.habiticaDays': 1,
    'items.food.Cake_Skeleton': 1,
    'items.food.Cake_Base': 1,
    'items.food.Cake_CottonCandyBlue': 1,
    'items.food.Cake_CottonCandyPink': 1,
    'items.food.Cake_Shade': 1,
    'items.food.Cake_White': 1,
    'items.food.Cake_Golden': 1,
    'items.food.Cake_Zombie': 1,
    'items.food.Cake_Desert': 1,
    'items.food.Cake_Red': 1,
  };
  if (user.items.mounts['Gryphon-RoyalPurple']) {
    set = {migration: migrationName, 'items.pets.Gryphon-RoyalPurple': 5};
  } else {
    set = {migration: migrationName, 'items.mounts.Gryphon-RoyalPurple': true};
  }

  dbUsers.update({_id: user._id}, {$set: set, $inc: inc});

  if (count % progressCount === 0) console.warn(`${count  } ${  user._id}`);
  if (user._id === authorUuid) console.warn(`${authorName  } processed`);
});


function displayData () {
  console.warn(`\n${  count  } users processed\n`);
  return exiting(0);
}


function exiting (code, msg) {
  code = code || 0; // 0 = success
  if (code && !msg) {
    msg = 'ERROR!';
  }
  if (msg) {
    if (code) {
      console.error(msg);
    } else      {
      console.log(msg);
    }
  }
  process.exit(code);
}

