import pick from 'lodash/pick';
import content from '../content/index';
import { beastMasterProgress } from '../count';
import i18n from '../i18n';
import {
  NotAuthorized,
} from '../libs/errors';
import updateUserBalance from './updateUserBalance';

export default function releasePets (user, req = {}, analytics) {
  if (user.balance < 1) {
    throw new NotAuthorized(i18n.t('notEnoughGems', req.language));
  }

  if (beastMasterProgress(user.items.pets) !== 90) {
    throw new NotAuthorized(i18n.t('notEnoughPets', req.language));
  }

  updateUserBalance(user, -1, 'release_pets');

  let giveBeastMasterAchievement = true;

  const petInfo = content.petInfo[user.items.currentPet];

  if (petInfo && petInfo.type === 'drop') {
    user.items.currentPet = '';
  }

  for (const pet of Object.keys(content.pets)) {
    if (!user.items.pets[pet]) {
      giveBeastMasterAchievement = false;
    }
    user.items.pets[pet] = 0;
  }

  if (user.markModified) user.markModified('items.pets');

  if (giveBeastMasterAchievement) {
    if (!user.achievements.beastMasterCount) {
      user.achievements.beastMasterCount = 0;
    }
    user.achievements.beastMasterCount += 1;
  }

  if (analytics) {
    analytics.track('release pets', {
      user: pick(user, ['preferences', 'registeredThrough']),
      uuid: user._id,
      currency: 'Gems',
      gemCost: 4,
      category: 'behavior',
      headers: req.headers,
    });
  }

  return [
    user.items.pets,
    i18n.t('petsReleased'),
  ];
}
