# Строгий режим (strict mode)

Для включения строгого режима просто укажите `strict: true` при создании хранилища Vuex:

``` js
const store = new Vuex.Store({
  // ...
  strict: true
})
```

В строгом режиме любая попытка внесения изменений в состояние Vuex, кроме мутаций, будет выбрасывать ошибку. Это гарантирует, что все мутации состояния будут явно отслеживаться через инструменты отладки.

### Разработка vs production

**Не используйте строгий режим в production!** Строгий режим запускает глубокое отслеживание за деревом состояния приложения в синхронном режиме для обнаружения несоответствующих мутаций, и это может быть затратным для производительности, когда совершается большое количество мутаций. Убедитесь, что выключили этот режим в production чтобы избежать ухудшения производительности.

Аналогично плагинам, при использовании инструментов сборки это можно сделать так:

``` js
const store = new Vuex.Store({
  // ...
  strict: process.env.NODE_ENV !== 'production'
})
```
